/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.retry.PredefinedBackoffStrategies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.lambda.AWSLambda;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.lambda.deploy.exception.InvalidAccountException;
import com.netflix.spinnaker.config.LambdaServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;

public class LambdaClientProvider {
    @Autowired
    protected AmazonClientProvider amazonClientProvider;
    @Autowired
    protected LambdaServiceConfig operationsConfig;
    private String region;
    private NetflixAmazonCredentials credentials;

    public LambdaClientProvider(String region, NetflixAmazonCredentials credentials) {
        this.region = region;
        this.credentials = credentials;
    }

    protected AWSLambda getLambdaClient() {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setSocketTimeout(this.operationsConfig.getInvokeTimeoutMs());
        if (this.operationsConfig.getRetry().getRetries() >= 0) {
            clientConfiguration.setRetryPolicy(RetryPolicy.builder().withBackoffStrategy((RetryPolicy.BackoffStrategy)new PredefinedBackoffStrategies.SDKDefaultBackoffStrategy(100, 500, this.operationsConfig.getRetry().getTimeout() * 1000)).withMaxErrorRetry(this.operationsConfig.getRetry().getRetries()).build());
            clientConfiguration.setMaxErrorRetry(this.operationsConfig.getRetry().getRetries());
        }
        if (!this.credentials.getLambdaEnabled()) {
            throw new InvalidAccountException("AWS Lambda is not enabled for provided account. \n");
        }
        return this.amazonClientProvider.getAmazonLambda(this.credentials, clientConfiguration, this.region);
    }

    protected String getRegion() {
        return this.region;
    }

    protected NetflixAmazonCredentials getCredentials() {
        return this.credentials;
    }

    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }
}

