/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.provider.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.awsobjectmapper.AmazonObjectMapperConfigurer;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.core.limits.ServiceLimitConfiguration;
import com.netflix.spinnaker.clouddriver.lambda.provider.agent.IamRoleCachingAgent;
import com.netflix.spinnaker.clouddriver.lambda.provider.agent.LambdaCachingAgent;
import com.netflix.spinnaker.config.LambdaServiceConfig;
import com.netflix.spinnaker.credentials.Credentials;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LambdaAgentProvider
implements AgentProvider {
    private final ObjectMapper objectMapper = AmazonObjectMapperConfigurer.createConfigured();
    private final AmazonClientProvider amazonClientProvider;
    private final LambdaServiceConfig lambdaServiceConfig;
    private final ServiceLimitConfiguration serviceLimitConfiguration;

    @Autowired
    public LambdaAgentProvider(AmazonClientProvider amazonClientProvider, LambdaServiceConfig lambdaServiceConfig, ServiceLimitConfiguration serviceLimitConfiguration) {
        this.amazonClientProvider = amazonClientProvider;
        this.lambdaServiceConfig = lambdaServiceConfig;
        this.serviceLimitConfiguration = serviceLimitConfiguration;
    }

    public boolean supports(String providerName) {
        return providerName.equalsIgnoreCase(AwsProvider.PROVIDER_NAME);
    }

    public Collection<Agent> agents(Credentials credentials) {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        NetflixAmazonCredentials netflixAmazonCredentials = (NetflixAmazonCredentials)credentials;
        if (netflixAmazonCredentials.getLambdaEnabled()) {
            agents.add((Agent)new IamRoleCachingAgent(this.objectMapper, netflixAmazonCredentials, this.amazonClientProvider));
            for (AmazonCredentials.AWSRegion region : netflixAmazonCredentials.getRegions()) {
                agents.add((Agent)new LambdaCachingAgent(this.objectMapper, this.amazonClientProvider, netflixAmazonCredentials, region.getName(), this.lambdaServiceConfig, this.serviceLimitConfiguration));
            }
        }
        return agents;
    }
}

