/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.DeleteFunctionResult;
import com.netflix.spinnaker.clouddriver.lambda.cache.model.LambdaFunction;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.DeleteLambdaFunctionDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class DeleteLambdaAtomicOperation
extends AbstractLambdaAtomicOperation<DeleteLambdaFunctionDescription, DeleteFunctionResult>
implements AtomicOperation<DeleteFunctionResult> {
    public DeleteLambdaAtomicOperation(DeleteLambdaFunctionDescription description) {
        super(description, "DELETE_LAMBDA_FUNCTION_CODE");
    }

    public DeleteFunctionResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing deletion of AWS Lambda Function Operation...");
        return this.deleteFunctionResult();
    }

    private DeleteFunctionResult deleteFunctionResult() {
        String functionName = ((DeleteLambdaFunctionDescription)this.description).getFunctionName();
        String region = ((DeleteLambdaFunctionDescription)this.description).getRegion();
        String account = ((DeleteLambdaFunctionDescription)this.description).getAccount();
        LambdaFunction cache = (LambdaFunction)this.lambdaFunctionProvider.getFunction(account, region, functionName);
        AWSLambda client = this.getLambdaClient();
        if (cache != null && client != null) {
            DeleteFunctionRequest request = new DeleteFunctionRequest().withFunctionName(cache.getFunctionArn());
            request.withQualifier(((DeleteLambdaFunctionDescription)this.description).getQualifier());
            DeleteFunctionResult result = client.deleteFunction(request);
            this.updateTaskStatus("Finished deletion of AWS Lambda Function  Operation...");
            return result;
        }
        return null;
    }
}

