/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.provider.agent;

import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import com.netflix.frigga.Names;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupport;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.core.limits.ServiceLimitConfiguration;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.clouddriver.lambda.cache.Keys;
import com.netflix.spinnaker.clouddriver.lambda.service.LambdaService;
import com.netflix.spinnaker.config.LambdaServiceConfig;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaCachingAgent
implements CachingAgent,
AccountAware,
OnDemandAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LambdaCachingAgent.class);
    private static final Set<AgentDataType> types = new HashSet<AgentDataType>(){
        {
            this.add(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.LAMBDA_FUNCTIONS.ns));
            this.add(AgentDataType.Authority.INFORMATIVE.forType(Namespace.APPLICATIONS.ns));
        }
    };
    private final NetflixAmazonCredentials account;
    private final String region;
    private OnDemandMetricsSupport metricsSupport;
    private final Registry registry;
    private final Clock clock = Clock.systemDefaultZone();
    private LambdaService lambdaService;

    LambdaCachingAgent(ObjectMapper objectMapper, AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, LambdaServiceConfig lambdaServiceConfig, ServiceLimitConfiguration serviceLimitConfiguration) {
        this.account = account;
        this.region = region;
        this.registry = new DefaultRegistry();
        this.metricsSupport = new OnDemandMetricsSupport(this.registry, (OnDemandAgent)this, "aws:aws:" + OnDemandType.Function);
        this.lambdaService = new LambdaService(amazonClientProvider, account, region, objectMapper, lambdaServiceConfig);
    }

    public String getProviderName() {
        return AwsProvider.PROVIDER_NAME;
    }

    public String getAgentType() {
        return this.account.getName() + "/" + this.region + "/" + LambdaCachingAgent.class.getSimpleName();
    }

    public String getAccountName() {
        return this.account.getName();
    }

    public String getRegion() {
        return this.region;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        List<Map<String, Object>> allLambdas;
        long loadDataStart = this.clock.instant().toEpochMilli();
        log.info("Describing items in {}", (Object)this.getAgentType());
        ConcurrentHashMap<String, CacheData> lambdaCacheData = new ConcurrentHashMap<String, CacheData>();
        ConcurrentHashMap<String, Collection<String>> appLambdaRelationships = new ConcurrentHashMap<String, Collection<String>>();
        try {
            allLambdas = this.lambdaService.getAllFunctions();
        }
        catch (Exception e) {
            throw new SpinnakerException("Failed to populate the lambda cache for account '" + this.account.getName() + "' and region '" + this.region + "' because: " + e.getMessage());
        }
        this.buildCacheData(lambdaCacheData, appLambdaRelationships, allLambdas);
        ArrayList<DefaultCacheData> processedOnDemandCache = new ArrayList<DefaultCacheData>();
        Collection onDemandCacheData = providerCache.getAll(Namespace.ON_DEMAND.getNs(), providerCache.filterIdentifiers(Namespace.ON_DEMAND.getNs(), com.netflix.spinnaker.clouddriver.lambda.cache.Keys.getLambdaFunctionKey(this.getAccountName(), this.getRegion(), "*"))).stream().filter(d -> (Integer)d.getAttributes().get("processedCount") == 0).collect(Collectors.toList());
        for (Object onDemandItem : onDemandCacheData) {
            try {
                long cachedAt = (Long)onDemandItem.getAttributes().get("cacheTime");
                if (cachedAt > loadDataStart) {
                    CacheData currentLambda = (CacheData)lambdaCacheData.get(onDemandItem.getId());
                    if (currentLambda != null) {
                        LocalDateTime currentLambdaLastModified;
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                        LocalDateTime onDemandLastModified = LocalDateTime.parse((String)onDemandItem.getAttributes().get("lastModified"), formatter);
                        if (onDemandLastModified.isAfter(currentLambdaLastModified = LocalDateTime.parse((String)currentLambda.getAttributes().get("lastModified"), formatter))) {
                            lambdaCacheData.put(onDemandItem.getId(), (CacheData)onDemandItem);
                            String appKey = (String)((Collection)onDemandItem.getRelationships().get(Namespace.APPLICATIONS.ns)).stream().findFirst().get();
                            Collection functionkeys = appLambdaRelationships.getOrDefault(appKey, new ArrayList());
                            functionkeys.add(onDemandItem.getId());
                            appLambdaRelationships.put(appKey, functionkeys);
                        }
                    } else {
                        lambdaCacheData.put(onDemandItem.getId(), (CacheData)onDemandItem);
                        String appKey = (String)((Collection)onDemandItem.getRelationships().get(Namespace.APPLICATIONS.ns)).stream().findFirst().get();
                        Collection functionkeys = appLambdaRelationships.getOrDefault(appKey, new ArrayList());
                        functionkeys.add(onDemandItem.getId());
                        appLambdaRelationships.put(appKey, functionkeys);
                    }
                }
                Map attr = onDemandItem.getAttributes();
                attr.put("processedCount", 1);
                processedOnDemandCache.add(new DefaultCacheData(onDemandItem.getId(), attr, Collections.emptyMap()));
            }
            catch (Exception e) {
                log.warn("Failed to process onDemandCache for Lambda's: " + e.getMessage());
            }
        }
        LinkedList<DefaultCacheData> appCacheData = new LinkedList<DefaultCacheData>();
        for (String appKey : appLambdaRelationships.keySet()) {
            appCacheData.add(new DefaultCacheData(appKey, Collections.emptyMap(), Collections.singletonMap(Keys.Namespace.LAMBDA_FUNCTIONS.ns, (Collection)appLambdaRelationships.get(appKey))));
        }
        HashMap<String, Collection<Object>> cacheResults = new HashMap<String, Collection<Object>>();
        cacheResults.put(Keys.Namespace.LAMBDA_FUNCTIONS.ns, lambdaCacheData.values());
        cacheResults.put(Namespace.APPLICATIONS.ns, appCacheData);
        cacheResults.put(Namespace.ON_DEMAND.ns, processedOnDemandCache);
        Map<String, Collection<String>> evictions = this.computeEvictableData(lambdaCacheData.values(), providerCache);
        log.info("Caching {} items in {}", (Object)String.valueOf(lambdaCacheData.size()), (Object)this.getAgentType());
        return new DefaultCacheResult(cacheResults, evictions);
    }

    void buildCacheData(Map<String, CacheData> lambdaCacheData, Map<String, Collection<String>> appLambdaRelationships, List<Map<String, Object>> allLambdas) {
        allLambdas.stream().forEach(lf -> {
            String functionName = (String)lf.get("functionName");
            String functionKey = com.netflix.spinnaker.clouddriver.lambda.cache.Keys.getLambdaFunctionKey(this.getAccountName(), this.getRegion(), functionName);
            Names names = Names.parseName((String)functionName);
            if (names.getApp() != null) {
                String appKey = Keys.getApplicationKey((String)names.getApp());
                appLambdaRelationships.compute(appKey, (k, v) -> {
                    ArrayList<String> fKeys = v;
                    if (fKeys == null) {
                        fKeys = new ArrayList<String>();
                    }
                    fKeys.add(functionKey);
                    return fKeys;
                });
                lambdaCacheData.put(functionKey, (CacheData)new DefaultCacheData(functionKey, lf, Collections.singletonMap(Namespace.APPLICATIONS.ns, Collections.singletonList(appKey))));
            } else {
                lambdaCacheData.put(functionKey, (CacheData)new DefaultCacheData(functionKey, lf, Collections.emptyMap()));
            }
        });
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return type.equals((Object)OnDemandType.Function) && cloudProvider.equals("aws");
    }

    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ?> data) {
        Map<String, Collection<Object>> evictions;
        DefaultCacheResult defaultCacheResult;
        Map<String, Object> lambdaAttributes;
        String appKey;
        String functionKey;
        block5: {
            if (!(this.validKeys(data).booleanValue() && data.get("account").equals(this.getAccountName()) && data.get("region").equals(this.region))) {
                return null;
            }
            String appName = (String)data.get("appName");
            String functionName = this.combineAppDetail(appName, (String)data.get("functionName"));
            functionKey = com.netflix.spinnaker.clouddriver.lambda.cache.Keys.getLambdaFunctionKey((String)data.get("credentials"), (String)data.get("region"), functionName);
            appKey = Keys.getApplicationKey((String)appName);
            lambdaAttributes = null;
            try {
                lambdaAttributes = this.lambdaService.getFunctionByName(functionName);
            }
            catch (Exception e) {
                if (e instanceof ResourceNotFoundException) break block5;
                throw new SpinnakerException("Failed to populate the onDemandCache for lambda '" + functionName + "'");
            }
        }
        if (lambdaAttributes != null && !lambdaAttributes.isEmpty()) {
            lambdaAttributes.put("cacheTime", this.clock.instant().toEpochMilli());
            lambdaAttributes.put("processedCount", 0);
            DefaultCacheData lambdaCacheData = new DefaultCacheData(functionKey, lambdaAttributes, Collections.singletonMap(Namespace.APPLICATIONS.ns, Collections.singletonList(appKey)));
            defaultCacheResult = new DefaultCacheResult(Collections.singletonMap(Namespace.ON_DEMAND.ns, Collections.singletonList(lambdaCacheData)));
            evictions = Collections.emptyMap();
        } else {
            defaultCacheResult = new DefaultCacheResult(Collections.singletonMap(Keys.Namespace.LAMBDA_FUNCTIONS.ns, Collections.emptyList()));
            evictions = Collections.singletonMap(Keys.Namespace.LAMBDA_FUNCTIONS.ns, providerCache.filterIdentifiers(Keys.Namespace.LAMBDA_FUNCTIONS.ns, functionKey));
        }
        return new OnDemandAgent.OnDemandResult(this.getAgentType(), (CacheResult)defaultCacheResult, evictions);
    }

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        Collection keys = providerCache.filterIdentifiers(Namespace.ON_DEMAND.getNs(), com.netflix.spinnaker.clouddriver.lambda.cache.Keys.getLambdaFunctionKey(this.account.getName(), this.getRegion(), "*"));
        return providerCache.getAll(Namespace.ON_DEMAND.getNs(), keys, (CacheFilter)RelationshipCacheFilter.none()).stream().map(it -> {
            String lambdaId = it.getId();
            Map<String, String> details = com.netflix.spinnaker.clouddriver.lambda.cache.Keys.parse(lambdaId);
            Map attributes = it.getAttributes();
            HashMap<String, Object> resp = new HashMap<String, Object>();
            resp.put("id", lambdaId);
            resp.put("details", details);
            resp.put("attributes", it.getAttributes());
            resp.put("cacheTime", attributes.get("cacheTime"));
            resp.put("processedCount", attributes.get("processedCount"));
            resp.put("processedTime", attributes.getOrDefault("processedTime", null));
            return resp;
        }).collect(Collectors.toSet());
    }

    public String getOnDemandAgentType() {
        return this.getAgentType() + "-OnDemand";
    }

    public OnDemandMetricsSupport getMetricsSupport() {
        return this.metricsSupport;
    }

    private Boolean validKeys(Map<String, ? extends Object> data) {
        return data.containsKey("functionName") && data.containsKey("credentials") && data.containsKey("region");
    }

    protected String combineAppDetail(String appName, String functionName) {
        Names functionAppName = Names.parseName((String)functionName);
        if (null != functionAppName) {
            return functionAppName.getApp().equals(appName) ? functionName : appName + "-" + functionName;
        }
        throw new IllegalArgumentException(String.format("Function name {%s} contains invlaid charachetrs ", functionName));
    }

    String getAuthoritativeKeyName() {
        Collection authoritativeNamespaces = this.getProvidedDataTypes().stream().filter(agentDataType -> agentDataType.getAuthority().equals((Object)AgentDataType.Authority.AUTHORITATIVE)).collect(Collectors.toSet());
        if (authoritativeNamespaces.size() != 1) {
            throw new RuntimeException("LambdaCachingAgent supports only one authoritative key namespace. " + authoritativeNamespaces.size() + " authoritative key namespace were given.");
        }
        return ((AgentDataType)authoritativeNamespaces.iterator().next()).getTypeName();
    }

    Map<String, Collection<String>> computeEvictableData(Collection<CacheData> newData, ProviderCache providerCache) {
        String authoritativeKeyName = this.getAuthoritativeKeyName();
        Set oldKeys = providerCache.getIdentifiers(authoritativeKeyName).stream().filter(key -> {
            Map<String, String> keyParts = com.netflix.spinnaker.clouddriver.lambda.cache.Keys.parse(key);
            return keyParts.get("account").equalsIgnoreCase(this.account.getName()) && keyParts.get("region").equalsIgnoreCase(this.region);
        }).collect(Collectors.toSet());
        Set newKeys = newData.stream().map(CacheData::getId).collect(Collectors.toSet());
        Set evictedKeys = oldKeys.stream().filter(oldKey -> !newKeys.contains(oldKey)).collect(Collectors.toSet());
        HashMap<String, Collection<String>> evictionsByKey = new HashMap<String, Collection<String>>();
        evictionsByKey.put(this.getAuthoritativeKeyName(), evictedKeys);
        String prettyKeyName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.getAuthoritativeKeyName());
        log.info("Evicting " + evictedKeys.size() + " " + prettyKeyName + (evictedKeys.size() > 1 ? "s" : "") + " in " + this.getAgentType());
        return evictionsByKey;
    }
}

