/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.service;

import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.AliasConfiguration;
import com.amazonaws.services.lambda.model.EventSourceMappingConfiguration;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.GetPolicyRequest;
import com.amazonaws.services.lambda.model.GetPolicyResult;
import com.amazonaws.services.lambda.model.ListAliasesRequest;
import com.amazonaws.services.lambda.model.ListAliasesResult;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsRequest;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsResult;
import com.amazonaws.services.lambda.model.ListFunctionsRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionRequest;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionResult;
import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.aws.data.ArnUtils;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.LambdaClientProvider;
import com.netflix.spinnaker.config.LambdaServiceConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LambdaService
extends LambdaClientProvider {
    @Generated
    private static final Logger log = LogManager.getLogger(LambdaService.class);
    private final ObjectMapper mapper;
    private static final Predicate<Statement> isLambdaInvokeAction = statement -> statement.getActions().stream().anyMatch(action -> "lambda:InvokeFunction".equals(action.getActionName()));
    private static final Predicate<Statement> isElbPrincipal = statement -> statement.getPrincipals().stream().anyMatch(principal -> "elasticloadbalancing.amazonaws.com".equals(principal.getId()));

    public LambdaService(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, ObjectMapper mapper, LambdaServiceConfig lambdaServiceConfig) {
        super(region, account);
        this.operationsConfig = lambdaServiceConfig;
        this.amazonClientProvider = amazonClientProvider;
        this.mapper = mapper;
    }

    public List<Map<String, Object>> getAllFunctions() {
        List<FunctionConfiguration> functions = this.listAllFunctionConfigurations();
        List hydratedFunctionList = Collections.synchronizedList(new ArrayList());
        functions.stream().forEach(f -> {
            ConcurrentHashMap<String, Object> functionAttributes = new ConcurrentHashMap<String, Object>();
            this.addBaseAttributes(functionAttributes, f.getFunctionName());
            this.addRevisionsAttributes(functionAttributes, f.getFunctionName());
            this.addAliasAndEventSourceMappingConfigurationAttributes(functionAttributes, f.getFunctionName());
            this.addTargetGroupAttributes(functionAttributes, f.getFunctionName());
            hydratedFunctionList.add(functionAttributes);
        });
        return hydratedFunctionList.stream().filter(lf -> lf.get("functionName") != null).collect(Collectors.toList());
    }

    public Map<String, Object> getFunctionByName(String functionName) throws InterruptedException {
        List functionTasks = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<String, Object> functionAttributes = new ConcurrentHashMap<String, Object>();
        this.addBaseAttributes(functionAttributes, functionName);
        if (functionAttributes.isEmpty()) {
            return null;
        }
        this.addRevisionsAttributes(functionAttributes, functionName);
        this.addAliasAndEventSourceMappingConfigurationAttributes(functionAttributes, functionName);
        this.addTargetGroupAttributes(functionAttributes, functionName);
        return functionAttributes;
    }

    public List<FunctionConfiguration> listAllFunctionConfigurations() {
        ListFunctionsResult listFunctionsResult;
        AWSLambda lambda = this.getLambdaClient();
        String nextMarker = null;
        ArrayList<FunctionConfiguration> lstFunction = new ArrayList<FunctionConfiguration>();
        do {
            ListFunctionsRequest listFunctionsRequest = new ListFunctionsRequest();
            if (nextMarker != null) {
                listFunctionsRequest.setMarker(nextMarker);
            }
            if ((listFunctionsResult = lambda.listFunctions(listFunctionsRequest)) == null) break;
            lstFunction.addAll(listFunctionsResult.getFunctions());
        } while ((nextMarker = listFunctionsResult.getNextMarker()) != null && nextMarker.length() != 0);
        return lstFunction;
    }

    private Void addBaseAttributes(Map<String, Object> functionAttributes, String functionName) {
        GetFunctionResult result = this.getLambdaClient().getFunction(new GetFunctionRequest().withFunctionName(functionName));
        if (result == null) {
            return null;
        }
        Map attr = (Map)this.mapper.convertValue((Object)result.getConfiguration(), Map.class);
        attr.put("account", this.getCredentials().getName());
        attr.put("region", this.getRegion());
        attr.put("code", result.getCode());
        attr.put("tags", result.getTags());
        attr.put("concurrency", result.getConcurrency());
        attr.values().removeAll(Collections.singleton(null));
        functionAttributes.putAll(attr);
        return null;
    }

    private Void addRevisionsAttributes(Map<String, Object> functionAttributes, String functionName) {
        Map<String, String> revisions = this.listFunctionRevisions(functionName);
        functionAttributes.put("revisions", revisions);
        return null;
    }

    private Map<String, String> listFunctionRevisions(String functionName) {
        ListVersionsByFunctionResult listVersionsByFunctionResult;
        AWSLambda lambda = this.getLambdaClient();
        String nextMarker = null;
        HashMap<String, String> listRevionIds = new HashMap<String, String>();
        do {
            ListVersionsByFunctionRequest listVersionsByFunctionRequest = new ListVersionsByFunctionRequest();
            listVersionsByFunctionRequest.setFunctionName(functionName);
            if (nextMarker != null) {
                listVersionsByFunctionRequest.setMarker(nextMarker);
            }
            if ((listVersionsByFunctionResult = lambda.listVersionsByFunction(listVersionsByFunctionRequest)) == null) {
                return listRevionIds;
            }
            for (FunctionConfiguration x : listVersionsByFunctionResult.getVersions()) {
                listRevionIds.put(x.getRevisionId(), x.getVersion());
            }
        } while ((nextMarker = listVersionsByFunctionResult.getNextMarker()) != null && nextMarker.length() != 0);
        return listRevionIds;
    }

    private Void addAliasAndEventSourceMappingConfigurationAttributes(Map<String, Object> functionAttributes, String functionName) {
        List<AliasConfiguration> aliasConfigurationList = this.listAliasConfiguration(functionName);
        functionAttributes.put("aliasConfigurations", aliasConfigurationList);
        List<EventSourceMappingConfiguration> eventSourceMappingConfigurationsList = this.listEventSourceMappingConfiguration(functionName);
        for (AliasConfiguration currAlias : aliasConfigurationList) {
            List<EventSourceMappingConfiguration> currAliasEvents = this.listEventSourceMappingConfiguration(currAlias.getAliasArn());
            eventSourceMappingConfigurationsList.addAll(currAliasEvents);
        }
        functionAttributes.put("eventSourceMappings", eventSourceMappingConfigurationsList);
        return null;
    }

    private List<AliasConfiguration> listAliasConfiguration(String functionName) {
        ListAliasesResult listAliasesResult;
        AWSLambda lambda = this.getLambdaClient();
        String nextMarker = null;
        ArrayList<AliasConfiguration> aliasConfigurations = new ArrayList<AliasConfiguration>();
        do {
            ListAliasesRequest listAliasesRequest = new ListAliasesRequest();
            listAliasesRequest.setFunctionName(functionName);
            if (nextMarker != null) {
                listAliasesRequest.setMarker(nextMarker);
            }
            if ((listAliasesResult = lambda.listAliases(listAliasesRequest)) == null) {
                return aliasConfigurations;
            }
            for (AliasConfiguration x : listAliasesResult.getAliases()) {
                aliasConfigurations.add(x);
            }
        } while ((nextMarker = listAliasesResult.getNextMarker()) != null && nextMarker.length() != 0);
        return aliasConfigurations;
    }

    private List<EventSourceMappingConfiguration> listEventSourceMappingConfiguration(String functionName) {
        ListEventSourceMappingsResult listEventSourceMappingsResult;
        ArrayList<EventSourceMappingConfiguration> eventSourceMappingConfigurations = new ArrayList<EventSourceMappingConfiguration>();
        AWSLambda lambda = this.getLambdaClient();
        String nextMarker = null;
        do {
            ListEventSourceMappingsRequest listEventSourceMappingsRequest = new ListEventSourceMappingsRequest();
            listEventSourceMappingsRequest.setFunctionName(functionName);
            if (nextMarker != null) {
                listEventSourceMappingsRequest.setMarker(nextMarker);
            }
            if ((listEventSourceMappingsResult = lambda.listEventSourceMappings(listEventSourceMappingsRequest)) == null) {
                return eventSourceMappingConfigurations;
            }
            for (EventSourceMappingConfiguration x : listEventSourceMappingsResult.getEventSourceMappings()) {
                eventSourceMappingConfigurations.add(x);
            }
        } while ((nextMarker = listEventSourceMappingsResult.getNextMarker()) != null && nextMarker.length() != 0);
        return eventSourceMappingConfigurations;
    }

    private Void addTargetGroupAttributes(Map<String, Object> functionAttributes, String functionName) {
        List<String> targetGroups = this.getTargetGroupNames(functionName);
        functionAttributes.put("targetGroups", targetGroups);
        return null;
    }

    private List<String> getTargetGroupNames(String functionName) {
        List<String> targetGroupNames = new ArrayList<String>();
        Predicate<Statement> isAllowStatement = statement -> statement.getEffect().toString().equals(Statement.Effect.Allow.toString());
        try {
            AWSLambda lambda = this.getLambdaClient();
            GetPolicyResult result = lambda.getPolicy(new GetPolicyRequest().withFunctionName(functionName));
            Policy policy = Policy.fromJson((String)result.getPolicy());
            targetGroupNames = policy.getStatements().stream().filter(isAllowStatement.and(isLambdaInvokeAction).and(isElbPrincipal)).flatMap(statement -> statement.getConditions().stream()).filter(condition -> "ArnLike".equals(condition.getType()) && "AWS:SourceArn".equals(condition.getConditionKey())).flatMap(condition -> condition.getValues().stream()).flatMap(value -> ArnUtils.extractTargetGroupName((String)value).stream()).collect(Collectors.toList());
        }
        catch (ResourceNotFoundException | NullPointerException e) {
            log.info("Unable to find target group names for {}", (Object)functionName);
        }
        return targetGroupNames;
    }
}

