/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.deploy.validator;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public abstract class StandardOracleAttributeValidator<T>
extends DescriptionValidator<T>
implements GroovyObject {
    protected String context;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public StandardOracleAttributeValidator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Object validateNotEmptyString(ValidationErrors errors, String value, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, value) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        return true;
    }

    public Object validateNonNegative(ValidationErrors errors, int value, String attribute) {
        Boolean result = null;
        if (value >= 0) {
            result = true;
        } else {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
            result = false;
        }
        return result;
    }

    public Object validatePositive(ValidationErrors errors, int value, String attribute) {
        Boolean result = null;
        if (value > 0) {
            result = true;
        } else {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notPositive"}));
            result = false;
        }
        return result;
    }

    public Object validateCapacity(ValidationErrors errors, Integer min, Integer max, Integer desired) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)min, null) && ScriptBytecodeAdapter.compareNotEqual((Object)max, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)min, (Object)max)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "capacity", new GStringImpl(new Object[]{this.context}, new String[]{"", ".capacity.transposed"}), ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{min, max}), String[].class)), String[].class), new GStringImpl(new Object[]{min, max}, new String[]{"min size (", ") > max size (", ")"}));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)desired, null) && (ScriptBytecodeAdapter.compareNotEqual((Object)min, null) && ScriptBytecodeAdapter.compareLessThan((Object)desired, (Object)min) || ScriptBytecodeAdapter.compareNotEqual((Object)max, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)desired, (Object)max))) {
            return IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "capacity", new GStringImpl(new Object[]{this.context}, new String[]{"", ".desired.capacity.not.in.range"}), ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{min, max, desired}), String[].class)), String[].class), new GStringImpl(new Object[]{desired, min, max}, new String[]{"desired capacity (", ") is not within min/max (", "/", ") range"}));
        }
        return null;
    }

    public Object validateLimit(ValidationErrors errors, String value, int limit, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, value) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)IndyInterface.bootstrap("invoke", "length", 0, value), (Object)limit)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".exceedsLimit"}));
        }
        return true;
    }

    public Object validateNotNull(ValidationErrors errors, Object value, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, value) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".null"}));
            return false;
        }
        return true;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != StandardOracleAttributeValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

