/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.deploy.validator;

import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.oracle.OracleOperation;
import com.netflix.spinnaker.clouddriver.oracle.deploy.description.UpsertLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.oracle.deploy.validator.StandardOracleAttributeValidator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@OracleOperation(value="upsertLoadBalancer")
@Component(value="upsertLoadBalancerDescriptionValidator")
class UpsertLoadBalancerDescriptionValidator
extends StandardOracleAttributeValidator<UpsertLoadBalancerDescription> {
    Set<String> validShapes = Stream.of("100Mbps", "400Mbps", "8000Mbps").collect(Collectors.toSet());

    UpsertLoadBalancerDescriptionValidator() {
    }

    public void validate(List priorDescriptions, UpsertLoadBalancerDescription description, ValidationErrors errors) {
        this.context = "upsertLoadBalancerDescriptionValidator";
        this.validateNotEmptyString(errors, description.getApplication(), "application");
        if (description.getLoadBalancerId() == null) {
            this.validateNotEmptyString(errors, description.getShape(), "shape");
            if (!this.validShapes.contains(description.getShape())) {
                errors.rejectValue("${context}.shape", "${context}.shape.invalidLoadBalancerShape");
            }
            if (!description.getIsPrivate().booleanValue() && description.getSubnetIds().size() <= 1) {
                Map<String, String> type = description.getSubnetTypeMap();
                if (description.getSubnetIds().size() == 1) {
                    if (type.containsKey(description.getSubnetIds().get(0)) && type.get(description.getSubnetIds().get(0)).compareTo("Regional") != 0) {
                        errors.rejectValue("${context}.CreateServerGroupAtomicOperation", "${context}.subnetIds.publicLoadBalancerRequiresTwoSubnets");
                    }
                } else {
                    errors.rejectValue("${context}.CreateServerGroupAtomicOperation", "${context}.subnetIds.publicLoadBalancerRequiresTwoSubnets");
                }
            }
        }
        if (description.getCertificates() != null) {
            description.getCertificates().forEach((name, certificate) -> {
                this.validateNotEmptyString(errors, certificate.getCertificateName(), "certificate.certificateName");
                if (certificate.getPublicCertificate() != null) {
                    this.validateNotEmptyString(errors, certificate.getPrivateKey(), "certificate.privateKey");
                    this.validateNotEmptyString(errors, certificate.getPublicCertificate(), "certificate.publicCertificate");
                }
            });
        }
        if (description.getBackendSets() != null) {
            description.getBackendSets().forEach((name, backendSet) -> {
                this.validateLimit(errors, (String)name, 32, "backendSet.name");
                this.validateNotNull(errors, backendSet.getHealthChecker(), "backendSet.healthChecker");
                this.validateNotEmptyString(errors, backendSet.getPolicy(), "backendSet.policy");
                if (backendSet.getHealthChecker() != null) {
                    this.validateNotEmptyString(errors, backendSet.getHealthChecker().getProtocol(), "backendSet.healthChecker.protocol");
                    this.validateNotNull(errors, backendSet.getHealthChecker().getPort(), "backendSet.healthChecker.port");
                    this.validateNotEmptyString(errors, backendSet.getHealthChecker().getUrlPath(), "backendSet.healthChecker.urlPath");
                }
            });
        }
        if (description.getListeners() != null) {
            description.getListeners().forEach((name, listener) -> {
                this.validateNotEmptyString(errors, listener.getDefaultBackendSetName(), "listener.defaultBackendSetName");
                this.validateNotEmptyString(errors, listener.getProtocol(), "listener.protocol");
                this.validateNotNull(errors, listener.getPort(), "listener.port");
            });
        }
    }
}

