/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.controller;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.mem.InMemoryCache;
import com.netflix.spinnaker.clouddriver.oracle.model.OracleImage;
import com.netflix.spinnaker.clouddriver.oracle.provider.view.OracleImageProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oracle/images"})
public class OracleImageLookupController
implements GroovyObject {
    private final OracleImageProvider imageProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public OracleImageLookupController(OracleImageProvider imageProvider) {
        OracleImageProvider oracleImageProvider;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.imageProvider = oracleImageProvider = imageProvider;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{account}/{region}/{imageId:.+}"})
    public List<OracleImage> getById(@PathVariable String account, @PathVariable String region, @PathVariable String imageId) {
        Reference imageId2 = new Reference((Object)imageId);
        CallSite images = IndyInterface.bootstrap("invoke", "getByAccountAndRegion", 0, this.imageProvider, account, region);
        if (IndyInterface.bootstrap("cast", "()", 0, images) != false) {
            public final class _getById_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference imageId;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getById_closure1(Object _outerInstance, Object _thisObject, Reference imageId) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.imageId = reference = imageId;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "id", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.imageId.get()));
                }

                @Generated
                public String getImageId() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.imageId.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getById_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "find", 0, images, new _getById_closure1(this, this, imageId2))});
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/find"})
    public Set<OracleImage> find(@RequestParam(required=false) String account, @RequestParam(required=false) String q, HttpServletRequest request) {
        CallSite results = null;
        CallSite images = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.imageProvider));
        if (IndyInterface.bootstrap("cast", "()", 0, images) == false) {
            results = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "emptySet", 0, Collections.class));
        } else {
            public final class _find_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _find_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(OracleImage a, OracleImage b) {
                    return ScriptBytecodeAdapter.compareTo((Object)IndyInterface.bootstrap("getProperty", "name", 4, a), (Object)IndyInterface.bootstrap("getProperty", "name", 4, b));
                }

                @Generated
                public Object call(OracleImage a, OracleImage b) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, a, b);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _find_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            results = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "stream", 0, images), IndyInterface.bootstrap("invoke", "toSet", 0, Collectors.class)), new _find_closure2(this, this)));
            Reference pattern = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveQueryToPattern", 2, this, q)));
            Reference tagFilters = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractTagFilters", 0, OracleImageLookupController.class, request)));
            public final class _find_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference pattern;
                private /* synthetic */ Reference tagFilters;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _find_closure3(Object _outerInstance, Object _thisObject, Reference pattern, Reference tagFilters) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.pattern = reference2 = pattern;
                    this.tagFilters = reference = tagFilters;
                }

                public Object doCall(Object it) {
                    return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matches", 0, IndyInterface.bootstrap("invoke", "matcher", 0, IndyInterface.bootstrap("cast", "()", 0, this.pattern.get()), IndyInterface.bootstrap("getProperty", "name", 0, it)))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matchImageByTagFilters", 2, this, it, IndyInterface.bootstrap("cast", "()", 0, this.tagFilters.get())));
                }

                @Generated
                public Pattern getPattern() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.pattern.get());
                }

                @Generated
                public Map getTagFilters() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.tagFilters.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _find_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            results = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, results, new _find_closure3(this, this, pattern, tagFilters)));
        }
        return results;
    }

    private Object matchImageByTagFilters(OracleImage image, Map<String, String> tagFilters) {
        Reference image2 = new Reference((Object)image);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, tagFilters)) != false) {
            return true;
        }
        public final class _matchImageByTagFilters_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference image;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _matchImageByTagFilters_closure4(Object _outerInstance, Object _thisObject, Reference image) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.image = reference = image;
            }

            public Object doCall(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 1, IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "freeformTags", 4, IndyInterface.bootstrap("cast", "()", 0, this.image.get())), k), v);
            }

            @Generated
            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            @Generated
            public OracleImage getImage() {
                return IndyInterface.bootstrap("cast", "()", 0, this.image.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _matchImageByTagFilters_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "every", 0, tagFilters, new _matchImageByTagFilters_closure4(this, this, image2));
    }

    public static Map<String, String> extractTagFilters(HttpServletRequest httpServletRequest) {
        Reference httpServletRequest2 = new Reference((Object)httpServletRequest);
        public final class _extractTagFilters_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractTagFilters_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, it), "tag:");
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractTagFilters_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _extractTagFilters_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference httpServletRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractTagFilters_closure6(Object _outerInstance, Object _thisObject, Reference httpServletRequest) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.httpServletRequest = reference = httpServletRequest;
            }

            public Object doCall(String tagParameter) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, tagParameter, "tag:", "")), IndyInterface.bootstrap("invoke", "getParameter", 0, IndyInterface.bootstrap("cast", "()", 0, this.httpServletRequest.get()), tagParameter)});
            }

            @Generated
            public Object call(String tagParameter) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tagParameter);
            }

            @Generated
            public HttpServletRequest getHttpServletRequest() {
                return IndyInterface.bootstrap("cast", "()", 0, this.httpServletRequest.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractTagFilters_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "getParameterNames", 0, (HttpServletRequest)httpServletRequest2.get()), new _extractTagFilters_closure5(OracleImageLookupController.class, OracleImageLookupController.class)), new _extractTagFilters_closure6(OracleImageLookupController.class, OracleImageLookupController.class, httpServletRequest2)));
    }

    public Pattern resolveQueryToPattern(String query) {
        CallSite callSite = IndyInterface.bootstrap("invoke", "trim", 1, query);
        CallSite glob = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "*");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, glob, "*")) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, glob, "?")) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, glob, "[")) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, glob, "\\")) == false) {
            glob = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{glob}, new String[]{"*", "*"}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toPattern", 0, IndyInterface.bootstrap("init", "<init>", 0, InMemoryCache.Glob.class, glob)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OracleImageLookupController.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.oracle.controller.OracleImageLookupController");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final OracleImageProvider getImageProvider() {
        return this.imageProvider;
    }
}

