/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.deploy.handler;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeployDescription;
import com.netflix.spinnaker.clouddriver.deploy.DeployHandler;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.oracle.deploy.OracleServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.oracle.deploy.OracleWorkRequestPoller;
import com.netflix.spinnaker.clouddriver.oracle.deploy.description.BasicOracleDeployDescription;
import com.netflix.spinnaker.clouddriver.oracle.model.Details;
import com.netflix.spinnaker.clouddriver.oracle.model.OracleServerGroup;
import com.netflix.spinnaker.clouddriver.oracle.provider.view.OracleClusterProvider;
import com.netflix.spinnaker.clouddriver.oracle.service.servergroup.OracleServerGroupService;
import com.oracle.bmc.core.requests.GetVnicRequest;
import com.oracle.bmc.core.requests.ListVnicAttachmentsRequest;
import com.oracle.bmc.loadbalancer.model.BackendDetails;
import com.oracle.bmc.loadbalancer.model.BackendSet;
import com.oracle.bmc.loadbalancer.model.UpdateBackendSetDetails;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendSetRequest;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasicOracleDeployHandler
implements DeployHandler<BasicOracleDeployDescription>,
GroovyObject {
    private static final String BASE_PHASE = "DEPLOY";
    @Autowired
    private OracleServerGroupService oracleServerGroupService;
    @Autowired
    private OracleClusterProvider clusterProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public BasicOracleDeployHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public boolean handles(DeployDescription description) {
        return description instanceof BasicOracleDeployDescription;
    }

    public DeploymentResult handle(BasicOracleDeployDescription description, List priorOutputs) {
        CallSite callSite;
        Reference description2 = new Reference((Object)description);
        CallSite region = IndyInterface.bootstrap("getProperty", "region", 4, (BasicOracleDeployDescription)description2.get());
        CallSite serverGroupNameResolver = IndyInterface.bootstrap("init", "<init>", 0, OracleServerGroupNameResolver.class, this.oracleServerGroupService, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicOracleDeployDescription)description2.get()), region);
        CallSite clusterName = IndyInterface.bootstrap("invoke", "combineAppStackDetail", 0, serverGroupNameResolver, IndyInterface.bootstrap("getProperty", "application", 4, (BasicOracleDeployDescription)description2.get()), IndyInterface.bootstrap("getProperty", "stack", 4, (BasicOracleDeployDescription)description2.get()), IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, (BasicOracleDeployDescription)description2.get()));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{clusterName}, new String[]{"Initializing creation of server group for cluster ", " ..."}));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Looking up next sequence...");
        CallSite serverGroupName = IndyInterface.bootstrap("invoke", "resolveNextServerGroupName", 0, serverGroupNameResolver, IndyInterface.bootstrap("getProperty", "application", 4, (BasicOracleDeployDescription)description2.get()), IndyInterface.bootstrap("getProperty", "stack", 4, (BasicOracleDeployDescription)description2.get()), IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, (BasicOracleDeployDescription)description2.get()), false);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName}, new String[]{"Produced server group name: ", ""}));
        Map launchConfig = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"availabilityDomain", IndyInterface.bootstrap("getProperty", "availabilityDomain", 4, (BasicOracleDeployDescription)description2.get()), "compartmentId", IndyInterface.bootstrap("getProperty", "compartmentId", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicOracleDeployDescription)description2.get())), "imageId", IndyInterface.bootstrap("getProperty", "imageId", 4, (BasicOracleDeployDescription)description2.get()), "shape", IndyInterface.bootstrap("getProperty", "shape", 4, (BasicOracleDeployDescription)description2.get()), "vpcId", IndyInterface.bootstrap("getProperty", "vpcId", 4, (BasicOracleDeployDescription)description2.get()), "subnetId", IndyInterface.bootstrap("getProperty", "subnetId", 4, (BasicOracleDeployDescription)description2.get()), "sshAuthorizedKeys", IndyInterface.bootstrap("getProperty", "sshAuthorizedKeys", 4, (BasicOracleDeployDescription)description2.get()), "createdTime", IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class)});
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "targetSize", 4, (BasicOracleDeployDescription)description2.get());
        int targetSize = DefaultTypeTransformation.intUnbox((Object)(IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : (IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("getProperty", "desired", 1, IndyInterface.bootstrap("getProperty", "capacity", 4, (BasicOracleDeployDescription)description2.get()))) != false ? callSite : Integer.valueOf(0))));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName, targetSize}, new String[]{"Composing server group ", " with ", " instance(s) "}));
        CallSite sg = IndyInterface.bootstrap("init", "<init>", 0, OracleServerGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", serverGroupName, "region", IndyInterface.bootstrap("getProperty", "region", 4, (BasicOracleDeployDescription)description2.get()), "zone", IndyInterface.bootstrap("getProperty", "availabilityDomain", 4, (BasicOracleDeployDescription)description2.get()), "launchConfig", launchConfig, "targetSize", targetSize, "credentials", IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicOracleDeployDescription)description2.get()), "loadBalancerId", IndyInterface.bootstrap("getProperty", "loadBalancerId", 4, (BasicOracleDeployDescription)description2.get())}));
        IndyInterface.bootstrap("invoke", "createServerGroup", 0, this.oracleServerGroupService, IndyInterface.bootstrap("getProperty", "task", 12, this), sg);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName}, new String[]{"Done creating server group ", "."}));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "loadBalancerId", 4, (BasicOracleDeployDescription)description2.get())) != false) {
            CallSite lb = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "loadBalancer", 0, IndyInterface.bootstrap("invoke", "getLoadBalancer", 0, IndyInterface.bootstrap("getProperty", "loadBalancerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicOracleDeployDescription)description2.get())), IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "loadBalancerId", 0, IndyInterface.bootstrap("invoke", "builder", 0, GetLoadBalancerRequest.class), IndyInterface.bootstrap("getProperty", "loadBalancerId", 4, (BasicOracleDeployDescription)description2.get()))))));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "displayName", 0, lb), IndyInterface.bootstrap("getProperty", "backendSetName", 4, (BasicOracleDeployDescription)description2.get())}, new String[]{"Updating LoadBalancer ", " with backendSet ", ""}));
            CallSite sgView = null;
            long finishBy = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class), IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class), 30)));
            boolean allUp = false;
            while (!allUp && ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class), (Object)finishBy)) {
                sgView = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroup", 0, this.clusterProvider, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "credentials", 0, sg)), IndyInterface.bootstrap("getProperty", "region", 0, sg), IndyInterface.bootstrap("getProperty", "name", 0, sg)));
                if (DefaultTypeTransformation.booleanUnbox((Object)sgView) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "up", 0, IndyInterface.bootstrap("getProperty", "instanceCounts", 0, sgView)), (Object)IndyInterface.bootstrap("getProperty", "total", 0, IndyInterface.bootstrap("getProperty", "instanceCounts", 0, sgView)))) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "All instances are Up");
                    allUp = true;
                    break;
                }
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Waiting for server group instances to get to Up state");
                IndyInterface.bootstrap("invoke", "sleep", 0, Thread.class, 5000);
            }
            if (!allUp) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Timed out waiting for server group instances to get to Up state");
                IndyInterface.bootstrap("invoke", "fail", 0, IndyInterface.bootstrap("getProperty", "task", 12, this));
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Looking up instance IP addresses");
            Reference ips = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            public final class _handle_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference description;
                private /* synthetic */ Reference ips;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure1(Object _outerInstance, Object _thisObject, Reference description, Reference ips) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.description = reference2 = description;
                    this.ips = reference = ips;
                }

                public Object doCall(Object instance) {
                    Reference instance2 = new Reference(instance);
                    CallSite vnicAttachRs = IndyInterface.bootstrap("invoke", "listVnicAttachments", 0, IndyInterface.bootstrap("getProperty", "computeClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))), IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "instanceId", 0, IndyInterface.bootstrap("invoke", "compartmentId", 0, IndyInterface.bootstrap("invoke", "builder", 0, ListVnicAttachmentsRequest.class), IndyInterface.bootstrap("getProperty", "compartmentId", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get())))), IndyInterface.bootstrap("getProperty", "id", 0, instance2.get()))));
                    public final class _closure4
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference description;
                        private /* synthetic */ Reference instance;
                        private /* synthetic */ Reference ips;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure4(Object _outerInstance, Object _thisObject, Reference description, Reference instance, Reference ips) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.description = reference3 = description;
                            this.instance = reference2 = instance;
                            this.ips = reference = ips;
                        }

                        public Object doCall(Object vnicAttach) {
                            CallSite vnic = IndyInterface.bootstrap("getProperty", "vnic", 0, IndyInterface.bootstrap("invoke", "getVnic", 0, IndyInterface.bootstrap("getProperty", "networkClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))), IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "vnicId", 0, IndyInterface.bootstrap("invoke", "builder", 0, GetVnicRequest.class), IndyInterface.bootstrap("getProperty", "vnicId", 0, vnicAttach)))));
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "privateIp", 0, vnic)) != false) {
                                CallSite callSite = IndyInterface.bootstrap("getProperty", "privateIp", 0, vnic);
                                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)this.instance.get(), (String)"privateIp");
                                return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.ips.get()), IndyInterface.bootstrap("getProperty", "privateIp", 0, vnic));
                            }
                            return null;
                        }

                        @Generated
                        public BasicOracleDeployDescription getDescription() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.description.get());
                        }

                        @Generated
                        public Object getInstance() {
                            return this.instance.get();
                        }

                        @Generated
                        public List getIps() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.ips.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "items", 0, vnicAttachRs), new _closure4((Object)this, this.getThisObject(), this.description, instance2, this.ips));
                }

                @Generated
                public BasicOracleDeployDescription getDescription() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.description.get());
                }

                @Generated
                public List getIps() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.ips.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _handle_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "instances", 0, sg), new _handle_closure1(this, this, description2, ips));
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "backendSetName", 4, (BasicOracleDeployDescription)description2.get());
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)sg, (String)"backendSetName");
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{(List)ips.get(), IndyInterface.bootstrap("getProperty", "backendSetName", 4, (BasicOracleDeployDescription)description2.get())}, new String[]{"Adding IP addresses ", " to ", ""}));
            IndyInterface.bootstrap("invoke", "updateServerGroup", 0, this.oracleServerGroupService, sg);
            Reference defaultBackendSet = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "backendSets", 0, lb), IndyInterface.bootstrap("getProperty", "backendSetName", 4, (BasicOracleDeployDescription)description2.get()))));
            public final class _handle_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference defaultBackendSet;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure2(Object _outerInstance, Object _thisObject, Reference defaultBackendSet) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.defaultBackendSet = reference = defaultBackendSet;
                }

                public Object doCall(Object ip) {
                    return IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "port", 0, IndyInterface.bootstrap("invoke", "ipAddress", 0, IndyInterface.bootstrap("invoke", "builder", 0, BackendDetails.class), ip), IndyInterface.bootstrap("getProperty", "port", 0, IndyInterface.bootstrap("getProperty", "healthChecker", 0, IndyInterface.bootstrap("cast", "()", 0, this.defaultBackendSet.get())))));
                }

                @Generated
                public BackendSet getDefaultBackendSet() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.defaultBackendSet.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _handle_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Reference backends = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, (List)ips.get(), new _handle_closure2(this, this, defaultBackendSet))));
            public final class _handle_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference backends;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure3(Object _outerInstance, Object _thisObject, Reference backends) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.backends = reference = backends;
                }

                public Object doCall(Object existingBackend) {
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.backends.get()), IndyInterface.bootstrap("invoke", "of", 0, Details.class, existingBackend));
                }

                @Generated
                public List getBackends() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.backends.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _handle_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "backends", 0, (BackendSet)defaultBackendSet.get()), new _handle_closure3(this, this, backends));
            CallSite updateDetails = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "backends", 0, IndyInterface.bootstrap("invoke", "healthChecker", 0, IndyInterface.bootstrap("invoke", "policy", 0, IndyInterface.bootstrap("invoke", "builder", 0, UpdateBackendSetDetails.class), IndyInterface.bootstrap("getProperty", "policy", 0, (BackendSet)defaultBackendSet.get())), IndyInterface.bootstrap("invoke", "of", 0, Details.class, IndyInterface.bootstrap("getProperty", "healthChecker", 0, (BackendSet)defaultBackendSet.get()))), (List)backends.get())));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "backendSetName", 4, (BasicOracleDeployDescription)description2.get())}, new String[]{"Updating backendSet ", ""}));
            CallSite updateRes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "updateBackendSet", 0, IndyInterface.bootstrap("getProperty", "loadBalancerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicOracleDeployDescription)description2.get())), IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "updateBackendSetDetails", 0, IndyInterface.bootstrap("invoke", "backendSetName", 0, IndyInterface.bootstrap("invoke", "loadBalancerId", 0, IndyInterface.bootstrap("invoke", "builder", 0, UpdateBackendSetRequest.class), IndyInterface.bootstrap("getProperty", "loadBalancerId", 4, (BasicOracleDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "backendSetName", 4, (BasicOracleDeployDescription)description2.get())), updateDetails))));
            IndyInterface.bootstrap("invoke", "poll", 0, OracleWorkRequestPoller.class, IndyInterface.bootstrap("invoke", "getOpcWorkRequestId", 0, updateRes), BASE_PHASE, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "loadBalancerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicOracleDeployDescription)description2.get())));
        }
        CallSite deploymentResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DeploymentResult.class));
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{region, serverGroupName}, new String[]{"", ":", ""}))});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list, BasicOracleDeployHandler.class, (GroovyObject)deploymentResult, (String)"serverGroupNames");
        CallSite callSite4 = serverGroupName;
        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "serverGroupNameByRegion", 4, deploymentResult), region, callSite4);
        return deploymentResult;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BasicOracleDeployHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public OracleServerGroupService getOracleServerGroupService() {
        return this.oracleServerGroupService;
    }

    @Generated
    public @VisibleForTesting @VisibleForTesting void setOracleServerGroupService(OracleServerGroupService oracleServerGroupService) {
        this.oracleServerGroupService = oracleServerGroupService;
    }

    @Generated
    public OracleClusterProvider getClusterProvider() {
        return this.clusterProvider;
    }

    @Generated
    public @VisibleForTesting @VisibleForTesting void setClusterProvider(OracleClusterProvider oracleClusterProvider) {
        this.clusterProvider = oracleClusterProvider;
    }
}

