/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.deploy.op;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.oracle.deploy.OracleWorkRequestPoller;
import com.netflix.spinnaker.clouddriver.oracle.deploy.description.UpsertLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.oracle.model.Details;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.oracle.bmc.loadbalancer.model.BackendSet;
import com.oracle.bmc.loadbalancer.model.BackendSetDetails;
import com.oracle.bmc.loadbalancer.model.Certificate;
import com.oracle.bmc.loadbalancer.model.CertificateDetails;
import com.oracle.bmc.loadbalancer.model.CreateBackendSetDetails;
import com.oracle.bmc.loadbalancer.model.CreateCertificateDetails;
import com.oracle.bmc.loadbalancer.model.CreateListenerDetails;
import com.oracle.bmc.loadbalancer.model.CreateLoadBalancerDetails;
import com.oracle.bmc.loadbalancer.model.ListenerDetails;
import com.oracle.bmc.loadbalancer.model.LoadBalancer;
import com.oracle.bmc.loadbalancer.model.UpdateBackendSetDetails;
import com.oracle.bmc.loadbalancer.model.UpdateListenerDetails;
import com.oracle.bmc.loadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.CreateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.loadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.CreateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.model.BmcException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpsertOracleLoadBalancerAtomicOperation
implements AtomicOperation<Map> {
    private final UpsertLoadBalancerDescription description;
    private static final String CREATE = "CreateLB";
    private static final String UPDATE = "UpdateLB";

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    UpsertOracleLoadBalancerAtomicOperation(UpsertLoadBalancerDescription description) {
        this.description = description;
    }

    UpdateBackendSetDetails toUpdate(BackendSetDetails details, BackendSet existing) {
        UpdateBackendSetDetails.Builder builder = UpdateBackendSetDetails.builder().policy(details.getPolicy());
        if (details.getHealthChecker() != null) {
            builder.healthChecker(details.getHealthChecker());
        }
        if (details.getSessionPersistenceConfiguration() != null) {
            builder.sessionPersistenceConfiguration(details.getSessionPersistenceConfiguration());
        }
        if (details.getSslConfiguration() != null) {
            builder.sslConfiguration(details.getSslConfiguration());
        }
        List backends = existing.getBackends().stream().map(b -> Details.of(b)).collect(Collectors.toList());
        builder.backends(backends);
        return builder.build();
    }

    CreateBackendSetDetails toCreate(BackendSetDetails details, String name) {
        CreateBackendSetDetails.Builder builder = CreateBackendSetDetails.builder().policy(details.getPolicy()).name(name);
        if (details.getHealthChecker() != null) {
            builder.healthChecker(details.getHealthChecker());
        }
        if (details.getSessionPersistenceConfiguration() != null) {
            builder.sessionPersistenceConfiguration(details.getSessionPersistenceConfiguration());
        }
        if (details.getSslConfiguration() != null) {
            builder.sslConfiguration(details.getSslConfiguration());
        }
        return builder.build();
    }

    CreateCertificateDetails toCreate(CertificateDetails details, String name) {
        CreateCertificateDetails.Builder builder = CreateCertificateDetails.builder().certificateName(name);
        if (details.getCaCertificate() != null) {
            builder.caCertificate(details.getCaCertificate());
        }
        if (details.getPublicCertificate() != null) {
            builder.publicCertificate(details.getPublicCertificate());
        }
        if (details.getPrivateKey() != null) {
            builder.privateKey(details.getPrivateKey());
        }
        if (details.getPassphrase() != null) {
            builder.passphrase(details.getPassphrase());
        }
        return builder.build();
    }

    CreateListenerDetails toCreate(ListenerDetails details, String name) {
        CreateListenerDetails.Builder builder = CreateListenerDetails.builder().name(name).protocol(details.getProtocol()).port(details.getPort());
        if (details.getConnectionConfiguration() != null) {
            builder.connectionConfiguration(details.getConnectionConfiguration());
        }
        if (details.getDefaultBackendSetName() != null) {
            builder.defaultBackendSetName(details.getDefaultBackendSetName());
        }
        if (details.getHostnameNames() != null) {
            builder.hostnameNames(details.getHostnameNames());
        }
        if (details.getPathRouteSetName() != null) {
            builder.pathRouteSetName(details.getPathRouteSetName());
        }
        if (details.getSslConfiguration() != null) {
            builder.sslConfiguration(details.getSslConfiguration());
        }
        return builder.build();
    }

    UpdateListenerDetails toUpdate(ListenerDetails details) {
        UpdateListenerDetails.Builder builder = UpdateListenerDetails.builder().protocol(details.getProtocol()).port(details.getPort());
        if (details.getConnectionConfiguration() != null) {
            builder.connectionConfiguration(details.getConnectionConfiguration());
        }
        if (details.getDefaultBackendSetName() != null) {
            builder.defaultBackendSetName(details.getDefaultBackendSetName());
        }
        if (details.getHostnameNames() != null) {
            builder.hostnameNames(details.getHostnameNames());
        }
        if (details.getPathRouteSetName() != null) {
            builder.pathRouteSetName(details.getPathRouteSetName());
        }
        if (details.getSslConfiguration() != null) {
            builder.sslConfiguration(details.getSslConfiguration());
        }
        return builder.build();
    }

    void updateBackendSets(LoadBalancer lb, Task task) {
        Map<String, BackendSetDetails> backendSets;
        if (lb.getBackendSets() != null) {
            lb.getBackendSets().forEach((name, existingBackendSet) -> {
                BackendSetDetails backendSetUpdate;
                BackendSetDetails backendSetDetails = backendSetUpdate = this.description.getBackendSets() != null ? this.description.getBackendSets().get(name) : null;
                if (backendSetUpdate != null) {
                    UpdateBackendSetResponse res = this.description.getCredentials().getLoadBalancerClient().updateBackendSet(UpdateBackendSetRequest.builder().loadBalancerId(lb.getId()).backendSetName(name).updateBackendSetDetails(this.toUpdate(backendSetUpdate, (BackendSet)existingBackendSet)).build());
                    task.updateStatus(UPDATE, "UpdateBackendSetRequest of ${name} submitted - work request id: ${rs.getOpcWorkRequestId()}");
                    OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), UPDATE, task, this.description.getCredentials().getLoadBalancerClient());
                } else {
                    DeleteBackendSetResponse res = this.description.getCredentials().getLoadBalancerClient().deleteBackendSet(DeleteBackendSetRequest.builder().loadBalancerId(lb.getId()).backendSetName(name).build());
                    task.updateStatus(UPDATE, "DeleteBackendSetRequest of ${name} submitted - work request id: ${rs.getOpcWorkRequestId()}");
                    OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), UPDATE, task, this.description.getCredentials().getLoadBalancerClient());
                }
            });
        }
        if ((backendSets = this.description.getBackendSets()) != null) {
            backendSets.forEach((name, details) -> {
                if (!lb.getBackendSets().containsKey(name)) {
                    CreateBackendSetResponse res = this.description.getCredentials().getLoadBalancerClient().createBackendSet(CreateBackendSetRequest.builder().loadBalancerId(this.description.getLoadBalancerId()).createBackendSetDetails(this.toCreate((BackendSetDetails)details, (String)name)).build());
                    task.updateStatus(UPDATE, "CreateBackendSetRequest of ${name} submitted - work request id: ${rs.getOpcWorkRequestId()}");
                    OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), UPDATE, task, this.description.getCredentials().getLoadBalancerClient());
                }
            });
        }
    }

    void updateCertificates(LoadBalancer lb, Task task) {
        Map<String, CertificateDetails> certificates;
        if (lb.getCertificates() != null) {
            lb.getCertificates().forEach((name, existingCert) -> {
                CertificateDetails cert;
                CertificateDetails certificateDetails = cert = this.description.getCertificates() != null ? this.description.getCertificates().get(name) : null;
                if (cert == null) {
                    DeleteCertificateResponse res = this.description.getCredentials().getLoadBalancerClient().deleteCertificate(DeleteCertificateRequest.builder().loadBalancerId(lb.getId()).certificateName(name).build());
                    task.updateStatus(UPDATE, "DeleteCertificateRequest of ${name} submitted - work request id: ${rs.getOpcWorkRequestId()}");
                    OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), UPDATE, task, this.description.getCredentials().getLoadBalancerClient());
                }
            });
        }
        if ((certificates = this.description.getCertificates()) != null) {
            certificates.forEach((name, details) -> {
                Certificate cert = (Certificate)lb.getCertificates().get(name);
                if (cert == null) {
                    CreateCertificateResponse res = this.description.getCredentials().getLoadBalancerClient().createCertificate(CreateCertificateRequest.builder().loadBalancerId(this.description.getLoadBalancerId()).createCertificateDetails(this.toCreate((CertificateDetails)details, (String)name)).build());
                    task.updateStatus(UPDATE, "CreateCertificateRequest of ${name} submitted - work request id: ${rs.getOpcWorkRequestId()}");
                    OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), UPDATE, task, this.description.getCredentials().getLoadBalancerClient());
                }
            });
        }
    }

    void update(LoadBalancer lb, Task task) {
        Map<String, ListenerDetails> listeners;
        task.updateStatus(UPDATE, "UpdateLoadBalancer: $lb.displayName");
        if (lb.getListeners() != null) {
            lb.getListeners().forEach((name, existingListener) -> {
                ListenerDetails listenerUpdate;
                ListenerDetails listenerDetails = listenerUpdate = this.description.getListeners() != null ? this.description.getListeners().get(name) : null;
                if (listenerUpdate == null) {
                    DeleteListenerResponse res = this.description.getCredentials().getLoadBalancerClient().deleteListener(DeleteListenerRequest.builder().loadBalancerId(lb.getId()).listenerName(name).build());
                    task.updateStatus(UPDATE, "DeleteListenerRequest of ${name} submitted - work request id: ${rs.getOpcWorkRequestId()}");
                    OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), UPDATE, task, this.description.getCredentials().getLoadBalancerClient());
                }
            });
        }
        this.updateBackendSets(lb, task);
        this.updateCertificates(lb, task);
        if (lb.getListeners() != null) {
            lb.getListeners().forEach((name, existingListener) -> {
                ListenerDetails listenerUpdate;
                ListenerDetails listenerDetails = listenerUpdate = this.description.getListeners() != null ? this.description.getListeners().get(name) : null;
                if (listenerUpdate != null) {
                    UpdateListenerResponse res = this.description.getCredentials().getLoadBalancerClient().updateListener(UpdateListenerRequest.builder().loadBalancerId(lb.getId()).listenerName(name).updateListenerDetails(this.toUpdate(listenerUpdate)).build());
                    task.updateStatus(UPDATE, "UpdateListenerRequest of ${name} submitted - work request id: ${rs.getOpcWorkRequestId()}");
                    OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), UPDATE, task, this.description.getCredentials().getLoadBalancerClient());
                }
            });
        }
        if ((listeners = this.description.getListeners()) != null) {
            listeners.forEach((name, listener) -> {
                if (!lb.getListeners().containsKey(name)) {
                    CreateListenerResponse res = this.description.getCredentials().getLoadBalancerClient().createListener(CreateListenerRequest.builder().loadBalancerId(this.description.getLoadBalancerId()).createListenerDetails(this.toCreate((ListenerDetails)listener, (String)name)).build());
                    task.updateStatus(UPDATE, "CreateListenerRequest of ${name} submitted - work request id: ${rs.getOpcWorkRequestId()}");
                    OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), UPDATE, task, this.description.getCredentials().getLoadBalancerClient());
                }
            });
        }
    }

    void create(Task task) {
        String clusterName = this.description.qualifiedName();
        task.updateStatus(CREATE, "Create LB: ${description.qualifiedName()}");
        CreateLoadBalancerDetails.Builder lbDetails = CreateLoadBalancerDetails.builder().displayName(clusterName).compartmentId(this.description.getCredentials().getCompartmentId()).shapeName(this.description.getShape()).subnetIds(this.description.getSubnetIds());
        if (this.description.getIsPrivate().booleanValue()) {
            lbDetails.isPrivate(this.description.getIsPrivate());
        }
        if (this.description.getCertificates() != null) {
            lbDetails.certificates(this.description.getCertificates());
        }
        if (this.description.getBackendSets() != null) {
            lbDetails.backendSets(this.description.getBackendSets());
        }
        if (this.description.getListeners() != null) {
            lbDetails.listeners(this.description.getListeners());
        }
        CreateLoadBalancerResponse res = this.description.getCredentials().getLoadBalancerClient().createLoadBalancer(CreateLoadBalancerRequest.builder().createLoadBalancerDetails(lbDetails.build()).build());
        task.updateStatus(CREATE, "Create LB rq submitted - work request id: ${rs.getOpcWorkRequestId()}");
        OracleWorkRequestPoller.poll(res.getOpcWorkRequestId(), CREATE, task, this.description.getCredentials().getLoadBalancerClient());
    }

    public Map operate(List priorOutputs) {
        Task task = UpsertOracleLoadBalancerAtomicOperation.getTask();
        if (this.description.getLoadBalancerId() != null) {
            try {
                LoadBalancer lb = this.description.getCredentials().getLoadBalancerClient().getLoadBalancer(GetLoadBalancerRequest.builder().loadBalancerId(this.description.getLoadBalancerId()).build()).getLoadBalancer();
                if (lb != null) {
                    this.update(lb, task);
                }
                task.updateStatus(UPDATE, "LoadBalancer ${description.loadBalancerId} does not exist.");
            }
            catch (BmcException e) {
                if (e.getStatusCode() == 404) {
                    task.updateStatus(UPDATE, "LoadBalancer ${description.loadBalancerId} does not exist.");
                }
                throw e;
            }
        } else {
            this.create(task);
        }
        return this.mapOf("loadBalancers", this.mapOf(this.description.getCredentials().getRegion(), this.mapOf("name", this.description.qualifiedName())));
    }

    Map<String, Object> mapOf(String key, Object val) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, val);
        return map;
    }
}

