/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.oracle.OracleCloudProvider;
import com.netflix.spinnaker.clouddriver.oracle.cache.Keys;
import com.netflix.spinnaker.clouddriver.oracle.model.OracleCluster;
import com.netflix.spinnaker.clouddriver.oracle.model.OracleServerGroup;
import com.netflix.spinnaker.clouddriver.oracle.provider.view.OracleInstanceProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OracleClusterProvider
implements ClusterProvider<OracleCluster.View>,
GroovyObject {
    private final String cloudProviderId;
    private OracleInstanceProvider instanceProvider;
    private final ObjectMapper objectMapper;
    private AccountCredentialsProvider accountCredentialsProvider;
    private final Cache cacheView;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public OracleClusterProvider(OracleInstanceProvider instanceProvider, ObjectMapper objectMapper, AccountCredentialsProvider accountCredentialsProvider, Cache cacheView) {
        Cache cache;
        AccountCredentialsProvider accountCredentialsProvider2;
        ObjectMapper objectMapper2;
        OracleInstanceProvider oracleInstanceProvider;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, OracleCloudProvider.class);
        this.cloudProviderId = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.instanceProvider = oracleInstanceProvider = instanceProvider;
        this.objectMapper = objectMapper2 = objectMapper;
        this.accountCredentialsProvider = accountCredentialsProvider2 = accountCredentialsProvider;
        this.cacheView = cache = cacheView;
    }

    public Map<String, Set<OracleCluster.View>> getClusters() {
        CallSite identifiers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class))));
        CallSite serverGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadServerGroups", 2, this, identifiers));
        public final class _getClusters_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClusters_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "accountName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClusters_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, IndyInterface.bootstrap("invoke", "clustersFromServerGroups", 2, this, serverGroups), new _getClusters_closure1(this, this)));
    }

    public Map<String, Set<OracleCluster.View>> getClusterSummaries(String application) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getClusterDetails", 2, this, application));
    }

    public Map<String, Set<OracleCluster.View>> getClusterDetails(String application) {
        Reference application2 = new Reference((Object)application);
        public final class _getClusterDetails_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference application;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClusterDetails_closure2(Object _outerInstance, Object _thisObject, Reference application) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.application = reference = application;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.application.get()), (Object)IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, it), "application"));
            }

            @Generated
            public String getApplication() {
                return IndyInterface.bootstrap("cast", "()", 0, this.application.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClusterDetails_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite identifiers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "getIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class))), new _getClusterDetails_closure2(this, this, application2)));
        CallSite serverGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadServerGroups", 2, this, identifiers));
        public final class _getClusterDetails_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClusterDetails_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "accountName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClusterDetails_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, IndyInterface.bootstrap("invoke", "clustersFromServerGroups", 2, this, serverGroups), new _getClusterDetails_closure3(this, this)));
    }

    public Set<OracleCluster.View> getClusters(String application, String account) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getClusterDetails", 2, this, application), account));
    }

    public OracleCluster.View getCluster(String application, String account, String name, boolean includeDetails) {
        Reference name2 = new Reference((Object)name);
        public final class _getCluster_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getCluster_closure4(Object _outerInstance, Object _thisObject, Reference name) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.name.get()), (Object)IndyInterface.bootstrap("getProperty", "name", 0, it));
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getCluster_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("invoke", "getClusters", 2, this, application, account), new _getCluster_closure4(this, this, name2)));
    }

    public OracleCluster.View getCluster(String application, String account, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCluster", 2, this, application, account, name, true));
    }

    public ServerGroup getServerGroup(String account, String region, String name, boolean includeDetails) {
        CallSite pattern = IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, account, region, name);
        CallSite identifiers = IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), pattern);
        CallSite serverGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadServerGroups", 2, this, identifiers));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, serverGroups)) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getView", 0, IndyInterface.bootstrap("invoke", "next", 0, IndyInterface.bootstrap("invoke", "iterator", 0, serverGroups))));
    }

    public ServerGroup getServerGroup(String account, String region, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroup", 2, this, account, region, name, true));
    }

    public boolean supportsMinimalClusters() {
        return false;
    }

    private OracleServerGroup restoreCreds(OracleServerGroup partial, String identifier) {
        CallSite account = IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, identifier), "account");
        CallSite callSite = IndyInterface.bootstrap("invoke", "getCredentials", 0, this.accountCredentialsProvider, account);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, OracleClusterProvider.class, (GroovyObject)partial, (String)"credentials");
        return partial;
    }

    private Set<OracleServerGroup> loadServerGroups(Collection<String> identifiers) {
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        public final class _loadServerGroups_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadServerGroups_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object cacheItem) {
                Reference cacheItem2 = new Reference(cacheItem);
                Reference sg = new Reference((Object)IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, cacheItem2.get()), OracleServerGroup.class));
                IndyInterface.bootstrap("invoke", "restoreCreds", 2, this, sg.get(), IndyInterface.bootstrap("getProperty", "id", 0, cacheItem2.get()));
                public final class _closure8
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference cacheItem;
                    private /* synthetic */ Reference sg;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure8(Object _outerInstance, Object _thisObject, Reference cacheItem, Reference sg) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.cacheItem = reference2 = cacheItem;
                        this.sg = reference = sg;
                    }

                    public Object doCall(Object it) {
                        CallSite instance = IndyInterface.bootstrap("invoke", "getInstance", 0, IndyInterface.bootstrap("getProperty", "instanceProvider", 12, this), IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, this.cacheItem.get())), "account"), "*", IndyInterface.bootstrap("getProperty", "id", 0, it));
                        if (IndyInterface.bootstrap("cast", "()", 0, instance) != false) {
                            CallSite callSite = IndyInterface.bootstrap("getProperty", "healthState", 0, instance);
                            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)it, (String)"healthState");
                            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "health", 0, instance);
                            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)it, (String)"health");
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disabled", 0, this.sg.get())) != false) {
                                CallSite callSite3 = IndyInterface.bootstrap("getProperty", "OutOfService", 0, HealthState.class);
                                ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)it, (String)"healthState");
                                CallSite callSite4 = IndyInterface.bootstrap("invoke", "name", 0, IndyInterface.bootstrap("getProperty", "OutOfService", 0, HealthState.class));
                                ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "health", 0, it), false), (String)"state");
                                return callSite4;
                            }
                        }
                        return null;
                    }

                    @Generated
                    public Object getCacheItem() {
                        return this.cacheItem.get();
                    }

                    @Generated
                    public Object getSg() {
                        return this.sg.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure8.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference cacheItem;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure9(Object _outerInstance, Object _thisObject, Reference cacheItem) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.cacheItem = reference = cacheItem;
                    }

                    public Object doCall(Object it) {
                        CallSite instance = IndyInterface.bootstrap("invoke", "getInstance", 0, IndyInterface.bootstrap("getProperty", "instanceProvider", 12, this), IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, this.cacheItem.get())), "account"), "*", IndyInterface.bootstrap("getProperty", "id", 0, it));
                        return ScriptBytecodeAdapter.compareEqual((Object)instance, null);
                    }

                    @Generated
                    public Object getCacheItem() {
                        return this.cacheItem.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "removeAll", 1, IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "instances", 0, sg.get()), new _closure8((Object)this, this.getThisObject(), cacheItem2, sg)), new _closure9((Object)this, this.getThisObject(), cacheItem2));
                return sg.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadServerGroups_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, data, new _loadServerGroups_closure5(this, this)));
    }

    private String accountFromServerGroups(List<OracleServerGroup> sgs) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 1, IndyInterface.bootstrap("getProperty", "credentials", 1, IndyInterface.bootstrap("invoke", "next", 1, IndyInterface.bootstrap("invoke", "iterator", 1, sgs)))));
    }

    private Set<OracleCluster.View> clustersFromServerGroups(Set<OracleServerGroup> serverGroups) {
        public final class _clustersFromServerGroups_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _clustersFromServerGroups_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "cluster", 0, IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, IndyInterface.bootstrap("getProperty", "name", 0, it)));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _clustersFromServerGroups_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite byClusterName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, serverGroups, new _clustersFromServerGroups_closure6(this, this)));
        public final class _clustersFromServerGroups_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _clustersFromServerGroups_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "getView", 0, IndyInterface.bootstrap("init", "<init>", 0, OracleCluster.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", k, "accountName", IndyInterface.bootstrap("invoke", "accountFromServerGroups", 2, this, v), "serverGroups", (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, v, Set.class))})));
            }

            @Generated
            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _clustersFromServerGroups_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, byClusterName, new _clustersFromServerGroups_closure7(this, this)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OracleClusterProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.oracle.provider.view.OracleClusterProvider");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final String getCloudProviderId() {
        return this.cloudProviderId;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

