/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.InstanceProvider;
import com.netflix.spinnaker.clouddriver.oracle.OracleCloudProvider;
import com.netflix.spinnaker.clouddriver.oracle.cache.Keys;
import com.netflix.spinnaker.clouddriver.oracle.model.OracleInstance;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.oracle.bmc.core.model.Instance;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OracleInstanceProvider
implements InstanceProvider<OracleInstance, String>,
GroovyObject {
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    private final AccountCredentialsProvider accountCredentialsProvider;
    private final String cloudProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public OracleInstanceProvider(Cache cacheView, ObjectMapper objectMapper, AccountCredentialsProvider accountCredentialsProvider) {
        AccountCredentialsProvider accountCredentialsProvider2;
        ObjectMapper objectMapper2;
        Cache cache;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, OracleCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
        this.accountCredentialsProvider = accountCredentialsProvider2 = accountCredentialsProvider;
    }

    public OracleInstance getInstance(String account, String region, String nameOrOcid) {
        CallSite callSite;
        CallSite cacheKeyWithOcid = IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, account, region, "*", nameOrOcid);
        CallSite cacheKeyWithName = IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, account, region, nameOrOcid, "*");
        CallSite identifiers = IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)), cacheKeyWithOcid);
        IndyInterface.bootstrap("invoke", "addAll", 0, identifiers, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)), cacheKeyWithName));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, identifiers), (Object)1)) {
            IndyInterface.bootstrap("invoke", "warn", 0, log, "There should be at most one identifier!");
        }
        CallSite instances = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("invoke", "loadInstances", 2, this, identifiers)) != false ? callSite : null);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "first", 1, instances));
    }

    public String getConsoleOutput(String account, String region, String id) {
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, UnsupportedOperationException.class));
    }

    private Set<OracleInstance> loadInstances(Collection<String> identifiers) {
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, data, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData")));
    }

    private OracleInstance fromCacheData(CacheData cacheData) {
        CallSite instance = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), Instance.class));
        CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, cacheData)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, OracleInstance.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "displayName", 0, instance), "healthState", IndyInterface.bootstrap("invoke", "getHealthState", 2, this, IndyInterface.bootstrap("getProperty", "lifecycleState", 0, instance)), "launchTime", IndyInterface.bootstrap("invoke", "getTime", 0, IndyInterface.bootstrap("getProperty", "timeCreated", 0, instance)), "zone", IndyInterface.bootstrap("getProperty", "availabilityDomain", 0, instance), "health", ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", IndyInterface.bootstrap("invoke", "name", 0, IndyInterface.bootstrap("invoke", "getHealthState", 2, this, IndyInterface.bootstrap("getProperty", "lifecycleState", 0, instance))), "type", "Oracle", "healthClass", "platform"})}), "providerType", this.cloudProvider, "cloudProvider", this.cloudProvider, "account", IndyInterface.bootstrap("getProperty", "account", 0, parts), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts), "id", IndyInterface.bootstrap("getProperty", "id", 0, parts)})));
    }

    private HealthState getHealthState(Instance.LifecycleState lifecycleState) {
        Instance.LifecycleState lifecycleState2 = lifecycleState;
        if (ScriptBytecodeAdapter.isCase((Object)lifecycleState2, (Object)IndyInterface.bootstrap("getProperty", "Provisioning", 0, Instance.LifecycleState.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Starting", 0, HealthState.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)lifecycleState2, (Object)IndyInterface.bootstrap("getProperty", "Running", 0, Instance.LifecycleState.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Up", 0, HealthState.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)lifecycleState2, (Object)IndyInterface.bootstrap("getProperty", "Starting", 0, Instance.LifecycleState.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Starting", 0, HealthState.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)lifecycleState2, (Object)IndyInterface.bootstrap("getProperty", "Stopping", 0, Instance.LifecycleState.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Down", 0, HealthState.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)lifecycleState2, (Object)IndyInterface.bootstrap("getProperty", "Stopped", 0, Instance.LifecycleState.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Down", 0, HealthState.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)lifecycleState2, (Object)IndyInterface.bootstrap("getProperty", "CreatingImage", 0, Instance.LifecycleState.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Starting", 0, HealthState.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)lifecycleState2, (Object)IndyInterface.bootstrap("getProperty", "Terminating", 0, Instance.LifecycleState.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Down", 0, HealthState.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)lifecycleState2, (Object)IndyInterface.bootstrap("getProperty", "Terminated", 0, Instance.LifecycleState.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Down", 0, HealthState.class));
        }
        return null;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OracleInstanceProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.oracle.provider.view.OracleInstanceProvider");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public final AccountCredentialsProvider getAccountCredentialsProvider() {
        return this.accountCredentialsProvider;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }
}

