/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import com.netflix.spinnaker.clouddriver.model.securitygroups.SecurityGroupRule;
import com.netflix.spinnaker.clouddriver.oracle.OracleCloudProvider;
import com.netflix.spinnaker.clouddriver.oracle.cache.Keys;
import com.netflix.spinnaker.clouddriver.oracle.model.OracleSecurityGroup;
import com.oracle.bmc.core.model.SecurityList;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OracleSecurityGroupProvider
implements SecurityGroupProvider<OracleSecurityGroup>,
GroovyObject {
    private final String cloudProvider;
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public OracleSecurityGroupProvider(Cache cacheView, ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, OracleCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public Set<OracleSecurityGroup> getAll(boolean includeRules) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", "*", "*"), includeRules));
    }

    public Set<OracleSecurityGroup> getAllByRegion(boolean includeRules, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", region, "*"), includeRules));
    }

    public Set<OracleSecurityGroup> getAllByAccount(boolean includeRules, String account) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", "*", account), includeRules));
    }

    public Set<OracleSecurityGroup> getAllByAccountAndName(boolean includeRules, String account, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, name, "*", "*", account), includeRules));
    }

    public Set<OracleSecurityGroup> getAllByAccountAndRegion(boolean includeRules, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", region, account), includeRules));
    }

    public OracleSecurityGroup get(String account, String region, String name, String vpcId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, name, "*", region, account), true), false));
    }

    public OracleSecurityGroup getById(String account, String region, String id, String vpcId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", id, region, account), true), false));
    }

    public Set<OracleSecurityGroup> getAllMatchingKeyPattern(String pattern, boolean includeRules) {
        CallSite identifiers = IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), pattern);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadResults", 2, this, includeRules, identifiers));
    }

    public Set<OracleSecurityGroup> loadResults(boolean includeRules, Collection<String> identifiers) {
        CallSite transform = IndyInterface.bootstrap("invoke", "curry", 0, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData"), includeRules);
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        CallSite transformed = IndyInterface.bootstrap("invoke", "collect", 0, data, transform);
        return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, transformed, Set.class));
    }

    public OracleSecurityGroup fromCacheData(boolean includeRules, CacheData cacheData) {
        CallSite secList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), SecurityList.class));
        CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, cacheData)));
        public final class _fromCacheData_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromCacheData_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                List ranges = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "destinationPortRange", 1, IndyInterface.bootstrap("getProperty", "tcpOptions", 1, it))) == false) {
                    return null;
                }
                IndyInterface.bootstrap("invoke", "leftShift", 0, ranges, IndyInterface.bootstrap("init", "<init>", 0, Rule.PortRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"startPort", IndyInterface.bootstrap("getProperty", "min", 0, IndyInterface.bootstrap("getProperty", "destinationPortRange", 0, IndyInterface.bootstrap("getProperty", "tcpOptions", 0, it))), "endPort", IndyInterface.bootstrap("getProperty", "max", 0, IndyInterface.bootstrap("getProperty", "destinationPortRange", 0, IndyInterface.bootstrap("getProperty", "tcpOptions", 0, it)))})));
                return IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"protocol", "TCP", "portRanges", IndyInterface.bootstrap("init", "<init>", 0, TreeSet.class, ranges)}));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromCacheData_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        _fromCacheData_closure1 ruleTransformer = new _fromCacheData_closure1(this, this);
        Object inRules = includeRules ? IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "ingressSecurityRules", 0, secList), ruleTransformer) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        public final class _fromCacheData_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromCacheData_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)it, null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromCacheData_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "removeAll", 0, inRules, new _fromCacheData_closure2(this, this));
        Object outRules = includeRules ? IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "egressSecurityRules", 0, secList), ruleTransformer) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        public final class _fromCacheData_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromCacheData_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)it, null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromCacheData_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "removeAll", 0, outRules, new _fromCacheData_closure3(this, this));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, OracleSecurityGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", IndyInterface.bootstrap("getProperty", "ID", 0, OracleCloudProvider.class), "cloudProvider", IndyInterface.bootstrap("getProperty", "ID", 0, OracleCloudProvider.class), "id", IndyInterface.bootstrap("getProperty", "id", 0, secList), "name", IndyInterface.bootstrap("getProperty", "displayName", 0, secList), "description", IndyInterface.bootstrap("getProperty", "displayName", 0, secList), "accountName", IndyInterface.bootstrap("getProperty", "account", 0, parts), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts), "network", IndyInterface.bootstrap("getProperty", "vcnId", 0, secList), "inboundRules", (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, inRules, Set.class)), "outboundRules", (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, outRules, Set.class))})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OracleSecurityGroupProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.oracle.provider.view.OracleSecurityGroupProvider");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }
}

