/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.oracle.service.servergroup;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.oracle.OracleCloudProvider;
import com.netflix.spinnaker.clouddriver.oracle.model.OracleInstance;
import com.netflix.spinnaker.clouddriver.oracle.model.OracleServerGroup;
import com.netflix.spinnaker.clouddriver.oracle.security.OracleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.oracle.service.servergroup.OraclePersistenceContext;
import com.netflix.spinnaker.clouddriver.oracle.service.servergroup.OracleServerGroupPersistence;
import com.netflix.spinnaker.clouddriver.oracle.service.servergroup.OracleServerGroupService;
import com.oracle.bmc.core.model.LaunchInstanceDetails;
import com.oracle.bmc.core.requests.LaunchInstanceRequest;
import com.oracle.bmc.core.requests.TerminateInstanceRequest;
import com.oracle.bmc.model.BmcException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultOracleServerGroupService
implements OracleServerGroupService,
GroovyObject {
    private static final String DEPLOY = "DEPLOY_SERVER_GROUP";
    private static final String DESTROY = "DESTROY_SERVER_GROUP";
    private static final String RESIZE = "RESIZE_SERVER_GROUP";
    private static final String DISABLE = "DISABLE_SERVER_GROUP";
    private static final String ENABLE = "ENABLE_SERVER_GROUP";
    private final OracleServerGroupPersistence persistence;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public DefaultOracleServerGroupService(OracleServerGroupPersistence persistence) {
        OracleServerGroupPersistence oracleServerGroupPersistence;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.persistence = oracleServerGroupPersistence = persistence;
    }

    @Override
    public List<OracleServerGroup> listAllServerGroups(OracleNamedAccountCredentials creds) {
        Reference persistenceCtx = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, OraclePersistenceContext.class, creds));
        CallSite sgNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "listServerGroupNames", 0, this.persistence, persistenceCtx.get()));
        public final class _listAllServerGroups_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference persistenceCtx;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _listAllServerGroups_closure1(Object _outerInstance, Object _thisObject, Reference persistenceCtx) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.persistenceCtx = reference = persistenceCtx;
            }

            public Object doCall(Object name) {
                return IndyInterface.bootstrap("invoke", "getServerGroupByName", 0, IndyInterface.bootstrap("getProperty", "persistence", 12, this), this.persistenceCtx.get(), name);
            }

            @Generated
            public Object getPersistenceCtx() {
                return this.persistenceCtx.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listAllServerGroups_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResults", 0, sgNames, new _listAllServerGroups_closure1(this, this, persistenceCtx)));
    }

    @Override
    public List<String> listServerGroupNamesByClusterName(OracleNamedAccountCredentials creds, String clusterName) {
        Reference clusterName2 = new Reference((Object)clusterName);
        CallSite persistenceCtx = IndyInterface.bootstrap("init", "<init>", 0, OraclePersistenceContext.class, creds);
        CallSite sgNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "listServerGroupNames", 0, this.persistence, persistenceCtx));
        public final class _listServerGroupNamesByClusterName_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clusterName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _listServerGroupNamesByClusterName_closure2(Object _outerInstance, Object _thisObject, Reference clusterName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.clusterName = reference = clusterName;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.clusterName.get()), (Object)IndyInterface.bootstrap("getProperty", "cluster", 1, IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, it)));
            }

            @Generated
            public String getClusterName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.clusterName.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listServerGroupNamesByClusterName_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, sgNames, new _listServerGroupNamesByClusterName_closure2(this, this, clusterName2)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OracleServerGroup getServerGroup(OracleNamedAccountCredentials creds, String application, String name) {
        void var3_3;
        Reference application2 = new Reference((Object)application);
        Reference name2 = new Reference((Object)var3_3);
        CallSite persistenceCtx = IndyInterface.bootstrap("init", "<init>", 0, OraclePersistenceContext.class, creds);
        CallSite sgNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "listServerGroupNames", 0, this.persistence, persistenceCtx));
        public final class _getServerGroup_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference application;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getServerGroup_closure3(Object _outerInstance, Object _thisObject, Reference application) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.application = reference = application;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.application.get()), (Object)IndyInterface.bootstrap("getProperty", "app", 1, IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, it)));
            }

            @Generated
            public String getApplication() {
                return IndyInterface.bootstrap("cast", "()", 0, this.application.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getServerGroup_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite sgNamesInApp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, sgNames, new _getServerGroup_closure3(this, this, application2)));
        public final class _getServerGroup_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getServerGroup_closure4(Object _outerInstance, Object _thisObject, Reference name) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.name.get()), (Object)it);
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getServerGroup_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite foundName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, sgNamesInApp, new _getServerGroup_closure4(this, this, name2)));
        if (IndyInterface.bootstrap("cast", "()", 0, foundName) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroupByName", 0, this.persistence, persistenceCtx, (String)name2.get()));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    @Override
    public void createServerGroup(Task task, OracleServerGroup sg) {
        Set instances = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        List errors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        try {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("getProperty", "targetSize", 4, sg))) {
                IndyInterface.bootstrap("invoke", "leftShift", 0, instances, IndyInterface.bootstrap("invoke", "createInstance", 2, this, sg, i));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
        }
        catch (BmcException e) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DEPLOY, new GStringImpl(new Object[]{e}, new String[]{"Creating instance failed: ", ""}));
            IndyInterface.bootstrap("invoke", "leftShift", 0, errors, e);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, errors) != false) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, instances), (Object)0)) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DEPLOY, new GStringImpl(new Object[]{errors}, new String[]{"ServerGroup created with errors: ", ""}));
            } else {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DEPLOY, new GStringImpl(new Object[]{errors}, new String[]{"ServerGroup creation failed: ", ""}));
            }
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, instances), (Object)0)) {
            Set set = instances;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)set, DefaultOracleServerGroupService.class, (GroovyObject)sg, (String)"instances");
            IndyInterface.bootstrap("invoke", "upsertServerGroup", 0, this.persistence, sg);
        }
    }

    @Override
    public void updateServerGroup(OracleServerGroup sg) {
        IndyInterface.bootstrap("invoke", "upsertServerGroup", 0, this.persistence, sg);
    }

    @Override
    public boolean destroyServerGroup(Task task, OracleNamedAccountCredentials creds, String serverGroupName) {
        CallSite persistenceCtx = IndyInterface.bootstrap("init", "<init>", 0, OraclePersistenceContext.class, creds);
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroupByName", 0, this.persistence, persistenceCtx, serverGroupName);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)serverGroup, null)) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DESTROY, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, serverGroup)}, new String[]{"Found server group: ", ""}));
            if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "instances", 0, serverGroup)) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "instances", 0, serverGroup)), (Object)0)) {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("getProperty", "targetSize", 0, serverGroup))) {
                    CallSite instance = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "instances", 0, serverGroup), i);
                    if (IndyInterface.bootstrap("cast", "()", 0, instance) != false) {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DESTROY, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instance)}, new String[]{"Terminating instance: ", ""}));
                        IndyInterface.bootstrap("invoke", "terminateInstance", 2, this, serverGroup, instance);
                    }
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                }
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DESTROY, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, serverGroup)}, new String[]{"Removing persistent data for ", ""}));
            IndyInterface.bootstrap("invoke", "deleteServerGroup", 0, this.persistence, serverGroup);
            return true;
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DESTROY, "Server group not found");
        return false;
    }

    @Override
    public boolean resizeServerGroup(Task task, OracleNamedAccountCredentials creds, String serverGroupName, Integer targetSize) {
        CallSite persistenceCtx = IndyInterface.bootstrap("init", "<init>", 0, OraclePersistenceContext.class, creds);
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroupByName", 0, this.persistence, persistenceCtx, serverGroupName);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)serverGroup, null)) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, serverGroup), targetSize}, new String[]{"Found server group: ", " resizing to ", ""}));
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)targetSize, (Object)IndyInterface.bootstrap("getProperty", "targetSize", 0, serverGroup))) {
                int numInstancesToCreate = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "minus", 0, targetSize, IndyInterface.bootstrap("getProperty", "targetSize", 0, serverGroup)));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, new GStringImpl(new Object[]{numInstancesToCreate}, new String[]{"Creating ", " instances"}));
                IndyInterface.bootstrap("invoke", "increase", 2, this, task, serverGroup, targetSize);
            } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "targetSize", 0, serverGroup), (Object)targetSize)) {
                int numInstancesToTerminate = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "targetSize", 0, serverGroup), targetSize));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, new GStringImpl(new Object[]{numInstancesToTerminate}, new String[]{"Terminating ", " instances"}));
                IndyInterface.bootstrap("invoke", "decrease", 2, this, task, serverGroup, targetSize);
            } else {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, "Already running the desired number of instances");
                return true;
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, serverGroup)}, new String[]{"Updating persistent data for ", ""}));
            IndyInterface.bootstrap("invoke", "upsertServerGroup", 0, this.persistence, serverGroup);
            return true;
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, "Server group not found");
        return false;
    }

    @Override
    public void disableServerGroup(Task task, OracleNamedAccountCredentials creds, String serverGroupName) {
        CallSite persistenceCtx = IndyInterface.bootstrap("init", "<init>", 0, OraclePersistenceContext.class, creds);
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroupByName", 0, this.persistence, persistenceCtx, serverGroupName);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)serverGroup, null)) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DISABLE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, serverGroup)}, new String[]{"Found server group: ", ""}));
            boolean bl = true;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)serverGroup, (String)"disabled");
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DISABLE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, serverGroup)}, new String[]{"Updating persistent data for ", ""}));
            IndyInterface.bootstrap("invoke", "upsertServerGroup", 0, this.persistence, serverGroup);
        } else {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, DISABLE, "Server group not found");
        }
    }

    @Override
    public void enableServerGroup(Task task, OracleNamedAccountCredentials creds, String serverGroupName) {
        CallSite persistenceCtx = IndyInterface.bootstrap("init", "<init>", 0, OraclePersistenceContext.class, creds);
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroupByName", 0, this.persistence, persistenceCtx, serverGroupName);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)serverGroup, null)) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, ENABLE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, serverGroup)}, new String[]{"Found server group: ", ""}));
            boolean bl = false;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)serverGroup, (String)"disabled");
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, ENABLE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, serverGroup)}, new String[]{"Updating persistent data for ", ""}));
            IndyInterface.bootstrap("invoke", "upsertServerGroup", 0, this.persistence, serverGroup);
        } else {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, ENABLE, "Server group not found");
        }
    }

    private OracleInstance createInstance(OracleServerGroup sg, int i) {
        CallSite metadata = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "trim", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 4, sg), "sshAuthorizedKeys"))) != false) {
            IndyInterface.bootstrap("invoke", "put", 0, metadata, "ssh_authorized_keys", ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 4, sg), "sshAuthorizedKeys"), String.class))), String.class));
        }
        CallSite rq = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "launchInstanceDetails", 0, IndyInterface.bootstrap("invoke", "builder", 0, LaunchInstanceRequest.class), IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "displayName", 0, IndyInterface.bootstrap("invoke", "metadata", 0, IndyInterface.bootstrap("invoke", "subnetId", 0, IndyInterface.bootstrap("invoke", "shape", 0, IndyInterface.bootstrap("invoke", "imageId", 0, IndyInterface.bootstrap("invoke", "compartmentId", 0, IndyInterface.bootstrap("invoke", "availabilityDomain", 0, IndyInterface.bootstrap("invoke", "builder", 0, LaunchInstanceDetails.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 4, sg), "availabilityDomain"), String.class))), String.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 4, sg), "compartmentId"), String.class))), String.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 4, sg), "imageId"), String.class))), String.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 4, sg), "shape"), String.class))), String.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 4, sg), "subnetId"), String.class))), String.class)), metadata), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "name", 4, sg), new GStringImpl(new Object[]{i}, new String[]{"-", ""})))))));
        CallSite rs = IndyInterface.bootstrap("invoke", "launchInstance", 0, IndyInterface.bootstrap("getProperty", "computeClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, sg)), rq);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, OracleInstance.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "displayName", 0, IndyInterface.bootstrap("getProperty", "instance", 0, rs)), "id", IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "instance", 0, rs)), "region", IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("getProperty", "instance", 0, rs)), "zone", IndyInterface.bootstrap("getProperty", "availabilityDomain", 0, IndyInterface.bootstrap("getProperty", "instance", 0, rs)), "healthState", IndyInterface.bootstrap("getProperty", "Starting", 0, HealthState.class), "cloudProvider", IndyInterface.bootstrap("getProperty", "ID", 0, OracleCloudProvider.class), "launchTime", IndyInterface.bootstrap("getProperty", "time", 0, IndyInterface.bootstrap("getProperty", "timeCreated", 0, IndyInterface.bootstrap("getProperty", "instance", 0, rs)))})));
    }

    private OracleInstance terminateInstance(OracleServerGroup sg, OracleInstance instance) {
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "instanceId", 0, IndyInterface.bootstrap("invoke", "builder", 0, TerminateInstanceRequest.class), IndyInterface.bootstrap("getProperty", "id", 4, instance))));
        try {
            IndyInterface.bootstrap("invoke", "terminateInstance", 0, IndyInterface.bootstrap("getProperty", "computeClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, sg)), request);
        }
        catch (BmcException e) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "statusCode", 0, e), (Object)404)) {
                throw (Throwable)e;
            }
        }
        return instance;
    }

    private void increase(Task task, OracleServerGroup serverGroup, int targetSize) {
        int currentSize = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("getProperty", "targetSize", 4, serverGroup));
        Set instances = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        List errors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        int i = currentSize;
        while (i < targetSize) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, new GStringImpl(new Object[]{i}, new String[]{"Creating instance: ", ""}));
            try {
                IndyInterface.bootstrap("invoke", "leftShift", 0, instances, IndyInterface.bootstrap("invoke", "createInstance", 2, this, serverGroup, i));
            }
            catch (BmcException e) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, new GStringImpl(new Object[]{e}, new String[]{"Creating instance failed: ", ""}));
                IndyInterface.bootstrap("invoke", "leftShift", 0, errors, e);
            }
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, errors) != false) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, instances), (Object)0)) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, new GStringImpl(new Object[]{errors}, new String[]{"ServerGroup resize with errors: ", ""}));
            } else {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, new GStringImpl(new Object[]{errors}, new String[]{"ServerGroup resize failed: ", ""}));
            }
        }
        CallSite instance = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, instances));
        if (callSite != null) {
            while (callSite.hasNext()) {
                instance = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "instances", 4, serverGroup), instance);
            }
        }
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "plus", 0, currentSize, IndyInterface.bootstrap("invoke", "size", 0, instances));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, DefaultOracleServerGroupService.class, (GroovyObject)serverGroup, (String)"targetSize");
    }

    private void decrease(Task task, OracleServerGroup serverGroup, int targetSize) {
        Set instances = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        int currentSize = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("getProperty", "targetSize", 4, serverGroup));
        int i = targetSize;
        while (i < currentSize) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, RESIZE, IndyInterface.bootstrap("invoke", "plus", 0, "Terminating instance: ", IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "instances", 4, serverGroup), i))));
            IndyInterface.bootstrap("invoke", "leftShift", 0, instances, IndyInterface.bootstrap("invoke", "terminateInstance", 2, this, serverGroup, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "instances", 4, serverGroup), i)));
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        CallSite instance = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, instances));
        if (callSite != null) {
            while (callSite.hasNext()) {
                instance = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("getProperty", "instances", 4, serverGroup), instance);
            }
        }
        int n = targetSize;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, DefaultOracleServerGroupService.class, (GroovyObject)serverGroup, (String)"targetSize");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultOracleServerGroupService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

