/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.data.task.SagaId;
import com.netflix.spinnaker.clouddriver.data.task.Status;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskDisplayStatus;
import com.netflix.spinnaker.clouddriver.data.task.TaskState;
import com.netflix.spinnaker.clouddriver.sql.SqlTaskRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\u0018\u0000 82\u00020\u0001:\u00018B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$H\u0016J\b\u0010%\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0003H\u0016J\b\u0010'\u001a\u00020\u0003H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010*\u001a\u00020\u0007H\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010,\u001a\u00020\"H\u0016J\u001b\u0010-\u001a\u00020\u001b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b.J\u001b\u0010/\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011H\u0000\u00a2\u0006\u0002\b0J\u0017\u00101\u001a\u00020\u001b2\b\b\u0002\u00102\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b3J\b\u00104\u001a\u00020\u001bH\u0016J\u0018\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00069"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/SqlTask;", "Lcom/netflix/spinnaker/clouddriver/data/task/Task;", "id", "", "ownerId", "requestId", "startTimeMs", "", "sagaIds", "", "Lcom/netflix/spinnaker/clouddriver/data/task/SagaId;", "repository", "Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskRepository;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/util/Set;Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskRepository;)V", "dirty", "Ljava/util/concurrent/atomic/AtomicBoolean;", "history", "", "Lcom/netflix/spinnaker/clouddriver/data/task/Status;", "getOwnerId$clouddriver_sql", "()Ljava/lang/String;", "getRequestId$clouddriver_sql", "resultObjects", "", "getStartTimeMs$clouddriver_sql", "()J", "addResultObjects", "", "results", "addSagaId", "sagaId", "complete", "fail", "retryable", "", "getHistory", "", "getId", "getOwnerId", "getRequestId", "getResultObjects", "getSagaIds", "getStartTimeMs", "getStatus", "hasSagaIds", "hydrateHistory", "hydrateHistory$clouddriver_sql", "hydrateResultObjects", "hydrateResultObjects$clouddriver_sql", "refresh", "force", "refresh$clouddriver_sql", "retry", "updateStatus", "phase", "status", "Companion", "clouddriver-sql"})
public final class SqlTask
implements Task {
    private List<Object> resultObjects;
    private List<Status> history;
    private final AtomicBoolean dirty;
    private final String id;
    @JsonIgnore
    @NotNull
    private final String ownerId;
    @JsonIgnore
    @NotNull
    private final String requestId;
    @JsonIgnore
    private final long startTimeMs;
    private final Set<SagaId> sagaIds;
    private final SqlTaskRepository repository;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getOwnerId() {
        return this.ownerId;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    @NotNull
    public String getRequestId() {
        return this.requestId;
    }

    @NotNull
    public List<Object> getResultObjects() {
        SqlTask.refresh$clouddriver_sql$default(this, false, 1, null);
        return this.resultObjects;
    }

    public void addResultObjects(@NotNull List<Object> results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        if (results.isEmpty()) {
            return;
        }
        this.dirty.set(true);
        this.repository.addResultObjects$clouddriver_sql(results, this);
        log.debug("Added {} results to task {}", (Object)results.size(), (Object)this.id);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Status> getHistory() {
        void $this$mapTo$iv$iv;
        SqlTask.refresh$clouddriver_sql$default(this, false, 1, null);
        Iterable $this$map$iv = this.history;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Status status = (Status)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TaskDisplayStatus taskDisplayStatus = new TaskDisplayStatus((Status)it);
            collection.add(taskDisplayStatus);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Status getStatus() {
        SqlTask.refresh$clouddriver_sql$default(this, false, 1, null);
        return (Status)CollectionsKt.lastOrNull(this.history);
    }

    public void updateStatus(@NotNull String phase, @NotNull String status) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.dirty.set(true);
        this.repository.updateCurrentStatus$clouddriver_sql(this, phase, status);
        log.debug("Updated status for task {} phase={} status={}", new Object[]{this.id, phase, status});
    }

    public void complete() {
        this.dirty.set(true);
        this.repository.updateState$clouddriver_sql(this, TaskState.COMPLETED);
        log.debug("Set task {} as complete", (Object)this.id);
    }

    public void fail() {
        this.dirty.set(true);
        this.repository.updateState$clouddriver_sql(this, TaskState.FAILED);
    }

    public void fail(boolean retryable) {
        this.dirty.set(true);
        this.repository.updateState$clouddriver_sql(this, retryable ? TaskState.FAILED_RETRYABLE : TaskState.FAILED);
    }

    public void addSagaId(@NotNull SagaId sagaId) {
        Intrinsics.checkNotNullParameter((Object)sagaId, (String)"sagaId");
        this.dirty.set(true);
        this.sagaIds.add(sagaId);
        this.repository.updateSagaIds(this);
        log.debug("Added sagaId with name={} and id={} to task={}", new Object[]{sagaId.getName(), sagaId.getId(), this.id});
    }

    @NotNull
    public Set<SagaId> getSagaIds() {
        return this.sagaIds;
    }

    public boolean hasSagaIds() {
        Collection collection = this.sagaIds;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public void retry() {
        this.dirty.set(true);
        this.repository.updateState$clouddriver_sql(this, TaskState.STARTED);
    }

    public final void hydrateResultObjects$clouddriver_sql(@NotNull List<Object> resultObjects) {
        Intrinsics.checkNotNullParameter(resultObjects, (String)"resultObjects");
        this.dirty.set(false);
        this.resultObjects = resultObjects;
    }

    public final void hydrateHistory$clouddriver_sql(@NotNull List<Status> history) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        this.dirty.set(false);
        this.history = history;
    }

    public final void refresh$clouddriver_sql(boolean force) {
        Task task;
        if ((this.dirty.getAndSet(false) || force) && (task = this.repository.retrieveInternal$clouddriver_sql(this.id)) != null) {
            this.history.clear();
            this.resultObjects.clear();
            List list = task.getHistory();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"task.history");
            this.history.addAll(list);
            List list2 = task.getResultObjects();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"task.resultObjects");
            this.resultObjects.addAll(list2);
        }
    }

    public static /* synthetic */ void refresh$clouddriver_sql$default(SqlTask sqlTask, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        sqlTask.refresh$clouddriver_sql(bl);
    }

    @NotNull
    public final String getOwnerId$clouddriver_sql() {
        return this.ownerId;
    }

    @NotNull
    public final String getRequestId$clouddriver_sql() {
        return this.requestId;
    }

    public final long getStartTimeMs$clouddriver_sql() {
        return this.startTimeMs;
    }

    public SqlTask(@NotNull String id, @NotNull String ownerId, @NotNull String requestId, long startTimeMs, @NotNull Set<SagaId> sagaIds, @NotNull SqlTaskRepository repository) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter(sagaIds, (String)"sagaIds");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.id = id;
        this.ownerId = ownerId;
        this.requestId = requestId;
        this.startTimeMs = startTimeMs;
        this.sagaIds = sagaIds;
        this.repository = repository;
        boolean bl = false;
        this.resultObjects = new ArrayList();
        bl = false;
        this.history = new ArrayList();
        this.dirty = new AtomicBoolean(false);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(SqlTask.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/SqlTask$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

