/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.event.Aggregate;
import com.netflix.spinnaker.clouddriver.event.CompositeSpinnakerEvent;
import com.netflix.spinnaker.clouddriver.event.EventMetadata;
import com.netflix.spinnaker.clouddriver.event.SpinnakerEvent;
import com.netflix.spinnaker.clouddriver.event.exceptions.InvalidEventTypeException;
import com.netflix.spinnaker.clouddriver.sql.event.SqlAggregate;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0000\u001a\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a0\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u000e*\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0001H\u0000\u00a8\u0006\u0012"}, d2={"fetchAggregates", "", "Lcom/netflix/spinnaker/clouddriver/sql/event/SqlAggregate;", "Lorg/jooq/Select;", "Lorg/jooq/Record;", "fetchEvents", "Lcom/netflix/spinnaker/clouddriver/event/SpinnakerEvent;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "toSqlValues", "", "", "withConditions", "Lorg/jooq/SelectConditionStep;", "R", "Lorg/jooq/SelectJoinStep;", "conditions", "Lorg/jooq/Condition;", "clouddriver-sql"})
public final class DslKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <R extends Record> SelectConditionStep<R> withConditions(@NotNull SelectJoinStep<R> $this$withConditions, @NotNull List<? extends Condition> conditions) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter($this$withConditions, (String)"$this$withConditions");
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Iterable iterable = conditions;
        boolean bl = false;
        if (!iterable.isEmpty()) {
            void $this$reduce$iv;
            iterable = conditions;
            SelectJoinStep<R> selectJoinStep = $this$withConditions;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void condition;
                Condition condition2 = (Condition)iterator$iv.next();
                Condition acc = (Condition)accumulator$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)acc.and((Condition)condition), (String)"acc.and(condition)");
            }
            Object t = accumulator$iv;
            SelectConditionStep selectConditionStep2 = selectJoinStep.where((Condition)t);
            selectConditionStep = selectConditionStep2;
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"this.where(\n    conditio\u2026 acc.and(condition) }\n  )");
        } else {
            SelectConditionStep selectConditionStep3 = $this$withConditions.where("1=1");
            selectConditionStep = selectConditionStep3;
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep3, (String)"where(\"1=1\")");
        }
        return selectConditionStep;
    }

    @NotNull
    public static final List<SqlAggregate> fetchAggregates(@NotNull Select<? extends Record> $this$fetchAggregates) {
        Intrinsics.checkNotNullParameter($this$fetchAggregates, (String)"$this$fetchAggregates");
        ResultSet resultSet = $this$fetchAggregates.fetch().intoResultSet();
        boolean bl = false;
        boolean bl2 = false;
        ResultSet rs = resultSet;
        boolean bl3 = false;
        boolean bl4 = false;
        List list = new ArrayList();
        boolean bl5 = false;
        boolean bl6 = false;
        List $this$apply = list;
        boolean bl7 = false;
        while (rs.next()) {
            String string = rs.getString("aggregate_type");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rs.getString(\"aggregate_type\")");
            String string2 = rs.getString("aggregate_id");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(\"aggregate_id\")");
            Aggregate aggregate = new Aggregate(string, string2, rs.getLong("version"));
            String string3 = rs.getString("token");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"rs.getString(\"token\")");
            $this$apply.add(new SqlAggregate(aggregate, string3));
        }
        return list;
    }

    @NotNull
    public static final Collection<Object> toSqlValues(@NotNull SpinnakerEvent $this$toSqlValues, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)$this$toSqlValues, (String)"$this$toSqlValues");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return CollectionsKt.listOf((Object[])new Serializable[]{(Serializable)((Object)$this$toSqlValues.getMetadata().getId()), (Serializable)((Object)$this$toSqlValues.getMetadata().getAggregateType()), (Serializable)((Object)$this$toSqlValues.getMetadata().getAggregateId()), Long.valueOf($this$toSqlValues.getMetadata().getSequence()), Long.valueOf($this$toSqlValues.getMetadata().getOriginatingVersion()), (Serializable)DSL.currentTimestamp(), (Serializable)((Object)objectMapper.writeValueAsString((Object)$this$toSqlValues.getMetadata())), (Serializable)((Object)objectMapper.writeValueAsString((Object)$this$toSqlValues))});
    }

    @NotNull
    public static final List<SpinnakerEvent> fetchEvents(@NotNull Select<? extends Record> $this$fetchEvents, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter($this$fetchEvents, (String)"$this$fetchEvents");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        ResultSet resultSet = $this$fetchEvents.fetch().intoResultSet();
        boolean bl = false;
        boolean bl2 = false;
        ResultSet rs = resultSet;
        boolean bl3 = false;
        boolean bl4 = false;
        List list = new ArrayList();
        boolean bl5 = false;
        boolean bl6 = false;
        List $this$apply = list;
        boolean bl7 = false;
        while (rs.next()) {
            try {
                Object object = objectMapper.readValue(rs.getString("data"), SpinnakerEvent.class);
                boolean bl8 = false;
                boolean bl9 = false;
                SpinnakerEvent $this$apply2 = (SpinnakerEvent)object;
                boolean bl10 = false;
                Object object2 = objectMapper.readValue(rs.getString("metadata"), EventMetadata.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"objectMapper.readValue(r\u2026ventMetadata::class.java)");
                $this$apply2.setMetadata((EventMetadata)object2);
                SpinnakerEvent event = (SpinnakerEvent)object;
                if (event instanceof CompositeSpinnakerEvent) {
                    Iterable $this$forEach$iv = ((CompositeSpinnakerEvent)event).getComposedEvents();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SpinnakerEvent it = (SpinnakerEvent)element$iv;
                        boolean bl11 = false;
                        it.setMetadata(EventMetadata.copy$default((EventMetadata)event.getMetadata(), (String)"N/A", null, null, (long)-1L, (long)0L, null, null, null, (int)246, null));
                    }
                }
                SpinnakerEvent spinnakerEvent = event;
                Intrinsics.checkNotNullExpressionValue((Object)spinnakerEvent, (String)"event");
                $this$apply.add(spinnakerEvent);
            }
            catch (JsonProcessingException e) {
                throw (Throwable)new InvalidEventTypeException((Throwable)e);
            }
        }
        return list;
    }
}

