/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql.event;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.RunnableAgent;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.CoreProvider;
import com.netflix.spinnaker.clouddriver.sql.SqlAgent;
import com.netflix.spinnaker.config.ConnectionPools;
import com.netflix.spinnaker.config.SqlEventCleanupAgentConfigProperties;
import com.netflix.spinnaker.kork.annotations.VisibleForTesting;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/event/SqlEventCleanupAgent;", "Lcom/netflix/spinnaker/cats/agent/RunnableAgent;", "Lcom/netflix/spinnaker/clouddriver/cache/CustomScheduledAgent;", "Lcom/netflix/spinnaker/clouddriver/sql/SqlAgent;", "jooq", "Lorg/jooq/DSLContext;", "registry", "Lcom/netflix/spectator/api/Registry;", "properties", "Lcom/netflix/spinnaker/config/SqlEventCleanupAgentConfigProperties;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "(Lorg/jooq/DSLContext;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/config/SqlEventCleanupAgentConfigProperties;Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;)V", "deletedId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "timingId", "getAgentType", "", "getPollIntervalMillis", "", "getProviderName", "getTimeoutMillis", "run", "", "Companion", "clouddriver-sql"})
public final class SqlEventCleanupAgent
implements RunnableAgent,
CustomScheduledAgent,
SqlAgent {
    private final Lazy log$delegate;
    private final Id deletedId;
    private final Id timingId;
    private final DSLContext jooq;
    private final Registry registry;
    private final SqlEventCleanupAgentConfigProperties properties;
    private final DynamicConfigService dynamicConfigService;
    @NotNull
    public static final String EVENT_CLEANUP_LIMIT_KEY = "spinnaker.clouddriver.eventing.cleanup-agent.cleanup-limit";
    @NotNull
    public static final String EVENT_CLEANUP_INTERVAL_KEY = "spinnaker.clouddriver.eventing.cleanup-agent.frequency";
    @NotNull
    public static final String EVENT_CLEANUP_TIMEOUT_KEY = "spinnaker.clouddriver.event.cleanup-agent.timeout";
    public static final Companion Companion = new Companion(null);

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        SqlEventCleanupAgent sqlEventCleanupAgent = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void run() {
        Duration duration = Duration.ofDays(this.properties.getMaxAggregateAgeDays());
        Instant cutoff = Instant.now().minus(duration);
        Integer limit = (Integer)this.dynamicConfigService.getConfig(Integer.TYPE, EVENT_CLEANUP_LIMIT_KEY, (Object)1000);
        this.getLog().info("Deleting aggregates last updated earlier than " + cutoff + " (" + duration + "), max " + limit + " events");
        this.registry.timer(this.timingId).record(new Runnable(this, duration, limit){
            final /* synthetic */ SqlEventCleanupAgent this$0;
            final /* synthetic */ Duration $duration;
            final /* synthetic */ Integer $limit;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Instant threshold = Instant.now().minus(this.$duration);
                String name$iv = ConnectionPools.EVENTS.getValue();
                boolean $i$f$withPool = false;
                NamedDatabaseContextHolder.INSTANCE.set(name$iv);
                try {
                    boolean bl = false;
                    SelectConditionStep selectConditionStep = SqlEventCleanupAgent.access$getJooq$p(this.this$0).select((SelectField)DSL.field((String)"aggregate_type"), (SelectField)DSL.field((String)"aggregate_id")).from((TableLike)DSL.table((String)"event_aggregates")).where(DSL.field((String)"last_change_timestamp").lt((Object)new Timestamp(threshold.toEpochMilli())));
                    Integer n = this.$limit;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"limit");
                    ResultSet rs = selectConditionStep.limit(n.intValue()).fetch().intoResultSet();
                    long deleted = 0L;
                    while (rs.next()) {
                        long l = deleted;
                        deleted = l + 1L;
                        SqlEventCleanupAgent.access$getJooq$p(this.this$0).deleteFrom(DSL.table((String)"event_aggregates")).where(DSL.field((String)"aggregate_type").eq((Object)rs.getString("aggregate_type")).and(DSL.field((String)"aggregate_id").eq((Object)rs.getString("aggregate_id")))).execute();
                    }
                    SqlEventCleanupAgent.access$getRegistry$p(this.this$0).counter(SqlEventCleanupAgent.access$getDeletedId$p(this.this$0)).increment(deleted);
                    SqlEventCleanupAgent.access$getLog$p(this.this$0).info("Deleted " + deleted + " event aggregates");
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    NamedDatabaseContextHolder.INSTANCE.clear();
                }
            }
            {
                this.this$0 = sqlEventCleanupAgent;
                this.$duration = duration;
                this.$limit = n;
            }
        });
    }

    @NotNull
    public String getAgentType() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @NotNull
    public String getProviderName() {
        String string = CoreProvider.PROVIDER_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CoreProvider.PROVIDER_NAME");
        return string;
    }

    public long getPollIntervalMillis() {
        return Duration.parse((CharSequence)this.dynamicConfigService.getConfig(String.class, EVENT_CLEANUP_INTERVAL_KEY, (Object)"PT1M")).toMillis();
    }

    public long getTimeoutMillis() {
        return Duration.parse((CharSequence)this.dynamicConfigService.getConfig(String.class, EVENT_CLEANUP_TIMEOUT_KEY, (Object)"PT45S")).toMillis();
    }

    public SqlEventCleanupAgent(@NotNull DSLContext jooq, @NotNull Registry registry, @NotNull SqlEventCleanupAgentConfigProperties properties, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        this.jooq = jooq;
        this.registry = registry;
        this.properties = properties;
        this.dynamicConfigService = dynamicConfigService;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SqlEventCleanupAgent this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = sqlEventCleanupAgent;
                super(0);
            }
        }));
        this.deletedId = this.registry.createId("sql.eventCleanupAgent.deleted");
        this.timingId = this.registry.createId("sql.eventCleanupAgent.timing");
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlEventCleanupAgent $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ Registry access$getRegistry$p(SqlEventCleanupAgent $this) {
        return $this.registry;
    }

    public static final /* synthetic */ Id access$getDeletedId$p(SqlEventCleanupAgent $this) {
        return $this.deletedId;
    }

    public static final /* synthetic */ Logger access$getLog$p(SqlEventCleanupAgent $this) {
        return $this.getLog();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0081\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/event/SqlEventCleanupAgent$Companion;", "", "()V", "EVENT_CLEANUP_INTERVAL_KEY", "", "EVENT_CLEANUP_LIMIT_KEY", "EVENT_CLEANUP_TIMEOUT_KEY", "clouddriver-sql"})
    @VisibleForTesting
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

