/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.RunnableAgent;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.CoreProvider;
import com.netflix.spinnaker.clouddriver.data.task.TaskState;
import com.netflix.spinnaker.clouddriver.sql.CleanupCandidateIds;
import com.netflix.spinnaker.clouddriver.sql.SqlKt;
import com.netflix.spinnaker.clouddriver.sql.SqlTaskCleanupAgent;
import com.netflix.spinnaker.clouddriver.sql.SqlTaskCleanupAgent$run$;
import com.netflix.spinnaker.config.ConnectionPools;
import com.netflix.spinnaker.config.SqlTaskCleanupAgentProperties;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskCleanupAgent;", "Lcom/netflix/spinnaker/cats/agent/RunnableAgent;", "Lcom/netflix/spinnaker/clouddriver/cache/CustomScheduledAgent;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "registry", "Lcom/netflix/spectator/api/Registry;", "properties", "Lcom/netflix/spinnaker/config/SqlTaskCleanupAgentProperties;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/config/SqlTaskCleanupAgentProperties;)V", "deletedId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "timingId", "getAgentType", "", "getPollIntervalMillis", "", "getProviderName", "getTimeoutMillis", "run", "", "Companion", "clouddriver-sql"})
public final class SqlTaskCleanupAgent
implements RunnableAgent,
CustomScheduledAgent {
    private final Logger log;
    private final Id deletedId;
    private final Id timingId;
    private final DSLContext jooq;
    private final Clock clock;
    private final Registry registry;
    private final SqlTaskCleanupAgentProperties properties;
    private static final long DEFAULT_POLL_INTERVAL_MILLIS;
    private static final long DEFAULT_TIMEOUT_MILLIS;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String name$iv = ConnectionPools.TASKS.getValue();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            CleanupCandidateIds candidates2 = (CleanupCandidateIds)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, CleanupCandidateIds>(this){
                final /* synthetic */ SqlTaskCleanupAgent this$0;
                {
                    this.this$0 = sqlTaskCleanupAgent;
                    super(1);
                }

                @NotNull
                public final CleanupCandidateIds invoke(@NotNull DSLContext j) {
                    Intrinsics.checkNotNullParameter((Object)j, (String)"j");
                    Result candidates2 = j.select((SelectField)DSL.field((String)"id"), (SelectField)DSL.field((String)"task_id")).from((TableLike)SqlKt.getTaskStatesTable()).where(DSL.field((String)"state").in(new Object[]{TaskState.COMPLETED.toString(), TaskState.FAILED.toString()}).and(DSL.field((String)"created_at").lessOrEqual((Object)SqlTaskCleanupAgent.access$getClock$p(this.this$0).instant().minusMillis(SqlTaskCleanupAgent.access$getProperties$p(this.this$0).getCompletedTtlMs()).toEpochMilli()))).fetch();
                    List list = candidates2.map((RecordMapper)run.1.candidates.candidateTaskIds.1.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"candidates.map { r -> r.\u2026getValue(r)?.toString() }");
                    List candidateTaskIds2 = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)list));
                    boolean bl = false;
                    List candidateTaskStateIds = new ArrayList<E>();
                    boolean bl2 = false;
                    List candidateResultIds = new ArrayList<E>();
                    boolean bl3 = false;
                    List candidateOutputIds = new ArrayList<E>();
                    Collection collection = candidateTaskIds2;
                    boolean bl4 = false;
                    if (!collection.isEmpty()) {
                        CollectionsKt.chunked((Iterable)candidateTaskIds2, (int)SqlTaskCleanupAgent.access$getProperties$p(this.this$0).getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Boolean>(candidateTaskStateIds, j, candidateResultIds, candidateOutputIds){
                            final /* synthetic */ List $candidateTaskStateIds;
                            final /* synthetic */ DSLContext $j;
                            final /* synthetic */ List $candidateResultIds;
                            final /* synthetic */ List $candidateOutputIds;
                            {
                                this.$candidateTaskStateIds = list;
                                this.$j = dSLContext;
                                this.$candidateResultIds = list2;
                                this.$candidateOutputIds = list3;
                                super(1);
                            }

                            public final boolean invoke(@NotNull List<String> chunk) {
                                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                                Collection $this$toTypedArray$iv = chunk;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                if (stringArray == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                List list = this.$j.select((SelectField)DSL.field((String)"id")).from((TableLike)SqlKt.getTaskStatesTable()).where(DSL.field((String)"task_id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).fetch("id", String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"j.select(field(\"id\"))\n  \u2026\"id\", String::class.java)");
                                this.$candidateTaskStateIds.addAll(CollectionsKt.filterNotNull((Iterable)list));
                                $this$toTypedArray$iv = chunk;
                                $i$f$toTypedArray = false;
                                thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                                if (stringArray2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                List list2 = this.$j.select((SelectField)DSL.field((String)"id")).from((TableLike)SqlKt.getTaskResultsTable()).where(DSL.field((String)"task_id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).fetch("id", String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"j.select(field(\"id\"))\n  \u2026\"id\", String::class.java)");
                                this.$candidateResultIds.addAll(CollectionsKt.filterNotNull((Iterable)list2));
                                $this$toTypedArray$iv = chunk;
                                $i$f$toTypedArray = false;
                                thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
                                if (stringArray3 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                List list3 = this.$j.select((SelectField)DSL.field((String)"id")).from((TableLike)SqlKt.getTaskOutputsTable()).where(DSL.field((String)"task_id").in((Object[])Arrays.copyOf(stringArray3, stringArray3.length))).fetch("id", String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"j.select(field(\"id\"))\n  \u2026\"id\", String::class.java)");
                                return this.$candidateOutputIds.addAll(CollectionsKt.filterNotNull((Iterable)list3));
                            }
                        }));
                    }
                    return new CleanupCandidateIds(candidateTaskIds2, candidateTaskStateIds, candidateResultIds, candidateOutputIds);
                }
            });
            if (candidates2.hasAny()) {
                this.log.info("Cleaning up {} completed tasks ({} states, {} results, {} output objects)", new Object[]{candidates2.getTaskIds().size(), candidates2.getStateIds().size(), candidates2.getResultIds().size(), candidates2.getOutputIds().size()});
                this.registry.timer(this.timingId).record(new Runnable(candidates2, this){
                    final /* synthetic */ CleanupCandidateIds $candidates;
                    final /* synthetic */ SqlTaskCleanupAgent this$0;
                    {
                        this.$candidates = cleanupCandidateIds;
                        this.this$0 = sqlTaskCleanupAgent;
                    }

                    public final void run() {
                        CollectionsKt.chunked((Iterable)this.$candidates.getResultIds(), (int)SqlTaskCleanupAgent.access$getProperties$p(this.this$0).getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this){
                            final /* synthetic */ run$$inlined$withPool$lambda$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull List<String> chunk) {
                                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                                SqlKt.transactional(SqlTaskCleanupAgent.access$getJooq$p(this.this$0.this$0), (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(chunk){
                                    final /* synthetic */ List $chunk;
                                    {
                                        this.$chunk = list;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull DSLContext ctx) {
                                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                                        Collection $this$toTypedArray$iv = this.$chunk;
                                        boolean $i$f$toTypedArray = false;
                                        Collection thisCollection$iv = $this$toTypedArray$iv;
                                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                        if (stringArray == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                        }
                                        ctx.deleteFrom(SqlKt.getTaskResultsTable()).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).execute();
                                    }
                                }));
                            }
                        }));
                        CollectionsKt.chunked((Iterable)this.$candidates.getStateIds(), (int)SqlTaskCleanupAgent.access$getProperties$p(this.this$0).getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this){
                            final /* synthetic */ run$$inlined$withPool$lambda$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull List<String> chunk) {
                                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                                SqlKt.transactional(SqlTaskCleanupAgent.access$getJooq$p(this.this$0.this$0), (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(chunk){
                                    final /* synthetic */ List $chunk;
                                    {
                                        this.$chunk = list;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull DSLContext ctx) {
                                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                                        Collection $this$toTypedArray$iv = this.$chunk;
                                        boolean $i$f$toTypedArray = false;
                                        Collection thisCollection$iv = $this$toTypedArray$iv;
                                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                        if (stringArray == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                        }
                                        ctx.deleteFrom(SqlKt.getTaskStatesTable()).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).execute();
                                    }
                                }));
                            }
                        }));
                        CollectionsKt.chunked((Iterable)this.$candidates.getOutputIds(), (int)SqlTaskCleanupAgent.access$getProperties$p(this.this$0).getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this){
                            final /* synthetic */ run$$inlined$withPool$lambda$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull List<String> chunk) {
                                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                                SqlKt.transactional(SqlTaskCleanupAgent.access$getJooq$p(this.this$0.this$0), (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(chunk){
                                    final /* synthetic */ List $chunk;
                                    {
                                        this.$chunk = list;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull DSLContext ctx) {
                                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                                        Collection $this$toTypedArray$iv = this.$chunk;
                                        boolean $i$f$toTypedArray = false;
                                        Collection thisCollection$iv = $this$toTypedArray$iv;
                                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                        if (stringArray == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                        }
                                        ctx.deleteFrom(SqlKt.getTaskOutputsTable()).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).execute();
                                    }
                                }));
                            }
                        }));
                        CollectionsKt.chunked((Iterable)this.$candidates.getTaskIds(), (int)SqlTaskCleanupAgent.access$getProperties$p(this.this$0).getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this){
                            final /* synthetic */ run$$inlined$withPool$lambda$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull List<String> chunk) {
                                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                                SqlKt.transactional(SqlTaskCleanupAgent.access$getJooq$p(this.this$0.this$0), (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(chunk){
                                    final /* synthetic */ List $chunk;
                                    {
                                        this.$chunk = list;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull DSLContext ctx) {
                                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                                        Collection $this$toTypedArray$iv = this.$chunk;
                                        boolean $i$f$toTypedArray = false;
                                        Collection thisCollection$iv = $this$toTypedArray$iv;
                                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                        if (stringArray == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                        }
                                        ctx.deleteFrom(SqlKt.getTasksTable()).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).execute();
                                    }
                                }));
                            }
                        }));
                    }
                });
                this.registry.counter(this.deletedId).increment((long)candidates2.getTaskIds().size());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @NotNull
    public String getAgentType() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @NotNull
    public String getProviderName() {
        String string = CoreProvider.PROVIDER_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CoreProvider.PROVIDER_NAME");
        return string;
    }

    public long getPollIntervalMillis() {
        return DEFAULT_POLL_INTERVAL_MILLIS;
    }

    public long getTimeoutMillis() {
        return DEFAULT_TIMEOUT_MILLIS;
    }

    public SqlTaskCleanupAgent(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull Registry registry, @NotNull SqlTaskCleanupAgentProperties properties) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.jooq = jooq;
        this.clock = clock;
        this.registry = registry;
        this.properties = properties;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.deletedId = this.registry.createId("sql.taskCleanupAgent.deleted");
        this.timingId = this.registry.createId("sql.taskCleanupAgent.timing");
    }

    static {
        Companion = new Companion(null);
        DEFAULT_POLL_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(3L);
        DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(3L);
    }

    public static final /* synthetic */ Clock access$getClock$p(SqlTaskCleanupAgent $this) {
        return $this.clock;
    }

    public static final /* synthetic */ SqlTaskCleanupAgentProperties access$getProperties$p(SqlTaskCleanupAgent $this) {
        return $this.properties;
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlTaskCleanupAgent $this) {
        return $this.jooq;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskCleanupAgent$Companion;", "", "()V", "DEFAULT_POLL_INTERVAL_MILLIS", "", "DEFAULT_TIMEOUT_MILLIS", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

