/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql.security;

import com.netflix.spinnaker.clouddriver.security.AccountDefinitionMapper;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionRepository;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionTypes;
import com.netflix.spinnaker.clouddriver.sql.SqlKt;
import com.netflix.spinnaker.clouddriver.sql.security.SqlAccountDefinitionException;
import com.netflix.spinnaker.clouddriver.sql.security.SqlAccountDefinitionRepository$getByName$;
import com.netflix.spinnaker.clouddriver.sql.security.SqlAccountDefinitionRepository$listByType$;
import com.netflix.spinnaker.clouddriver.sql.security.SqlAccountDefinitionRepository$revisionHistory$;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.JSON;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.RecordMapper;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016J*\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/security/SqlAccountDefinitionRepository;", "Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionRepository;", "jooq", "Lorg/jooq/DSLContext;", "mapper", "Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionMapper;", "clock", "Ljava/time/Clock;", "poolName", "", "(Lorg/jooq/DSLContext;Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionMapper;Ljava/time/Clock;Ljava/lang/String;)V", "create", "", "definition", "Lcom/netflix/spinnaker/credentials/definition/CredentialsDefinition;", "delete", "name", "deserializeAccountData", "accountData", "findLatestVersion", "Lorg/jooq/Select;", "Lorg/jooq/Record1;", "", "getByName", "getCredentialsType", "listByType", "", "typeName", "limit", "startingAccountName", "revisionHistory", "Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionRepository$Revision;", "save", "update", "Companion", "clouddriver-sql"})
public final class SqlAccountDefinitionRepository
implements AccountDefinitionRepository {
    private final DSLContext jooq;
    private final AccountDefinitionMapper mapper;
    private final Clock clock;
    private final String poolName;
    private static final Table<Record> accountsTable;
    private static final Table<Record> accountHistoryTable;
    private static final Field<String> idColumn;
    private static final Field<JSON> bodyColumn;
    private static final Field<String> typeColumn;
    private static final Field<Boolean> deletedColumn;
    private static final Field<Long> createdColumn;
    private static final Field<Long> lastModifiedColumn;
    private static final Field<String> modifiedByColumn;
    private static final Field<Integer> versionColumn;
    private static final Logger LOGGER;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CredentialsDefinition getByName(@NotNull String name) {
        CredentialsDefinition credentialsDefinition;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            credentialsDefinition = (CredentialsDefinition)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, CredentialsDefinition>(this, name){
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                final /* synthetic */ String $name$inlined;
                {
                    this.this$0 = sqlAccountDefinitionRepository;
                    this.$name$inlined = string;
                    super(1);
                }

                public final CredentialsDefinition invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return (CredentialsDefinition)ctx.select((SelectField)SqlAccountDefinitionRepository.access$getBodyColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name$inlined)).fetchOne((RecordMapper)new RecordMapper<Record1<JSON>, CredentialsDefinition>(this){
                        final /* synthetic */ getByName$$inlined$withPool$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final CredentialsDefinition map(Record1<JSON> $dstr$json) {
                            JSON json = (JSON)$dstr$json.component1();
                            return SqlAccountDefinitionRepository.access$getMapper$p(this.this$0.this$0).deserialize(json.data());
                        }
                    });
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return credentialsDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<? extends CredentialsDefinition> listByType(@NotNull String typeName, int limit, @Nullable String startingAccountName) {
        List list;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            list = (List)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, List<CredentialsDefinition>>(this, typeName, startingAccountName, limit){
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                final /* synthetic */ String $typeName$inlined;
                final /* synthetic */ String $startingAccountName$inlined;
                final /* synthetic */ int $limit$inlined;
                {
                    this.this$0 = sqlAccountDefinitionRepository;
                    this.$typeName$inlined = string;
                    this.$startingAccountName$inlined = string2;
                    this.$limit$inlined = n;
                    super(1);
                }

                @NotNull
                public final List<CredentialsDefinition> invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    List conditions = CollectionsKt.mutableListOf((Object[])new Condition[]{SqlAccountDefinitionRepository.access$getTypeColumn$cp().eq((Object)this.$typeName$inlined)});
                    String string = this.$startingAccountName$inlined;
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        Collection collection = conditions;
                        Condition condition = SqlAccountDefinitionRepository.access$getIdColumn$cp().ge((Object)it);
                        boolean bl4 = false;
                        collection.add(condition);
                    }
                    List list = ctx.select((SelectField)SqlAccountDefinitionRepository.access$getBodyColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where((Collection)conditions).orderBy((OrderField)SqlAccountDefinitionRepository.access$getIdColumn$cp()).limit(this.$limit$inlined).fetch((RecordMapper)new RecordMapper<Record1<JSON>, CredentialsDefinition>(this){
                        final /* synthetic */ listByType$$inlined$withPool$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        @Nullable
                        public final CredentialsDefinition map(Record1<JSON> $dstr$json) {
                            JSON json = (JSON)$dstr$json.component1();
                            SqlAccountDefinitionRepository sqlAccountDefinitionRepository = this.this$0.this$0;
                            String string = json.data();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.data()");
                            return SqlAccountDefinitionRepository.access$deserializeAccountData(sqlAccountDefinitionRepository, string);
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.select(bodyColumn)\n \u2026(json.data())\n          }");
                    boolean bl = false;
                    return (List)CollectionsKt.filterNotNullTo((Iterable)list, (Collection)new ArrayList<E>());
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<? extends CredentialsDefinition> listByType(@NotNull String typeName) {
        List list;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            list = (List)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, List<CredentialsDefinition>>(this, typeName){
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                final /* synthetic */ String $typeName$inlined;
                {
                    this.this$0 = sqlAccountDefinitionRepository;
                    this.$typeName$inlined = string;
                    super(1);
                }

                @NotNull
                public final List<CredentialsDefinition> invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    List list = ctx.select((SelectField)SqlAccountDefinitionRepository.access$getBodyColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where(SqlAccountDefinitionRepository.access$getTypeColumn$cp().eq((Object)this.$typeName$inlined)).fetch((RecordMapper)new RecordMapper<Record1<JSON>, CredentialsDefinition>(this){
                        final /* synthetic */ listByType$$inlined$withPool$lambda$2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        @Nullable
                        public final CredentialsDefinition map(Record1<JSON> $dstr$json) {
                            JSON json = (JSON)$dstr$json.component1();
                            SqlAccountDefinitionRepository sqlAccountDefinitionRepository = this.this$0.this$0;
                            String string = json.data();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.data()");
                            return SqlAccountDefinitionRepository.access$deserializeAccountData(sqlAccountDefinitionRepository, string);
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.select(bodyColumn)\n \u2026(json.data())\n          }");
                    boolean bl = false;
                    return (List)CollectionsKt.filterNotNullTo((Iterable)list, (Collection)new ArrayList<E>());
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return list;
    }

    private final CredentialsDefinition deserializeAccountData(String accountData) {
        CredentialsDefinition credentialsDefinition;
        try {
            credentialsDefinition = this.mapper.deserialize(accountData);
        }
        catch (SecretException e) {
            LOGGER.warn("Unable to decrypt secret in account data (" + accountData + "). Skipping this account.", (Throwable)e);
            credentialsDefinition = null;
        }
        catch (Exception e) {
            LOGGER.error("Invalid account data loaded (" + accountData + "). Skipping this account; consider deleting or fixing it.", (Throwable)e);
            credentialsDefinition = null;
        }
        return credentialsDefinition;
    }

    private final String getCredentialsType(CredentialsDefinition definition) {
        Class<?> javaClass = definition.getClass();
        String string = AccountDefinitionTypes.getCredentialsTypeName(javaClass);
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("No @CredentialsType annotation found on " + javaClass);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(@NotNull CredentialsDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            String name = definition.getName();
            String typeName = this.getCredentialsType(definition);
            long timestamp = this.clock.millis();
            String user = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
            JSON body = JSON.valueOf((String)this.mapper.serialize(definition));
            try {
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(name, typeName, body, timestamp, user, this, definition){
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $typeName;
                    final /* synthetic */ JSON $body;
                    final /* synthetic */ long $timestamp;
                    final /* synthetic */ String $user;
                    final /* synthetic */ SqlAccountDefinitionRepository this$0;
                    final /* synthetic */ CredentialsDefinition $definition$inlined;
                    {
                        this.$name = string;
                        this.$typeName = string2;
                        this.$body = jSON;
                        this.$timestamp = l;
                        this.$user = string3;
                        this.this$0 = sqlAccountDefinitionRepository;
                        this.$definition$inlined = credentialsDefinition;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountsTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getCreatedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getModifiedByColumn$cp(), (Object)this.$user).execute();
                        InsertSetMoreStep insertSetMoreStep = ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp);
                        Field field = SqlAccountDefinitionRepository.access$getVersionColumn$cp();
                        String string = this.$name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        insertSetMoreStep.set(field, SqlAccountDefinitionRepository.access$findLatestVersion(this.this$0, string)).execute();
                    }
                }));
            }
            catch (DataAccessException e) {
                throw (Throwable)((Object)new SqlAccountDefinitionException("Cannot create account with definition " + body, e));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull CredentialsDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            String name = definition.getName();
            String typeName = this.getCredentialsType(definition);
            long timestamp = this.clock.millis();
            String user = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
            JSON body = JSON.valueOf((String)this.mapper.serialize(definition));
            try {
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(name, typeName, body, timestamp, user, this, definition){
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $typeName;
                    final /* synthetic */ JSON $body;
                    final /* synthetic */ long $timestamp;
                    final /* synthetic */ String $user;
                    final /* synthetic */ SqlAccountDefinitionRepository this$0;
                    final /* synthetic */ CredentialsDefinition $definition$inlined;
                    {
                        this.$name = string;
                        this.$typeName = string2;
                        this.$body = jSON;
                        this.$timestamp = l;
                        this.$user = string3;
                        this.this$0 = sqlAccountDefinitionRepository;
                        this.$definition$inlined = credentialsDefinition;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        InsertSetMoreStep insertSetMoreStep = ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountsTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getCreatedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getModifiedByColumn$cp(), (Object)this.$user);
                        boolean bl = false;
                        boolean bl2 = false;
                        InsertSetMoreStep $this$run = insertSetMoreStep;
                        boolean bl3 = false;
                        (SqlAccountDefinitionRepository.access$getJooq$p(this.this$0).dialect() == SQLDialect.POSTGRES ? $this$run.onConflict(new Field[]{SqlAccountDefinitionRepository.access$getIdColumn$cp()}).doUpdate() : $this$run.onDuplicateKeyUpdate()).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getModifiedByColumn$cp(), (Object)this.$user).execute();
                        InsertSetMoreStep insertSetMoreStep2 = ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp);
                        Field field = SqlAccountDefinitionRepository.access$getVersionColumn$cp();
                        String string = this.$name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        insertSetMoreStep2.set(field, SqlAccountDefinitionRepository.access$findLatestVersion(this.this$0, string)).execute();
                    }
                }));
            }
            catch (DataAccessException e) {
                throw (Throwable)((Object)new SqlAccountDefinitionException("Cannot save account with definition " + body, e));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@NotNull CredentialsDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            String name = definition.getName();
            String typeName = this.getCredentialsType(definition);
            long timestamp = this.clock.millis();
            String user = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
            JSON body = JSON.valueOf((String)this.mapper.serialize(definition));
            try {
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(body, timestamp, user, name, typeName, this, definition){
                    final /* synthetic */ JSON $body;
                    final /* synthetic */ long $timestamp;
                    final /* synthetic */ String $user;
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $typeName;
                    final /* synthetic */ SqlAccountDefinitionRepository this$0;
                    final /* synthetic */ CredentialsDefinition $definition$inlined;
                    {
                        this.$body = jSON;
                        this.$timestamp = l;
                        this.$user = string;
                        this.$name = string2;
                        this.$typeName = string3;
                        this.this$0 = sqlAccountDefinitionRepository;
                        this.$definition$inlined = credentialsDefinition;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        int rows = ctx.update(SqlAccountDefinitionRepository.access$getAccountsTable$cp()).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getModifiedByColumn$cp(), (Object)this.$user).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name)).execute();
                        if (rows != 1) {
                            throw (Throwable)new NotFoundException("No account found with name " + this.$name);
                        }
                        InsertSetMoreStep insertSetMoreStep = ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp);
                        Field field = SqlAccountDefinitionRepository.access$getVersionColumn$cp();
                        String string = this.$name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        insertSetMoreStep.set(field, SqlAccountDefinitionRepository.access$findLatestVersion(this.this$0, string)).execute();
                    }
                }));
            }
            catch (DataAccessException e) {
                throw (Throwable)((Object)new SqlAccountDefinitionException("Cannot update account with definition " + body, e));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            String string = (String)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, String>(this, name){
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                final /* synthetic */ String $name$inlined;
                {
                    this.this$0 = sqlAccountDefinitionRepository;
                    this.$name$inlined = string;
                    super(1);
                }

                public final String invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return (String)ctx.select((SelectField)SqlAccountDefinitionRepository.access$getTypeColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name$inlined)).fetchOne(SqlAccountDefinitionRepository.access$getTypeColumn$cp());
                }
            });
            if (string == null) {
                throw (Throwable)new NotFoundException("No account found with name " + name);
            }
            String typeName = string;
            try {
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, name){
                    final /* synthetic */ SqlAccountDefinitionRepository this$0;
                    final /* synthetic */ String $name$inlined;
                    {
                        this.this$0 = sqlAccountDefinitionRepository;
                        this.$name$inlined = string;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name$inlined).set(SqlAccountDefinitionRepository.access$getDeletedColumn$cp(), (Object)true).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)SqlAccountDefinitionRepository.access$getClock$p(this.this$0).millis()).set(SqlAccountDefinitionRepository.access$getVersionColumn$cp(), SqlAccountDefinitionRepository.access$findLatestVersion(this.this$0, this.$name$inlined)).execute();
                        ctx.deleteFrom(SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name$inlined)).execute();
                    }
                }));
            }
            catch (DataAccessException e) {
                throw (Throwable)((Object)new SqlAccountDefinitionException("Cannot delete account with name " + name, e));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Select<Record1<Integer>> findLatestVersion(String name) {
        SelectConditionStep selectConditionStep;
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectConditionStep selectConditionStep2 = (SelectConditionStep)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, SelectConditionStep<Record1<Integer>>>(this, name){
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                final /* synthetic */ String $name$inlined;
                {
                    this.this$0 = sqlAccountDefinitionRepository;
                    this.$name$inlined = string;
                    super(1);
                }

                public final SelectConditionStep<Record1<Integer>> invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return ctx.select((SelectField)DSL.count((Field)SqlAccountDefinitionRepository.access$getVersionColumn$cp()).plus((Number)1)).from((TableLike)SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name$inlined));
                }
            });
            selectConditionStep = selectConditionStep2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"withPool(poolName) {\n   \u2026n.eq(name))\n      }\n    }");
        return (Select)selectConditionStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<AccountDefinitionRepository.Revision> revisionHistory(@NotNull String name) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            List list2 = (List)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, List<AccountDefinitionRepository.Revision>>(this, name){
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                final /* synthetic */ String $name$inlined;
                {
                    this.this$0 = sqlAccountDefinitionRepository;
                    this.$name$inlined = string;
                    super(1);
                }

                public final List<AccountDefinitionRepository.Revision> invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return ctx.select((SelectField)SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (SelectField)SqlAccountDefinitionRepository.access$getVersionColumn$cp(), (SelectField)SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name$inlined)).orderBy((OrderField)SqlAccountDefinitionRepository.access$getVersionColumn$cp().desc()).fetch((RecordMapper)new RecordMapper<Record3<JSON, Integer, Long>, AccountDefinitionRepository.Revision>(this){
                        final /* synthetic */ revisionHistory$$inlined$withPool$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final AccountDefinitionRepository.Revision map(Record3<JSON, Integer, Long> $dstr$body$version$timestamp) {
                            CredentialsDefinition credentialsDefinition;
                            void body;
                            void version;
                            JSON jSON = (JSON)$dstr$body$version$timestamp.component1();
                            Integer n = (Integer)$dstr$body$version$timestamp.component2();
                            Long timestamp = (Long)$dstr$body$version$timestamp.component3();
                            void v0 = version;
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"version");
                            int n2 = v0.intValue();
                            Long l = timestamp;
                            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"timestamp");
                            long l2 = l;
                            void v4 = body;
                            if (v4 != null) {
                                void it;
                                void var5_5 = v4;
                                boolean bl = false;
                                boolean bl2 = false;
                                void var8_8 = var5_5;
                                long l3 = l2;
                                int n3 = n2;
                                boolean bl3 = false;
                                CredentialsDefinition credentialsDefinition2 = SqlAccountDefinitionRepository.access$getMapper$p(this.this$0.this$0).deserialize(it.data());
                                n2 = n3;
                                l2 = l3;
                                credentialsDefinition = credentialsDefinition2;
                            } else {
                                credentialsDefinition = null;
                            }
                            CredentialsDefinition credentialsDefinition3 = credentialsDefinition;
                            long l4 = l2;
                            int n4 = n2;
                            return new AccountDefinitionRepository.Revision(n4, l4, credentialsDefinition3);
                        }
                    });
                }
            });
            list = list2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"withPool(poolName) {\n   \u2026        ) }\n      }\n    }");
        return list;
    }

    public SqlAccountDefinitionRepository(@NotNull DSLContext jooq, @NotNull AccountDefinitionMapper mapper, @NotNull Clock clock, @NotNull String poolName) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        this.jooq = jooq;
        this.mapper = mapper;
        this.clock = clock;
        this.poolName = poolName;
    }

    static {
        Companion = new Companion(null);
        accountsTable = DSL.table((String)"accounts");
        accountHistoryTable = DSL.table((String)"accounts_history");
        idColumn = DSL.field((String)"id", String.class);
        bodyColumn = DSL.field((String)"body", JSON.class);
        typeColumn = DSL.field((String)"type", String.class);
        deletedColumn = DSL.field((String)"is_deleted", Boolean.TYPE);
        createdColumn = DSL.field((String)"created_at", Long.TYPE);
        lastModifiedColumn = DSL.field((String)"last_modified_at", Long.TYPE);
        modifiedByColumn = DSL.field((String)"last_modified_by", String.class);
        versionColumn = DSL.field((String)"version", Integer.TYPE);
        LOGGER = LogManager.getLogger(SqlAccountDefinitionRepository.class);
    }

    public static final /* synthetic */ Field access$getBodyColumn$cp() {
        return bodyColumn;
    }

    public static final /* synthetic */ Table access$getAccountsTable$cp() {
        return accountsTable;
    }

    public static final /* synthetic */ Field access$getIdColumn$cp() {
        return idColumn;
    }

    public static final /* synthetic */ AccountDefinitionMapper access$getMapper$p(SqlAccountDefinitionRepository $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ Field access$getTypeColumn$cp() {
        return typeColumn;
    }

    public static final /* synthetic */ CredentialsDefinition access$deserializeAccountData(SqlAccountDefinitionRepository $this, String accountData) {
        return $this.deserializeAccountData(accountData);
    }

    public static final /* synthetic */ Field access$getCreatedColumn$cp() {
        return createdColumn;
    }

    public static final /* synthetic */ Field access$getLastModifiedColumn$cp() {
        return lastModifiedColumn;
    }

    public static final /* synthetic */ Field access$getModifiedByColumn$cp() {
        return modifiedByColumn;
    }

    public static final /* synthetic */ Table access$getAccountHistoryTable$cp() {
        return accountHistoryTable;
    }

    public static final /* synthetic */ Field access$getVersionColumn$cp() {
        return versionColumn;
    }

    public static final /* synthetic */ Select access$findLatestVersion(SqlAccountDefinitionRepository $this, String name) {
        return $this.findLatestVersion(name);
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlAccountDefinitionRepository $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ Field access$getDeletedColumn$cp() {
        return deletedColumn;
    }

    public static final /* synthetic */ Clock access$getClock$p(SqlAccountDefinitionRepository $this) {
        return $this.clock;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00100\u0010 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00120\u0012 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0014\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00120\u0012 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0015\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00120\u0012 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0016\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00170\u0017 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/security/SqlAccountDefinitionRepository$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "accountHistoryTable", "Lorg/jooq/Table;", "Lorg/jooq/Record;", "accountsTable", "bodyColumn", "Lorg/jooq/Field;", "Lorg/jooq/JSON;", "createdColumn", "", "deletedColumn", "", "idColumn", "", "lastModifiedColumn", "modifiedByColumn", "typeColumn", "versionColumn", "", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

