/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.core.ClouddriverHostname;
import com.netflix.spinnaker.clouddriver.data.task.DefaultTaskStatus;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskOutput;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.data.task.TaskState;
import com.netflix.spinnaker.clouddriver.sql.SqlKt;
import com.netflix.spinnaker.clouddriver.sql.SqlTask;
import com.netflix.spinnaker.clouddriver.sql.TaskMapper;
import com.netflix.spinnaker.clouddriver.sql.TaskStatusMapper;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import de.huxhorn.sulky.ulid.ULID;
import java.sql.ResultSet;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.InsertValuesStepN;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectOrderByStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 E2\u00020\u0001:\u0001EB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ#\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J8\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002JD\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\t2\b\u0010!\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0016J \u0010\"\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0016J\u0013\u0010$\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\tH\u0096\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010#\u001a\u00020\tH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140'H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140'H\u0016J\u0017\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b*J\"\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140+2\u0006\u0010,\u001a\u00020-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010-H\u0002J#\u0010/\u001a\b\u0012\u0004\u0012\u00020\t002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u00101\u001a\u000202H\u0002\u00a2\u0006\u0002\u00103J\u001a\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\tH\u0002J%\u00106\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b;J\u000e\u0010<\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010=\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010>\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b?J\u0016\u0010@\u001a\u0004\u0018\u000105*\n\u0012\u0006\b\u0001\u0012\u00020B0AH\u0002J\u001a\u0010C\u001a\b\u0012\u0004\u0012\u0002050+*\n\u0012\u0006\b\u0001\u0012\u00020B0AH\u0002J\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00140+*\n\u0012\u0006\b\u0001\u0012\u00020B0AH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskRepository;", "Lcom/netflix/spinnaker/clouddriver/data/task/TaskRepository;", "jooq", "Lorg/jooq/DSLContext;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "clock", "Ljava/time/Clock;", "poolName", "", "(Lorg/jooq/DSLContext;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/time/Clock;Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addResultObjects", "", "results", "", "", "task", "Lcom/netflix/spinnaker/clouddriver/data/task/Task;", "addResultObjects$clouddriver_sql", "addToHistory", "ctx", "id", "taskId", "state", "Lcom/netflix/spinnaker/clouddriver/data/task/TaskState;", "phase", "status", "addToOutput", "manifestName", "stdOut", "stdError", "create", "clientRequestId", "get", "getByClientRequestId", "list", "", "listByThisInstance", "retrieveInternal", "retrieveInternal$clouddriver_sql", "", "condition", "Lorg/jooq/Condition;", "relationshipCondition", "runningTaskIds", "", "thisInstance", "", "(Lorg/jooq/DSLContext;Z)[Ljava/lang/String;", "selectLatestState", "Lcom/netflix/spinnaker/clouddriver/data/task/DefaultTaskStatus;", "updateCurrentStatus", "updateCurrentStatus$clouddriver_sql", "updateOutput", "taskOutput", "Lcom/netflix/spinnaker/clouddriver/data/task/TaskOutput;", "updateOutput$clouddriver_sql", "updateOwnerId", "updateSagaIds", "updateState", "updateState$clouddriver_sql", "fetchTaskStatus", "Lorg/jooq/Select;", "Lorg/jooq/Record;", "fetchTaskStatuses", "fetchTasks", "Companion", "clouddriver-sql"})
public final class SqlTaskRepository
implements TaskRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DSLContext jooq;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final Clock clock;
    @NotNull
    private final String poolName;
    private final Logger log;
    @NotNull
    private static final ULID ulid = new ULID();
    private static final int MAX_STATUS_LENGTH = 10000;

    public SqlTaskRepository(@NotNull DSLContext jooq, @NotNull ObjectMapper mapper, @NotNull Clock clock, @NotNull String poolName) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        this.jooq = jooq;
        this.mapper = mapper;
        this.clock = clock;
        this.poolName = poolName;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.log.info("Using " + this.getClass().getSimpleName() + " with pool " + this.poolName);
    }

    @NotNull
    public Task create(@NotNull String phase, @NotNull String status) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String string = ulid.nextULID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ulid.nextULID()");
        return this.create(phase, status, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Task create(@NotNull String phase, @NotNull String status, @NotNull String clientRequestId) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)clientRequestId, (String)"clientRequestId");
        Ref.ObjectRef task = new Ref.ObjectRef();
        String string = ulid.nextULID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ulid.nextULID()");
        String string2 = ClouddriverHostname.ID;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ID");
        task.element = new SqlTask(string, string2, clientRequestId, this.clock.millis(), new LinkedHashSet(), this);
        String historyId = ulid.nextULID();
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, clientRequestId, (Ref.ObjectRef<SqlTask>)task, historyId, phase, status){
                final /* synthetic */ SqlTaskRepository this$0;
                final /* synthetic */ String $clientRequestId;
                final /* synthetic */ Ref.ObjectRef<SqlTask> $task;
                final /* synthetic */ String $historyId;
                final /* synthetic */ String $phase;
                final /* synthetic */ String $status;
                {
                    this.this$0 = $receiver;
                    this.$clientRequestId = $clientRequestId;
                    this.$task = $task;
                    this.$historyId = $historyId;
                    this.$phase = $phase;
                    this.$status = $status;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Task existingTask = this.this$0.getByClientRequestId(this.$clientRequestId);
                    if (existingTask != null) {
                        this.$task.element = (SqlTask)existingTask;
                        String string = this.$historyId;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"historyId");
                        SqlTaskRepository.access$addToHistory(this.this$0, ctx, string, ((SqlTask)existingTask).getId(), TaskState.FAILED, this.$phase, "Duplicate of " + this.$clientRequestId);
                    } else {
                        Object[] objectArray = new Pair[]{TuplesKt.to((Object)DSL.field((String)"id"), (Object)((SqlTask)this.$task.element).getId()), TuplesKt.to((Object)DSL.field((String)"owner_id"), (Object)((SqlTask)this.$task.element).getOwnerId$clouddriver_sql()), TuplesKt.to((Object)DSL.field((String)"request_id"), (Object)((SqlTask)this.$task.element).getRequestId$clouddriver_sql()), TuplesKt.to((Object)DSL.field((String)"created_at"), (Object)((SqlTask)this.$task.element).getStartTimeMs$clouddriver_sql()), TuplesKt.to((Object)DSL.field((String)"saga_ids"), (Object)SqlTaskRepository.access$getMapper$p(this.this$0).writeValueAsString(((SqlTask)this.$task.element).getSagaIds()))};
                        Map pairs = MapsKt.mapOf((Pair[])objectArray);
                        Collection<V> $this$toTypedArray$iv = (Collection<V>)pairs.keySet();
                        boolean $i$f$toTypedArray = false;
                        Collection<V> thisCollection$iv = $this$toTypedArray$iv;
                        Field[] fieldArray = thisCollection$iv.toArray(new Field[0]);
                        if (fieldArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        objectArray = fieldArray;
                        InsertValuesStepN insertValuesStepN = ctx.insertInto(SqlKt.getTasksTable(), (Field[])Arrays.copyOf(objectArray, objectArray.length));
                        $this$toTypedArray$iv = pairs.values();
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
                        if (objectArray2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        objectArray = objectArray2;
                        insertValuesStepN.values((Object[])Arrays.copyOf(objectArray, objectArray.length)).execute();
                        String string = this.$historyId;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"historyId");
                        SqlTaskRepository.access$addToHistory(this.this$0, ctx, string, ((SqlTask)this.$task.element).getId(), TaskState.STARTED, this.$phase, this.$status);
                    }
                }
            }));
            ((SqlTask)task.element).refresh$clouddriver_sql(true);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return (Task)task.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateSagaIds(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, task){
                final /* synthetic */ SqlTaskRepository this$0;
                final /* synthetic */ Task $task;
                {
                    this.this$0 = $receiver;
                    this.$task = $task;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    ctx.update(SqlKt.getTasksTable()).set(DSL.field((String)"saga_ids"), (Object)SqlTaskRepository.access$getMapper$p(this.this$0).writeValueAsString((Object)this.$task.getSagaIds())).where(DSL.field((String)"id").eq((Object)this.$task.getId())).execute();
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @Nullable
    public Task get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.retrieveInternal$clouddriver_sql(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Task getByClientRequestId(@NotNull String clientRequestId) {
        Task task;
        Intrinsics.checkNotNullParameter((Object)clientRequestId, (String)"clientRequestId");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            task = (Task)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, Task>(clientRequestId, this){
                final /* synthetic */ String $clientRequestId;
                final /* synthetic */ SqlTaskRepository this$0;
                {
                    this.$clientRequestId = $clientRequestId;
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Task invoke(@NotNull DSLContext it) {
                    Task task;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = (String)it.select((SelectField)DSL.field((String)"id")).from((TableLike)SqlKt.getTasksTable()).where(DSL.field((String)"request_id").eq((Object)this.$clientRequestId)).fetchOne("id", String.class);
                    if (string != null) {
                        String string2 = string;
                        SqlTaskRepository sqlTaskRepository = this.this$0;
                        String taskId = string2;
                        boolean bl = false;
                        task = sqlTaskRepository.retrieveInternal$clouddriver_sql(taskId);
                    } else {
                        task = null;
                    }
                    return task;
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Task> list() {
        List list2;
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            list2 = (List)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, List<Task>>(this){
                final /* synthetic */ SqlTaskRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final List<Task> invoke(@NotNull DSLContext it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String[] stringArray = SqlTaskRepository.access$runningTaskIds(this.this$0, it, false);
                    SqlTaskRepository sqlTaskRepository = this.this$0;
                    String[] taskIds = stringArray;
                    boolean bl = false;
                    Condition condition = DSL.field((String)"id").in((Object[])Arrays.copyOf(taskIds, taskIds.length));
                    Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"field(\"id\").`in`(*taskIds)");
                    return CollectionsKt.toMutableList((Collection)SqlTaskRepository.access$retrieveInternal(sqlTaskRepository, condition, DSL.field((String)"task_id").in((Object[])Arrays.copyOf(taskIds, taskIds.length))));
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Task> listByThisInstance() {
        List list2;
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            list2 = (List)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, List<Task>>(this){
                final /* synthetic */ SqlTaskRepository this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final List<Task> invoke(@NotNull DSLContext it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String[] stringArray = SqlTaskRepository.access$runningTaskIds(this.this$0, it, true);
                    SqlTaskRepository sqlTaskRepository = this.this$0;
                    String[] taskIds = stringArray;
                    boolean bl = false;
                    Condition condition = DSL.field((String)"id").in((Object[])Arrays.copyOf(taskIds, taskIds.length));
                    Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"field(\"id\").`in`(*taskIds)");
                    return CollectionsKt.toMutableList((Collection)SqlTaskRepository.access$retrieveInternal(sqlTaskRepository, condition, DSL.field((String)"task_id").in((Object[])Arrays.copyOf(taskIds, taskIds.length))));
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void addResultObjects$clouddriver_sql(@NotNull List<? extends Object> results, @NotNull Task task) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Iterable $this$map$iv = results;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)ulid.nextULID(), (Object)it));
        }
        Map resultIdPairs = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, task, (Map<String, ? extends Object>)resultIdPairs){
                final /* synthetic */ SqlTaskRepository this$0;
                final /* synthetic */ Task $task;
                final /* synthetic */ Map<String, Object> $resultIdPairs;
                {
                    this.this$0 = $receiver;
                    this.$task = $task;
                    this.$resultIdPairs = $resultIdPairs;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull DSLContext ctx) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    SelectLimitPercentStep selectLimitPercentStep = ctx.select((Collection)SqlKt.getTaskStatesFields()).from((TableLike)SqlKt.getTaskStatesTable()).where(DSL.field((String)"task_id").eq((Object)this.$task.getId())).orderBy((OrderField)DSL.field((String)"created_at").asc()).limit(1);
                    Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"ctx.select(taskStatesFie\u2026sc())\n          .limit(1)");
                    Object object = SqlTaskRepository.access$fetchTaskStatus(this.this$0, (Select)selectLimitPercentStep);
                    if (object != null) {
                        DefaultTaskStatus $this$invoke_u24lambda_u2d0 = object;
                        boolean bl = false;
                        $this$invoke_u24lambda_u2d0.ensureUpdateable();
                    }
                    object = this.$resultIdPairs;
                    Task task = this.$task;
                    SqlTaskRepository sqlTaskRepository = this.this$0;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> result = element$iv = iterator.next();
                        boolean bl = false;
                        Object[] objectArray = new Field[]{DSL.field((String)"id"), DSL.field((String)"task_id"), DSL.field((String)"body")};
                        InsertValuesStepN insertValuesStepN = ctx.insertInto(SqlKt.getTaskResultsTable(), (Collection)CollectionsKt.listOf((Object[])objectArray));
                        objectArray = new String[]{(String)result.getKey(), task.getId(), SqlTaskRepository.access$getMapper$p(sqlTaskRepository).writeValueAsString(result.getValue())};
                        insertValuesStepN.values((Collection)CollectionsKt.listOf((Object[])objectArray)).execute();
                    }
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateCurrentStatus$clouddriver_sql(@NotNull Task task, @NotNull String phase, @NotNull String status) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String historyId = ulid.nextULID();
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, task, historyId, phase, status){
                final /* synthetic */ SqlTaskRepository this$0;
                final /* synthetic */ Task $task;
                final /* synthetic */ String $historyId;
                final /* synthetic */ String $phase;
                final /* synthetic */ String $status;
                {
                    this.this$0 = $receiver;
                    this.$task = $task;
                    this.$historyId = $historyId;
                    this.$phase = $phase;
                    this.$status = $status;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    String string = this.$task.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.id");
                    DefaultTaskStatus state = SqlTaskRepository.access$selectLatestState(this.this$0, ctx, string);
                    String string2 = this.$historyId;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"historyId");
                    String string3 = this.$task.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"task.id");
                    DefaultTaskStatus defaultTaskStatus = state;
                    Object object = defaultTaskStatus != null ? defaultTaskStatus.getState() : null;
                    if (object == null) {
                        object = TaskState.STARTED;
                    }
                    SqlTaskRepository.access$addToHistory(this.this$0, ctx, string2, string3, object, this.$phase, StringsKt.take((String)this.$status, (int)SqlTaskRepository.access$getMAX_STATUS_LENGTH$cp()));
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    private final void addToHistory(DSLContext ctx, String id, String taskId, TaskState state, String phase, String status) {
        Object[] objectArray = new Field[]{DSL.field((String)"id"), DSL.field((String)"task_id"), DSL.field((String)"created_at"), DSL.field((String)"state"), DSL.field((String)"phase"), DSL.field((String)"status")};
        InsertValuesStepN insertValuesStepN = ctx.insertInto(SqlKt.getTaskStatesTable(), (Collection)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Object[]{id, taskId, this.clock.millis(), state.toString(), phase, status};
        insertValuesStepN.values((Collection)CollectionsKt.listOf((Object[])objectArray)).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateState$clouddriver_sql(@NotNull Task task, @NotNull TaskState state) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String historyId = ulid.nextULID();
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, task, historyId, state){
                final /* synthetic */ SqlTaskRepository this$0;
                final /* synthetic */ Task $task;
                final /* synthetic */ String $historyId;
                final /* synthetic */ TaskState $state;
                {
                    this.this$0 = $receiver;
                    this.$task = $task;
                    this.$historyId = $historyId;
                    this.$state = $state;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext ctx) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        String string = this.$task.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.id");
                        DefaultTaskStatus defaultTaskStatus = SqlTaskRepository.access$selectLatestState(this.this$0, ctx, string);
                        if (defaultTaskStatus == null) break block0;
                        DefaultTaskStatus defaultTaskStatus2 = defaultTaskStatus;
                        SqlTaskRepository sqlTaskRepository = this.this$0;
                        String string2 = this.$historyId;
                        Task task = this.$task;
                        TaskState taskState = this.$state;
                        DefaultTaskStatus it = defaultTaskStatus2;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"historyId");
                        String string3 = task.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"task.id");
                        String string4 = it.getPhase();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.phase");
                        String string5 = it.getStatus();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.status");
                        SqlTaskRepository.access$addToHistory(sqlTaskRepository, ctx, string2, string3, taskState, string4, string5);
                    }
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateOutput$clouddriver_sql(@NotNull TaskOutput taskOutput, @NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)taskOutput, (String)"taskOutput");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String outputId = ulid.nextULID();
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, outputId, task, taskOutput){
                final /* synthetic */ SqlTaskRepository this$0;
                final /* synthetic */ String $outputId;
                final /* synthetic */ Task $task;
                final /* synthetic */ TaskOutput $taskOutput;
                {
                    this.this$0 = $receiver;
                    this.$outputId = $outputId;
                    this.$task = $task;
                    this.$taskOutput = $taskOutput;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    String string = this.$outputId;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputId");
                    String string2 = this.$task.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.id");
                    String string3 = this.$taskOutput.getManifest();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"taskOutput.manifest");
                    String string4 = this.$taskOutput.getPhase();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"taskOutput.phase");
                    SqlTaskRepository.access$addToOutput(this.this$0, ctx, string, string2, string3, string4, this.$taskOutput.getStdOut(), this.$taskOutput.getStdError());
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    private final void addToOutput(DSLContext ctx, String id, String taskId, String manifestName, String phase, String stdOut, String stdError) {
        Object[] objectArray = new Field[]{DSL.field((String)"id"), DSL.field((String)"task_id"), DSL.field((String)"created_at"), DSL.field((String)"manifest"), DSL.field((String)"phase"), DSL.field((String)"std_out"), DSL.field((String)"std_error")};
        InsertValuesStepN insertValuesStepN = ctx.insertInto(SqlKt.getTaskOutputsTable(), (Collection)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Object[]{id, taskId, this.clock.millis(), manifestName, phase, stdOut, stdError};
        insertValuesStepN.values((Collection)CollectionsKt.listOf((Object[])objectArray)).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateOwnerId(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(task){
                final /* synthetic */ Task $task;
                {
                    this.$task = $task;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    ctx.update(SqlKt.getTasksTable()).set(DSL.field((String)"owner_id"), (Object)this.$task.getOwnerId()).where(DSL.field((String)"id").eq((Object)this.$task.getId())).execute();
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @Nullable
    public final Task retrieveInternal$clouddriver_sql(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Condition condition = DSL.field((String)"id").eq((Object)taskId);
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"field(\"id\").eq(taskId)");
        return (Task)CollectionsKt.firstOrNull((Iterable)this.retrieveInternal(condition, DSL.field((String)"task_id").eq((Object)taskId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<Task> retrieveInternal(Condition condition, Condition relationshipCondition) {
        Set tasks = new LinkedHashSet();
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>((Set<Task>)tasks, this, condition, relationshipCondition){
                final /* synthetic */ Set<Task> $tasks;
                final /* synthetic */ SqlTaskRepository this$0;
                final /* synthetic */ Condition $condition;
                final /* synthetic */ Condition $relationshipCondition;
                {
                    this.$tasks = $tasks;
                    this.this$0 = $receiver;
                    this.$condition = $condition;
                    this.$relationshipCondition = $relationshipCondition;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    SelectConditionStep selectConditionStep = ctx.select((SelectField)DSL.field((String)"id").as("task_id"), (SelectField)DSL.field((String)"owner_id"), (SelectField)DSL.field((String)"request_id"), (SelectField)DSL.field((String)"created_at"), (SelectField)DSL.field((String)"saga_ids"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("body"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("state"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("phase"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("status"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("manifest"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("std_out"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("std_error")).from((TableLike)SqlKt.getTasksTable()).where(this.$condition);
                    SelectJoinStep selectJoinStep = ctx.select((SelectField)DSL.field((String)"task_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("owner_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("request_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("created_at"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("saga_ids"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("body"), (SelectField)DSL.field((String)"state"), (SelectField)DSL.field((String)"phase"), (SelectField)DSL.field((String)"status"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("manifest"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("std_out"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("std_error")).from((TableLike)SqlKt.getTaskStatesTable());
                    Condition condition = this.$relationshipCondition;
                    if (condition == null) {
                        condition = this.$condition;
                    }
                    SelectOrderByStep selectOrderByStep = selectConditionStep.unionAll((Select)selectJoinStep.where(condition));
                    SelectJoinStep selectJoinStep2 = ctx.select((SelectField)DSL.field((String)"task_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("owner_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("request_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("created_at"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("saga_ids"), (SelectField)DSL.field((String)"body"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("state"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("phase"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("status"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("manifest"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("std_out"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("std_error")).from((TableLike)SqlKt.getTaskResultsTable());
                    Condition condition2 = this.$relationshipCondition;
                    if (condition2 == null) {
                        condition2 = this.$condition;
                    }
                    SelectOrderByStep selectOrderByStep2 = selectOrderByStep.unionAll((Select)selectJoinStep2.where(condition2));
                    SelectJoinStep selectJoinStep3 = ctx.select((SelectField)DSL.field((String)"task_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("owner_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("request_id"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("created_at"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("saga_ids"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("body"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("state"), (SelectField)DSL.field((String)"phase"), (SelectField)DSL.field((SQL)DSL.sql((String)"null")).as("status"), (SelectField)DSL.field((String)"manifest"), (SelectField)DSL.field((String)"std_out"), (SelectField)DSL.field((String)"std_error")).from((TableLike)SqlKt.getTaskOutputsTable());
                    Condition condition3 = this.$relationshipCondition;
                    if (condition3 == null) {
                        condition3 = this.$condition;
                    }
                    SelectOrderByStep selectOrderByStep3 = selectOrderByStep2.unionAll((Select)selectJoinStep3.where(condition3));
                    Intrinsics.checkNotNullExpressionValue((Object)selectOrderByStep3, (String)"ctx\n            .select(\u2026 condition)\n            )");
                    this.$tasks.addAll(SqlTaskRepository.access$fetchTasks(this.this$0, (Select)selectOrderByStep3));
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return tasks;
    }

    static /* synthetic */ Collection retrieveInternal$default(SqlTaskRepository sqlTaskRepository, Condition condition, Condition condition2, int n, Object object) {
        if ((n & 2) != 0) {
            condition2 = null;
        }
        return sqlTaskRepository.retrieveInternal(condition, condition2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DefaultTaskStatus selectLatestState(DSLContext ctx, String taskId) {
        DefaultTaskStatus defaultTaskStatus;
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectLimitPercentStep selectLimitPercentStep = ctx.select((Collection)SqlKt.getTaskStatesFields()).from((TableLike)SqlKt.getTaskStatesTable()).where(DSL.field((String)"task_id").eq((Object)taskId)).orderBy((OrderField)DSL.field((String)"created_at").desc()).limit(1);
            Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"ctx.select(taskStatesFie\u2026desc())\n        .limit(1)");
            defaultTaskStatus = this.fetchTaskStatus((Select<? extends Record>)((Select)selectLimitPercentStep));
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return defaultTaskStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String[] runningTaskIds(DSLContext ctx, boolean thisInstance) {
        String[] stringArray;
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            void $this$toTypedArray$iv;
            boolean bl = false;
            Object object = new GroupField[]{(GroupField)DSL.field((String)"task_id")};
            SelectOnConditionStep selectOnConditionStep = ctx.select((SelectField)DSL.field((String)"a.task_id")).from((TableLike)SqlKt.getTaskStatesTable().as("a")).innerJoin((TableLike)ctx.select((SelectField)DSL.field((String)"task_id"), (SelectField)DSL.max((Field)DSL.field((String)"created_at")).as("created")).from((TableLike)SqlKt.getTaskStatesTable()).groupBy(object).asTable("b")).on(DSL.sql((String)"a.task_id = b.task_id and a.created_at = b.created"));
            Intrinsics.checkNotNullExpressionValue((Object)selectOnConditionStep, (String)"ctx.select(field(\"a.task\u2026created_at = b.created\"))");
            SelectOnConditionStep baseQuery = selectOnConditionStep;
            SelectConditionStep selectConditionStep = thisInstance ? baseQuery.innerJoin((TableLike)SqlKt.getTasksTable().as("t")).on(DSL.sql((String)"a.task_id = t.id")).where(DSL.field((String)"t.owner_id").eq((Object)ClouddriverHostname.ID).and(DSL.field((String)"a.state").eq((Object)TaskState.STARTED.toString()))) : baseQuery.where(DSL.field((String)"a.state").eq((Object)TaskState.STARTED.toString()));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"if (thisInstance) {\n    \u2026RTED.toString()))\n      }");
            SelectConditionStep select = selectConditionStep;
            List list2 = select.fetch("a.task_id", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"select\n        .fetch(\"a\u2026_id\", String::class.java)");
            object = list2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            stringArray = stringArray2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return stringArray;
    }

    private final Collection<Task> fetchTasks(Select<? extends Record> $this$fetchTasks) {
        TaskMapper taskMapper = new TaskMapper(this, this.mapper);
        ResultSet resultSet = $this$fetchTasks.fetch().intoResultSet();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"fetch().intoResultSet()");
        return taskMapper.map(resultSet);
    }

    private final Collection<DefaultTaskStatus> fetchTaskStatuses(Select<? extends Record> $this$fetchTaskStatuses) {
        TaskStatusMapper taskStatusMapper = new TaskStatusMapper();
        ResultSet resultSet = $this$fetchTaskStatuses.fetch().intoResultSet();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"fetch().intoResultSet()");
        return taskStatusMapper.map(resultSet);
    }

    private final DefaultTaskStatus fetchTaskStatus(Select<? extends Record> $this$fetchTaskStatus) {
        return (DefaultTaskStatus)CollectionsKt.firstOrNull((Iterable)this.fetchTaskStatuses($this$fetchTaskStatus));
    }

    public static final /* synthetic */ void access$addToHistory(SqlTaskRepository $this, DSLContext ctx, String id, String taskId, TaskState state, String phase, String status) {
        $this.addToHistory(ctx, id, taskId, state, phase, status);
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(SqlTaskRepository $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ String[] access$runningTaskIds(SqlTaskRepository $this, DSLContext ctx, boolean thisInstance) {
        return $this.runningTaskIds(ctx, thisInstance);
    }

    public static final /* synthetic */ Collection access$retrieveInternal(SqlTaskRepository $this, Condition condition, Condition relationshipCondition) {
        return $this.retrieveInternal(condition, relationshipCondition);
    }

    public static final /* synthetic */ DefaultTaskStatus access$fetchTaskStatus(SqlTaskRepository $this, Select $receiver) {
        return $this.fetchTaskStatus((Select<? extends Record>)$receiver);
    }

    public static final /* synthetic */ DefaultTaskStatus access$selectLatestState(SqlTaskRepository $this, DSLContext ctx, String taskId) {
        return $this.selectLatestState(ctx, taskId);
    }

    public static final /* synthetic */ int access$getMAX_STATUS_LENGTH$cp() {
        return MAX_STATUS_LENGTH;
    }

    public static final /* synthetic */ void access$addToOutput(SqlTaskRepository $this, DSLContext ctx, String id, String taskId, String manifestName, String phase, String stdOut, String stdError) {
        $this.addToOutput(ctx, id, taskId, manifestName, phase, stdOut, stdError);
    }

    public static final /* synthetic */ Collection access$fetchTasks(SqlTaskRepository $this, Select $receiver) {
        return $this.fetchTasks((Select<? extends Record>)$receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskRepository$Companion;", "", "()V", "MAX_STATUS_LENGTH", "", "ulid", "Lde/huxhorn/sulky/ulid/ULID;", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

