/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql.event;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.event.Aggregate;
import com.netflix.spinnaker.clouddriver.event.CompositeSpinnakerEvent;
import com.netflix.spinnaker.clouddriver.event.EventMetadata;
import com.netflix.spinnaker.clouddriver.event.SpinnakerEvent;
import com.netflix.spinnaker.clouddriver.event.exceptions.AggregateChangeRejectedException;
import com.netflix.spinnaker.clouddriver.event.exceptions.DuplicateEventAggregateException;
import com.netflix.spinnaker.clouddriver.event.persistence.EventRepository;
import com.netflix.spinnaker.clouddriver.sql.SqlKt;
import com.netflix.spinnaker.clouddriver.sql.event.DslKt;
import com.netflix.spinnaker.clouddriver.sql.event.SqlAggregate;
import com.netflix.spinnaker.clouddriver.sql.event.SqlEventRepository;
import com.netflix.spinnaker.clouddriver.sql.event.SqlEventSystemException;
import com.netflix.spinnaker.config.ConnectionPools;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import com.netflix.spinnaker.kork.version.ServiceVersion;
import de.huxhorn.sulky.ulid.ULID;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertValuesStep8;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J.\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J5\u0010&\u001a\u0004\u0018\u00010$*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010$H\u0002\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u0004\u0018\u00010**\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0011\u001a\n \u000f*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/event/SqlEventRepository;", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository;", "jooq", "Lorg/jooq/DSLContext;", "serviceVersion", "Lcom/netflix/spinnaker/kork/version/ServiceVersion;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "registry", "Lcom/netflix/spectator/api/Registry;", "(Lorg/jooq/DSLContext;Lcom/netflix/spinnaker/kork/version/ServiceVersion;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/context/ApplicationEventPublisher;Lcom/netflix/spectator/api/Registry;)V", "eventCountId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "eventErrorCountId", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "list", "", "Lcom/netflix/spinnaker/clouddriver/event/SpinnakerEvent;", "aggregateType", "", "aggregateId", "listAggregates", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository$ListAggregatesResult;", "criteria", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository$ListAggregatesCriteria;", "save", "", "originatingVersion", "", "newEvents", "initialize", "currentSequence", "(Lcom/netflix/spinnaker/clouddriver/event/SpinnakerEvent;Ljava/lang/String;Ljava/lang/String;JLjava/lang/Long;)Ljava/lang/Long;", "maybeGetAggregate", "Lcom/netflix/spinnaker/clouddriver/event/Aggregate;", "aggregateCondition", "Lorg/jooq/Condition;", "Companion", "clouddriver-sql"})
public final class SqlEventRepository
implements EventRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DSLContext jooq;
    @NotNull
    private final ServiceVersion serviceVersion;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final Registry registry;
    @NotNull
    private final Lazy log$delegate;
    private final Id eventCountId;
    private final Id eventErrorCountId;
    @NotNull
    private static final String POOL_NAME = ConnectionPools.EVENTS.getValue();
    @NotNull
    private static final Table<Record> AGGREGATES_TABLE;
    @NotNull
    private static final Table<Record> EVENTS_TABLE;
    @NotNull
    private static final ULID ulid;

    public SqlEventRepository(@NotNull DSLContext jooq, @NotNull ServiceVersion serviceVersion, @NotNull ObjectMapper objectMapper, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)serviceVersion, (String)"serviceVersion");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.jooq = jooq;
        this.serviceVersion = serviceVersion;
        this.objectMapper = objectMapper;
        this.applicationEventPublisher = applicationEventPublisher;
        this.registry = registry;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SqlEventRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        this.eventCountId = this.registry.createId("eventing.events");
        this.eventErrorCountId = this.registry.createId("eventing.errors");
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull String aggregateType, @NotNull String aggregateId, long originatingVersion, @NotNull List<? extends SpinnakerEvent> newEvents) {
        Intrinsics.checkNotNullParameter((Object)aggregateType, (String)"aggregateType");
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter(newEvents, (String)"newEvents");
        String eventNames2 = CollectionsKt.joinToString$default((Iterable)newEvents, null, null, null, (int)0, null, (Function1)save.eventNames.1.INSTANCE, (int)31, null);
        this.getLog().debug("Saving " + aggregateType + "/" + aggregateId + " expecting version " + originatingVersion + " with [" + eventNames2 + "]");
        Condition condition = DSL.field((String)"aggregate_type").eq((Object)aggregateType).and(DSL.field((String)"aggregate_id").eq((Object)aggregateId));
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"field(\"aggregate_type\").\u2026ate_id\").eq(aggregateId))");
        Condition aggregateCondition = condition;
        try {
            String name$iv = POOL_NAME;
            boolean $i$f$withPool = false;
            NamedDatabaseContextHolder.INSTANCE.set(name$iv);
            try {
                boolean bl = false;
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, aggregateCondition, originatingVersion, aggregateType, aggregateId, newEvents){
                    final /* synthetic */ SqlEventRepository this$0;
                    final /* synthetic */ Condition $aggregateCondition;
                    final /* synthetic */ long $originatingVersion;
                    final /* synthetic */ String $aggregateType;
                    final /* synthetic */ String $aggregateId;
                    final /* synthetic */ List<SpinnakerEvent> $newEvents;
                    {
                        this.this$0 = $receiver;
                        this.$aggregateCondition = $aggregateCondition;
                        this.$originatingVersion = $originatingVersion;
                        this.$aggregateType = $aggregateType;
                        this.$aggregateId = $aggregateId;
                        this.$newEvents = $newEvents;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Aggregate aggregate;
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        Aggregate aggregate2 = SqlEventRepository.access$maybeGetAggregate(this.this$0, ctx, this.$aggregateCondition);
                        if (aggregate2 == null) {
                            aggregate2 = save.1.1.invoke$lambda-0(this.$originatingVersion, this.$aggregateType, this.$aggregateId, ctx);
                        }
                        if ((aggregate = aggregate2).getVersion() != this.$originatingVersion) {
                            throw new AggregateChangeRejectedException(aggregate.getVersion(), this.$originatingVersion);
                        }
                        Long lastSequence = (Long)ctx.select((SelectField)DSL.max((Field)DSL.field((String)"sequence"))).from((TableLike)SqlEventRepository.access$getEVENTS_TABLE$cp()).where(this.$aggregateCondition).limit(1).fetchOne(0, Long.TYPE);
                        SqlEventRepository.access$getLog(this.this$0).debug("Last event sequence number is " + lastSequence);
                        Long nextSequence = null;
                        nextSequence = lastSequence;
                        InsertValuesStep8 insertValuesStep8 = ctx.insertInto(SqlEventRepository.access$getEVENTS_TABLE$cp()).columns(DSL.field((String)"id"), DSL.field((String)"aggregate_type"), DSL.field((String)"aggregate_id"), DSL.field((String)"sequence"), DSL.field((String)"originating_version"), DSL.field((String)"timestamp"), DSL.field((String)"metadata"), DSL.field((String)"data"));
                        List<SpinnakerEvent> list2 = this.$newEvents;
                        SqlEventRepository sqlEventRepository = this.this$0;
                        String string = this.$aggregateType;
                        String string2 = this.$aggregateId;
                        long l = this.$originatingVersion;
                        InsertValuesStep8 insertValuesStep = insertValuesStep8;
                        boolean bl = false;
                        InsertValuesStep8 step = null;
                        Intrinsics.checkNotNullExpressionValue((Object)insertValuesStep, (String)"insertValuesStep");
                        step = insertValuesStep;
                        Iterable $this$forEach$iv = list2;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            SpinnakerEvent it = (SpinnakerEvent)element$iv;
                            boolean bl2 = false;
                            nextSequence = SqlEventRepository.access$initialize(sqlEventRepository, it, string, string2, l, nextSequence);
                            Intrinsics.checkNotNullExpressionValue((Object)step.values(DslKt.toSqlValues(it, SqlEventRepository.access$getObjectMapper$p(sqlEventRepository))), (String)"step.values(it.toSqlValues(objectMapper))");
                        }
                        step.execute();
                        ctx.update(SqlEventRepository.access$getAGGREGATES_TABLE$cp()).set(DSL.field((String)"version"), (Object)DSL.field((String)"version", Long.TYPE).add((Number)1)).set(DSL.field((String)"last_change_timestamp"), (Object)DSL.currentTimestamp()).where(this.$aggregateCondition).execute();
                        SqlEventRepository.access$getLog(this.this$0).debug("Event sequence number is now " + nextSequence);
                    }

                    private static final Aggregate invoke$lambda-0(long $originatingVersion, String $aggregateType, String $aggregateId, DSLContext $ctx) {
                        if ($originatingVersion != 0L) {
                            throw new AggregateChangeRejectedException(-1L, $originatingVersion);
                        }
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)DSL.field((String)"aggregate_type"), (Object)$aggregateType), TuplesKt.to((Object)DSL.field((String)"aggregate_id"), (Object)$aggregateId), TuplesKt.to((Object)DSL.field((String)"token"), (Object)SqlEventRepository.access$getUlid$cp().nextULID()), TuplesKt.to((Object)DSL.field((String)"version"), (Object)0)};
                        Map initialAggregate = MapsKt.mapOf((Pair[])pairArray);
                        try {
                            $ctx.insertInto(SqlEventRepository.access$getAGGREGATES_TABLE$cp()).columns((Collection)initialAggregate.keySet()).values(initialAggregate.values()).execute();
                        }
                        catch (SQLIntegrityConstraintViolationException e) {
                            throw new DuplicateEventAggregateException((Exception)e);
                        }
                        return new Aggregate($aggregateType, $aggregateId, 0L);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                NamedDatabaseContextHolder.INSTANCE.clear();
            }
        }
        catch (AggregateChangeRejectedException e) {
            this.registry.counter(this.eventErrorCountId.withTags("aggregateType", aggregateType, "exception", ((Object)((Object)e)).getClass().getSimpleName())).increment();
            throw e;
        }
        catch (Exception e) {
            this.registry.counter(this.eventErrorCountId.withTags("aggregateType", aggregateType, "exception", e.getClass().getSimpleName())).increment();
            throw new SqlEventSystemException("Failed saving new events", e);
        }
        this.getLog().debug("Saved " + aggregateType + "/" + aggregateId + ": [" + CollectionsKt.joinToString$default((Iterable)newEvents, null, null, null, (int)0, null, (Function1)save.2.INSTANCE, (int)31, null) + "]");
        this.registry.counter(this.eventCountId.withTags("aggregateType", aggregateType)).increment((long)newEvents.size());
        Iterable $this$forEach$iv = newEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpinnakerEvent it = (SpinnakerEvent)element$iv;
            boolean bl = false;
            this.applicationEventPublisher.publishEvent((Object)it);
        }
    }

    private final Long initialize(SpinnakerEvent $this$initialize, String aggregateType, String aggregateId, long originatingVersion, Long currentSequence) {
        Long nextSequence = null;
        nextSequence = currentSequence != null ? Long.valueOf(currentSequence + 1L) : (Long)null;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        Long l = nextSequence;
        long l2 = l != null ? l : -1L;
        String string2 = this.serviceVersion.resolve();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serviceVersion.resolve()");
        $this$initialize.setMetadata(new EventMetadata(string, aggregateType, aggregateId, l2, originatingVersion, null, string2, null, 160, null));
        if ($this$initialize instanceof CompositeSpinnakerEvent) {
            Iterable $this$forEach$iv = ((CompositeSpinnakerEvent)$this$initialize).getComposedEvents();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SpinnakerEvent event = (SpinnakerEvent)element$iv;
                boolean bl = false;
                Long l3 = this.initialize(event, aggregateType, aggregateId, originatingVersion, null);
                if (l3 != null) {
                    long it = ((Number)l3).longValue();
                    boolean bl2 = false;
                    nextSequence = it;
                }
            }
        }
        return nextSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<SpinnakerEvent> list(@NotNull String aggregateType, @NotNull String aggregateId) {
        List<SpinnakerEvent> list2;
        Intrinsics.checkNotNullParameter((Object)aggregateType, (String)"aggregateType");
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        String name$iv = POOL_NAME;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectSeekStep1 selectSeekStep1 = this.jooq.select(new SelectFieldOrAsterisk[0]).from((TableLike)EVENTS_TABLE).where(DSL.field((String)"aggregate_type").eq((Object)aggregateType).and(DSL.field((String)"aggregate_id").eq((Object)aggregateId))).orderBy((OrderField)DSL.field((String)"sequence").asc());
            Intrinsics.checkNotNullExpressionValue((Object)selectSeekStep1, (String)"jooq.select().from(EVENT\u2026(field(\"sequence\").asc())");
            list2 = DslKt.fetchEvents((Select<? extends Record>)((Select)selectSeekStep1), this.objectMapper);
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public EventRepository.ListAggregatesResult listAggregates(@NotNull EventRepository.ListAggregatesCriteria criteria) {
        EventRepository.ListAggregatesResult listAggregatesResult;
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        String name$iv = POOL_NAME;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            String string;
            void $this$mapTo$iv$iv;
            String it;
            boolean bl = false;
            List conditions = new ArrayList();
            String string2 = criteria.getAggregateType();
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                Condition condition = DSL.field((String)"aggregate_type").eq((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"field(\"aggregate_type\").eq(it)");
                conditions.add(condition);
            }
            String string3 = criteria.getToken();
            if (string3 != null) {
                it = string3;
                boolean bl3 = false;
                Condition condition = DSL.field((String)"token").greaterThan((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"field(\"token\").greaterThan(it)");
                conditions.add(condition);
            }
            int perPage = RangesKt.coerceAtMost((int)criteria.getPerPage(), (int)10000);
            SelectJoinStep selectJoinStep = this.jooq.select(new SelectFieldOrAsterisk[0]).from((TableLike)AGGREGATES_TABLE);
            Intrinsics.checkNotNullExpressionValue((Object)selectJoinStep, (String)"jooq.select().from(AGGREGATES_TABLE)");
            it = DslKt.withConditions(selectJoinStep, conditions).orderBy((OrderField)DSL.field((String)"token").asc()).limit(perPage);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"jooq.select().from(AGGRE\u2026)\n        .limit(perPage)");
            List<SqlAggregate> aggregates = DslKt.fetchAggregates((Select<? extends Record>)((Select)it));
            SelectJoinStep selectJoinStep2 = this.jooq.selectCount().from((TableLike)AGGREGATES_TABLE);
            Intrinsics.checkNotNullExpressionValue((Object)selectJoinStep2, (String)"jooq.selectCount().from(AGGREGATES_TABLE)");
            int remaining = ((Number)((Record1)DslKt.withConditions(selectJoinStep2, conditions).fetchSingle()).value1()).intValue() - perPage;
            Iterable $this$map$iv = aggregates;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                SqlAggregate sqlAggregate = (SqlAggregate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it2.getModel());
            }
            List list2 = (List)destination$iv$iv;
            if (remaining > 0) {
                SqlAggregate sqlAggregate = (SqlAggregate)CollectionsKt.lastOrNull(aggregates);
                string = sqlAggregate != null ? sqlAggregate.getToken() : null;
            } else {
                string = null;
            }
            String string4 = string;
            List list3 = list2;
            listAggregatesResult = new EventRepository.ListAggregatesResult(list3, string4);
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return listAggregatesResult;
    }

    private final Aggregate maybeGetAggregate(DSLContext $this$maybeGetAggregate, Condition aggregateCondition) {
        SelectLimitPercentStep selectLimitPercentStep = $this$maybeGetAggregate.select(new SelectFieldOrAsterisk[0]).from((TableLike)AGGREGATES_TABLE).where(aggregateCondition).limit(1);
        Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"select()\n      .from(AGG\u2026ondition)\n      .limit(1)");
        SqlAggregate sqlAggregate = (SqlAggregate)CollectionsKt.firstOrNull(DslKt.fetchAggregates((Select<? extends Record>)((Select)selectLimitPercentStep)));
        return sqlAggregate != null ? sqlAggregate.getModel() : null;
    }

    public static final /* synthetic */ Aggregate access$maybeGetAggregate(SqlEventRepository $this, DSLContext $receiver, Condition aggregateCondition) {
        return $this.maybeGetAggregate($receiver, aggregateCondition);
    }

    public static final /* synthetic */ Table access$getEVENTS_TABLE$cp() {
        return EVENTS_TABLE;
    }

    public static final /* synthetic */ Logger access$getLog(SqlEventRepository $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ Table access$getAGGREGATES_TABLE$cp() {
        return AGGREGATES_TABLE;
    }

    public static final /* synthetic */ ULID access$getUlid$cp() {
        return ulid;
    }

    public static final /* synthetic */ Long access$initialize(SqlEventRepository $this, SpinnakerEvent $receiver, String aggregateType, String aggregateId, long originatingVersion, Long currentSequence) {
        return $this.initialize($receiver, aggregateType, aggregateId, originatingVersion, currentSequence);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(SqlEventRepository $this) {
        return $this.objectMapper;
    }

    static {
        Table table = DSL.table((String)"event_aggregates");
        Intrinsics.checkNotNullExpressionValue((Object)table, (String)"table(\"event_aggregates\")");
        AGGREGATES_TABLE = table;
        Table table2 = DSL.table((String)"events");
        Intrinsics.checkNotNullExpressionValue((Object)table2, (String)"table(\"events\")");
        EVENTS_TABLE = table2;
        ulid = new ULID();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/event/SqlEventRepository$Companion;", "", "()V", "AGGREGATES_TABLE", "Lorg/jooq/Table;", "Lorg/jooq/Record;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "EVENTS_TABLE", "POOL_NAME", "", "ulid", "Lde/huxhorn/sulky/ulid/ULID;", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

