/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.RunnableAgent;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.CoreProvider;
import com.netflix.spinnaker.clouddriver.data.task.TaskState;
import com.netflix.spinnaker.clouddriver.sql.CleanupCandidateIds;
import com.netflix.spinnaker.clouddriver.sql.SqlKt;
import com.netflix.spinnaker.clouddriver.sql.SqlTaskCleanupAgent;
import com.netflix.spinnaker.config.ConnectionPools;
import com.netflix.spinnaker.config.SqlTaskCleanupAgentProperties;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskCleanupAgent;", "Lcom/netflix/spinnaker/cats/agent/RunnableAgent;", "Lcom/netflix/spinnaker/clouddriver/cache/CustomScheduledAgent;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "registry", "Lcom/netflix/spectator/api/Registry;", "properties", "Lcom/netflix/spinnaker/config/SqlTaskCleanupAgentProperties;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/config/SqlTaskCleanupAgentProperties;)V", "deletedId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "timingId", "getAgentType", "", "getPollIntervalMillis", "", "getProviderName", "getTimeoutMillis", "run", "", "Companion", "clouddriver-sql"})
public final class SqlTaskCleanupAgent
implements RunnableAgent,
CustomScheduledAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DSLContext jooq;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Registry registry;
    @NotNull
    private final SqlTaskCleanupAgentProperties properties;
    private final Logger log;
    private final Id deletedId;
    private final Id timingId;
    private static final long DEFAULT_POLL_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(3L);
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(3L);

    public SqlTaskCleanupAgent(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull Registry registry, @NotNull SqlTaskCleanupAgentProperties properties) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.jooq = jooq;
        this.clock = clock;
        this.registry = registry;
        this.properties = properties;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.deletedId = this.registry.createId("sql.taskCleanupAgent.deleted");
        this.timingId = this.registry.createId("sql.taskCleanupAgent.timing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String name$iv = ConnectionPools.TASKS.getValue();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            CleanupCandidateIds candidates2 = (CleanupCandidateIds)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, CleanupCandidateIds>(this){
                final /* synthetic */ SqlTaskCleanupAgent this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CleanupCandidateIds invoke(@NotNull DSLContext j) {
                    Intrinsics.checkNotNullParameter((Object)j, (String)"j");
                    Object[] objectArray = new Object[]{TaskState.COMPLETED.toString(), TaskState.FAILED.toString()};
                    Result result = j.select((SelectField)DSL.field((String)"id"), (SelectField)DSL.field((String)"task_id")).from((TableLike)SqlKt.getTaskStatesTable()).where(DSL.field((String)"state").in(objectArray).and(DSL.field((String)"created_at").lessOrEqual((Object)SqlTaskCleanupAgent.access$getClock$p(this.this$0).instant().minusMillis(SqlTaskCleanupAgent.access$getProperties$p(this.this$0).getCompletedTtlMs()).toEpochMilli()))).fetch();
                    Intrinsics.checkNotNullExpressionValue((Object)result, (String)"j.select(field(\"id\"), fi\u2026     )\n          .fetch()");
                    Result candidates2 = result;
                    List list2 = candidates2.map(run.1.candidates.1::invoke$lambda-0);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"candidates.map { r -> r.\u2026getValue(r)?.toString() }");
                    List candidateTaskIds = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)list2));
                    List candidateTaskStateIds = new ArrayList<E>();
                    List candidateResultIds = new ArrayList<E>();
                    List candidateOutputIds = new ArrayList<E>();
                    if (!((Collection)candidateTaskIds).isEmpty()) {
                        CollectionsKt.chunked((Iterable)candidateTaskIds, (int)SqlTaskCleanupAgent.access$getProperties$p(this.this$0).getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Boolean>((List<String>)candidateTaskStateIds, j, (List<String>)candidateResultIds, (List<String>)candidateOutputIds){
                            final /* synthetic */ List<String> $candidateTaskStateIds;
                            final /* synthetic */ DSLContext $j;
                            final /* synthetic */ List<String> $candidateResultIds;
                            final /* synthetic */ List<String> $candidateOutputIds;
                            {
                                this.$candidateTaskStateIds = $candidateTaskStateIds;
                                this.$j = $j;
                                this.$candidateResultIds = $candidateResultIds;
                                this.$candidateOutputIds = $candidateOutputIds;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull List<String> chunk) {
                                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                                Collection $this$toTypedArray$iv = chunk;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                if (stringArray == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                }
                                String[] stringArray2 = stringArray;
                                List list2 = this.$j.select((SelectField)DSL.field((String)"id")).from((TableLike)SqlKt.getTaskStatesTable()).where(DSL.field((String)"task_id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).fetch("id", String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"j.select(field(\"id\"))\n  \u2026\"id\", String::class.java)");
                                this.$candidateTaskStateIds.addAll(CollectionsKt.filterNotNull((Iterable)list2));
                                $this$toTypedArray$iv = chunk;
                                $i$f$toTypedArray = false;
                                thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
                                if (stringArray3 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                }
                                stringArray2 = stringArray3;
                                List list3 = this.$j.select((SelectField)DSL.field((String)"id")).from((TableLike)SqlKt.getTaskResultsTable()).where(DSL.field((String)"task_id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).fetch("id", String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"j.select(field(\"id\"))\n  \u2026\"id\", String::class.java)");
                                this.$candidateResultIds.addAll(CollectionsKt.filterNotNull((Iterable)list3));
                                $this$toTypedArray$iv = chunk;
                                $i$f$toTypedArray = false;
                                thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray4 = thisCollection$iv.toArray(new String[0]);
                                if (stringArray4 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                }
                                stringArray2 = stringArray4;
                                List list4 = this.$j.select((SelectField)DSL.field((String)"id")).from((TableLike)SqlKt.getTaskOutputsTable()).where(DSL.field((String)"task_id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).fetch("id", String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"j.select(field(\"id\"))\n  \u2026\"id\", String::class.java)");
                                return this.$candidateOutputIds.addAll(CollectionsKt.filterNotNull((Iterable)list4));
                            }
                        }));
                    }
                    return new CleanupCandidateIds(candidateTaskIds, candidateTaskStateIds, candidateResultIds, candidateOutputIds);
                }

                private static final String invoke$lambda-0(Record2 r) {
                    Object object = r.field("task_id");
                    return object != null && (object = object.getValue((Record)r)) != null ? object.toString() : null;
                }
            });
            if (candidates2.hasAny()) {
                Object[] objectArray = new Object[]{candidates2.getTaskIds().size(), candidates2.getStateIds().size(), candidates2.getResultIds().size(), candidates2.getOutputIds().size()};
                this.log.info("Cleaning up {} completed tasks ({} states, {} results, {} output objects)", objectArray);
                this.registry.timer(this.timingId).record(() -> SqlTaskCleanupAgent.run$lambda-1$lambda-0(candidates2, this));
                this.registry.counter(this.deletedId).increment((long)candidates2.getTaskIds().size());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @NotNull
    public String getAgentType() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @NotNull
    public String getProviderName() {
        String string = CoreProvider.PROVIDER_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PROVIDER_NAME");
        return string;
    }

    public long getPollIntervalMillis() {
        return DEFAULT_POLL_INTERVAL_MILLIS;
    }

    public long getTimeoutMillis() {
        return DEFAULT_TIMEOUT_MILLIS;
    }

    private static final void run$lambda-1$lambda-0(CleanupCandidateIds $candidates, SqlTaskCleanupAgent this$0) {
        Intrinsics.checkNotNullParameter((Object)$candidates, (String)"$candidates");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CollectionsKt.chunked((Iterable)$candidates.getResultIds(), (int)this$0.properties.getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this$0){
            final /* synthetic */ SqlTaskCleanupAgent this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<String> chunk) {
                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                SqlKt.transactional(SqlTaskCleanupAgent.access$getJooq$p(this.this$0), (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(chunk){
                    final /* synthetic */ List<String> $chunk;
                    {
                        this.$chunk = $chunk;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        Collection $this$toTypedArray$iv = this.$chunk;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] stringArray2 = stringArray;
                        ctx.deleteFrom(SqlKt.getTaskResultsTable()).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).execute();
                    }
                }));
            }
        }));
        CollectionsKt.chunked((Iterable)$candidates.getStateIds(), (int)this$0.properties.getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this$0){
            final /* synthetic */ SqlTaskCleanupAgent this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<String> chunk) {
                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                SqlKt.transactional(SqlTaskCleanupAgent.access$getJooq$p(this.this$0), (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(chunk){
                    final /* synthetic */ List<String> $chunk;
                    {
                        this.$chunk = $chunk;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        Collection $this$toTypedArray$iv = this.$chunk;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] stringArray2 = stringArray;
                        ctx.deleteFrom(SqlKt.getTaskStatesTable()).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).execute();
                    }
                }));
            }
        }));
        CollectionsKt.chunked((Iterable)$candidates.getOutputIds(), (int)this$0.properties.getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this$0){
            final /* synthetic */ SqlTaskCleanupAgent this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<String> chunk) {
                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                SqlKt.transactional(SqlTaskCleanupAgent.access$getJooq$p(this.this$0), (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(chunk){
                    final /* synthetic */ List<String> $chunk;
                    {
                        this.$chunk = $chunk;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        Collection $this$toTypedArray$iv = this.$chunk;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] stringArray2 = stringArray;
                        ctx.deleteFrom(SqlKt.getTaskOutputsTable()).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).execute();
                    }
                }));
            }
        }));
        CollectionsKt.chunked((Iterable)$candidates.getTaskIds(), (int)this$0.properties.getBatchSize(), (Function1)((Function1)new Function1<List<? extends String>, Unit>(this$0){
            final /* synthetic */ SqlTaskCleanupAgent this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<String> chunk) {
                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                SqlKt.transactional(SqlTaskCleanupAgent.access$getJooq$p(this.this$0), (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(chunk){
                    final /* synthetic */ List<String> $chunk;
                    {
                        this.$chunk = $chunk;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        Collection $this$toTypedArray$iv = this.$chunk;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] stringArray2 = stringArray;
                        ctx.deleteFrom(SqlKt.getTasksTable()).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).execute();
                    }
                }));
            }
        }));
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlTaskCleanupAgent $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ Clock access$getClock$p(SqlTaskCleanupAgent $this) {
        return $this.clock;
    }

    public static final /* synthetic */ SqlTaskCleanupAgentProperties access$getProperties$p(SqlTaskCleanupAgent $this) {
        return $this.properties;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskCleanupAgent$Companion;", "", "()V", "DEFAULT_POLL_INTERVAL_MILLIS", "", "DEFAULT_TIMEOUT_MILLIS", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

