/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.data.task.DefaultTaskStatus;
import com.netflix.spinnaker.clouddriver.data.task.SagaId;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskDisplayOutput;
import com.netflix.spinnaker.clouddriver.data.task.TaskState;
import com.netflix.spinnaker.clouddriver.sql.SqlTask;
import com.netflix.spinnaker.clouddriver.sql.SqlTaskRepository;
import com.netflix.spinnaker.clouddriver.sql.TaskMapper;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/TaskMapper;", "", "sqlTaskRepository", "Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskRepository;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskRepository;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "map", "", "Lcom/netflix/spinnaker/clouddriver/data/task/Task;", "rs", "Ljava/sql/ResultSet;", "sagaIds", "", "Lcom/netflix/spinnaker/clouddriver/data/task/SagaId;", "sagaIdsValue", "", "Companion", "clouddriver-sql"})
public final class TaskMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SqlTaskRepository sqlTaskRepository;
    @NotNull
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(TaskMapper.class);
    @NotNull
    private static final Companion.SAGA_IDS_TYPE.1 SAGA_IDS_TYPE = new TypeReference<Set<SagaId>>(){};

    public TaskMapper(@NotNull SqlTaskRepository sqlTaskRepository, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)sqlTaskRepository, (String)"sqlTaskRepository");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.sqlTaskRepository = sqlTaskRepository;
        this.mapper = mapper;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Task> map(@NotNull ResultSet rs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Map tasks = new LinkedHashMap();
        Map results = new LinkedHashMap();
        Map history = new LinkedHashMap();
        Map taskOutputs = new LinkedHashMap();
        while (rs.next()) {
            Map e2;
            String id;
            SqlTask it;
            if (rs.getString("owner_id") != null) {
                String string = rs.getString("task_id");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rs.getString(\"task_id\")");
                String string2 = rs.getString("owner_id");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(\"owner_id\")");
                String string3 = rs.getString("request_id");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"rs.getString(\"request_id\")");
                it = new SqlTask(string, string2, string3, rs.getLong("created_at"), this.sagaIds(rs.getString("saga_ids")), this.sqlTaskRepository);
                boolean bl = false;
                tasks.put(it.getId(), it);
                continue;
            }
            if (rs.getString("body") != null) {
                try {
                    if (!results.containsKey(rs.getString("task_id"))) {
                        Map map = results;
                        Intrinsics.checkNotNullExpressionValue((Object)rs.getString("task_id"), (String)"rs.getString(\"task_id\")");
                        List bl = new ArrayList();
                        map.put(it, bl);
                    }
                    Object v = results.get(rs.getString("task_id"));
                    Intrinsics.checkNotNull(v);
                    List list2 = (List)v;
                    Object object = this.mapper.readValue(rs.getString("body"), Map.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(rs.getS\u2026\"body\"), Map::class.java)");
                    list2.add(object);
                    continue;
                }
                catch (IOException e2) {
                    id = rs.getString("id");
                    String taskId = rs.getString("task_id");
                    Object[] objectArray = new Object[]{id, taskId};
                    throw new RuntimeException(String.format("Failed to convert result object body to map (id: %s, taskId: %s)", objectArray), e2);
                }
            }
            if (rs.getString("state") != null) {
                if (!history.containsKey(rs.getString("task_id"))) {
                    e2 = history;
                    Intrinsics.checkNotNullExpressionValue((Object)rs.getString("task_id"), (String)"rs.getString(\"task_id\")");
                    List taskId = new ArrayList();
                    e2.put(id, taskId);
                }
                Object v = history.get(rs.getString("task_id"));
                Intrinsics.checkNotNull(v);
                List list3 = (List)v;
                String string = rs.getString("phase");
                String string4 = rs.getString("status");
                String string5 = rs.getString("state");
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"rs.getString(\"state\")");
                e2 = DefaultTaskStatus.create((String)string, (String)string4, (TaskState)TaskState.valueOf((String)string5));
                Intrinsics.checkNotNullExpressionValue((Object)e2, (String)"create(\n              rs\u2026g(\"state\"))\n            )");
                list3.add(e2);
                continue;
            }
            if (rs.getString("manifest") == null) continue;
            if (!taskOutputs.containsKey(rs.getString("task_id"))) {
                e2 = taskOutputs;
                Intrinsics.checkNotNullExpressionValue((Object)rs.getString("task_id"), (String)"rs.getString(\"task_id\")");
                List taskId = new ArrayList();
                e2.put(id, taskId);
            }
            Object v = taskOutputs.get(rs.getString("task_id"));
            Intrinsics.checkNotNull(v);
            ((List)v).add(new TaskDisplayOutput(rs.getString("manifest"), rs.getString("phase"), rs.getString("std_out"), rs.getString("std_error")));
        }
        Iterable $this$map$iv = tasks.values();
        boolean $i$f$map = false;
        Iterable taskId = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void task;
            SqlTask sqlTask = (SqlTask)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            task.hydrateResultObjects$clouddriver_sql(results.getOrDefault(task.getId(), (List)new ArrayList()));
            task.hydrateHistory$clouddriver_sql(history.getOrDefault(task.getId(), (List)new ArrayList()));
            task.hydrateTaskOutputs$clouddriver_sql(taskOutputs.getOrDefault(task.getId(), (List)new ArrayList()));
            collection.add(task);
        }
        return (List)destination$iv$iv;
    }

    private final Set<SagaId> sagaIds(String sagaIdsValue) {
        if (sagaIdsValue == null) {
            return new LinkedHashSet();
        }
        Object object = this.mapper.readValue(sagaIdsValue, (TypeReference)SAGA_IDS_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(sagaIdsValue, SAGA_IDS_TYPE)");
        return (Set)object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/TaskMapper$Companion;", "", "()V", "SAGA_IDS_TYPE", "com/netflix/spinnaker/clouddriver/sql/TaskMapper$Companion$SAGA_IDS_TYPE$1", "Lcom/netflix/spinnaker/clouddriver/sql/TaskMapper$Companion$SAGA_IDS_TYPE$1;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

