/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/TaskResultObjectMapper;", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "map", "", "rs", "Ljava/sql/ResultSet;", "clouddriver-sql"})
public final class TaskResultObjectMapper {
    @NotNull
    private final ObjectMapper mapper;

    public TaskResultObjectMapper(@NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }

    @NotNull
    public final Collection<Object> map(@NotNull ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        List results = new ArrayList();
        while (rs.next()) {
            try {
                Object object = this.mapper.readValue(rs.getString("body"), Map.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(rs.getS\u2026\"body\"), Map::class.java)");
                results.add(object);
            }
            catch (IOException e) {
                String id = rs.getString("id");
                String taskId = rs.getString("task_id");
                Object[] objectArray = new Object[]{id, taskId};
                throw new RuntimeException(String.format("Failed to convert result object body to map (id: %s, taskId: %s)", objectArray), e);
            }
        }
        return results;
    }
}

