/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql.event;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.RunnableAgent;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.CoreProvider;
import com.netflix.spinnaker.clouddriver.sql.SqlAgent;
import com.netflix.spinnaker.config.ConnectionPools;
import com.netflix.spinnaker.config.SqlEventCleanupAgentConfigProperties;
import com.netflix.spinnaker.kork.annotations.VisibleForTesting;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/event/SqlEventCleanupAgent;", "Lcom/netflix/spinnaker/cats/agent/RunnableAgent;", "Lcom/netflix/spinnaker/clouddriver/cache/CustomScheduledAgent;", "Lcom/netflix/spinnaker/clouddriver/sql/SqlAgent;", "jooq", "Lorg/jooq/DSLContext;", "registry", "Lcom/netflix/spectator/api/Registry;", "properties", "Lcom/netflix/spinnaker/config/SqlEventCleanupAgentConfigProperties;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "(Lorg/jooq/DSLContext;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/config/SqlEventCleanupAgentConfigProperties;Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;)V", "deletedId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "timingId", "getAgentType", "", "getPollIntervalMillis", "", "getProviderName", "getTimeoutMillis", "run", "", "Companion", "clouddriver-sql"})
public final class SqlEventCleanupAgent
implements RunnableAgent,
CustomScheduledAgent,
SqlAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DSLContext jooq;
    @NotNull
    private final Registry registry;
    @NotNull
    private final SqlEventCleanupAgentConfigProperties properties;
    @NotNull
    private final DynamicConfigService dynamicConfigService;
    @NotNull
    private final Lazy log$delegate;
    private final Id deletedId;
    private final Id timingId;
    @NotNull
    public static final String EVENT_CLEANUP_LIMIT_KEY = "spinnaker.clouddriver.eventing.cleanup-agent.cleanup-limit";
    @NotNull
    public static final String EVENT_CLEANUP_INTERVAL_KEY = "spinnaker.clouddriver.eventing.cleanup-agent.frequency";
    @NotNull
    public static final String EVENT_CLEANUP_TIMEOUT_KEY = "spinnaker.clouddriver.event.cleanup-agent.timeout";

    public SqlEventCleanupAgent(@NotNull DSLContext jooq, @NotNull Registry registry, @NotNull SqlEventCleanupAgentConfigProperties properties, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        this.jooq = jooq;
        this.registry = registry;
        this.properties = properties;
        this.dynamicConfigService = dynamicConfigService;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SqlEventCleanupAgent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        this.deletedId = this.registry.createId("sql.eventCleanupAgent.deleted");
        this.timingId = this.registry.createId("sql.eventCleanupAgent.timing");
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public void run() {
        Duration duration = Duration.ofDays(this.properties.getMaxAggregateAgeDays());
        Instant cutoff = Instant.now().minus(duration);
        Integer limit = (Integer)this.dynamicConfigService.getConfig(Integer.TYPE, EVENT_CLEANUP_LIMIT_KEY, (Object)1000);
        this.getLog().info("Deleting aggregates last updated earlier than " + cutoff + " (" + duration + "), max " + limit + " events");
        this.registry.timer(this.timingId).record(() -> SqlEventCleanupAgent.run$lambda-1(duration, this, limit));
    }

    @NotNull
    public String getAgentType() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @NotNull
    public String getProviderName() {
        String string = CoreProvider.PROVIDER_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PROVIDER_NAME");
        return string;
    }

    public long getPollIntervalMillis() {
        return Duration.parse((CharSequence)this.dynamicConfigService.getConfig(String.class, EVENT_CLEANUP_INTERVAL_KEY, (Object)"PT1M")).toMillis();
    }

    public long getTimeoutMillis() {
        return Duration.parse((CharSequence)this.dynamicConfigService.getConfig(String.class, EVENT_CLEANUP_TIMEOUT_KEY, (Object)"PT45S")).toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void run$lambda-1(Duration $duration, SqlEventCleanupAgent this$0, Integer $limit) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Instant threshold = Instant.now().minus($duration);
        String name$iv = ConnectionPools.EVENTS.getValue();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectConditionStep selectConditionStep = this$0.jooq.select((SelectField)DSL.field((String)"aggregate_type"), (SelectField)DSL.field((String)"aggregate_id")).from((TableLike)DSL.table((String)"event_aggregates")).where(DSL.field((String)"last_change_timestamp").lt((Object)new Timestamp(threshold.toEpochMilli())));
            Intrinsics.checkNotNullExpressionValue((Object)$limit, (String)"limit");
            ResultSet resultSet = selectConditionStep.limit($limit.intValue()).fetch().intoResultSet();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"jooq.select(field(\"aggre\u2026         .intoResultSet()");
            ResultSet rs = resultSet;
            long deleted = 0L;
            while (rs.next()) {
                ++deleted;
                this$0.jooq.deleteFrom(DSL.table((String)"event_aggregates")).where(DSL.field((String)"aggregate_type").eq((Object)rs.getString("aggregate_type")).and(DSL.field((String)"aggregate_id").eq((Object)rs.getString("aggregate_id")))).execute();
            }
            this$0.registry.counter(this$0.deletedId).increment(deleted);
            this$0.getLog().info("Deleted " + deleted + " event aggregates");
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0081\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/event/SqlEventCleanupAgent$Companion;", "", "()V", "EVENT_CLEANUP_INTERVAL_KEY", "", "EVENT_CLEANUP_LIMIT_KEY", "EVENT_CLEANUP_TIMEOUT_KEY", "clouddriver-sql"})
    @VisibleForTesting
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

