/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.sql.security;

import com.netflix.spinnaker.clouddriver.security.AccountDefinitionMapper;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionRepository;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionTypes;
import com.netflix.spinnaker.clouddriver.sql.SqlKt;
import com.netflix.spinnaker.clouddriver.sql.security.SqlAccountDefinitionException;
import com.netflix.spinnaker.clouddriver.sql.security.SqlAccountDefinitionRepository;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertOnDuplicateSetStep;
import org.jooq.InsertSetMoreStep;
import org.jooq.JSON;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016J*\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/security/SqlAccountDefinitionRepository;", "Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionRepository;", "jooq", "Lorg/jooq/DSLContext;", "mapper", "Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionMapper;", "clock", "Ljava/time/Clock;", "poolName", "", "(Lorg/jooq/DSLContext;Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionMapper;Ljava/time/Clock;Ljava/lang/String;)V", "create", "", "definition", "Lcom/netflix/spinnaker/credentials/definition/CredentialsDefinition;", "delete", "name", "deserializeAccountData", "accountData", "findLatestVersion", "Lorg/jooq/Select;", "Lorg/jooq/Record1;", "", "getByName", "getCredentialsType", "listByType", "", "typeName", "limit", "startingAccountName", "revisionHistory", "Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionRepository$Revision;", "save", "update", "Companion", "clouddriver-sql"})
public final class SqlAccountDefinitionRepository
implements AccountDefinitionRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DSLContext jooq;
    @NotNull
    private final AccountDefinitionMapper mapper;
    @NotNull
    private final Clock clock;
    @NotNull
    private final String poolName;
    @NotNull
    private static final Table<Record> accountsTable;
    @NotNull
    private static final Table<Record> accountHistoryTable;
    @NotNull
    private static final Field<String> idColumn;
    @NotNull
    private static final Field<JSON> bodyColumn;
    @NotNull
    private static final Field<String> typeColumn;
    @NotNull
    private static final Field<Boolean> deletedColumn;
    @NotNull
    private static final Field<Long> createdColumn;
    @NotNull
    private static final Field<Long> lastModifiedColumn;
    @NotNull
    private static final Field<String> modifiedByColumn;
    @NotNull
    private static final Field<Integer> versionColumn;
    private static final Logger LOGGER;

    public SqlAccountDefinitionRepository(@NotNull DSLContext jooq, @NotNull AccountDefinitionMapper mapper, @NotNull Clock clock, @NotNull String poolName) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        this.jooq = jooq;
        this.mapper = mapper;
        this.clock = clock;
        this.poolName = poolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CredentialsDefinition getByName(@NotNull String name) {
        CredentialsDefinition credentialsDefinition;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            credentialsDefinition = (CredentialsDefinition)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, CredentialsDefinition>(name, this){
                final /* synthetic */ String $name;
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                {
                    this.$name = $name;
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final CredentialsDefinition invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return (CredentialsDefinition)ctx.select((SelectField)SqlAccountDefinitionRepository.access$getBodyColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name)).fetchOne(arg_0 -> getByName.1.1.invoke$lambda-0(this.this$0, arg_0));
                }

                private static final CredentialsDefinition invoke$lambda-0(SqlAccountDefinitionRepository this$0, Record1 record1) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    JSON json = (JSON)record1.component1();
                    return SqlAccountDefinitionRepository.access$getMapper$p(this$0).deserialize(json.data());
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return credentialsDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<? extends CredentialsDefinition> listByType(@NotNull String typeName2, int limit, @Nullable String startingAccountName) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            list2 = (List)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, List<CredentialsDefinition>>(typeName2, startingAccountName, limit, this){
                final /* synthetic */ String $typeName;
                final /* synthetic */ String $startingAccountName;
                final /* synthetic */ int $limit;
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                {
                    this.$typeName = $typeName;
                    this.$startingAccountName = $startingAccountName;
                    this.$limit = $limit;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final List<CredentialsDefinition> invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Object[] objectArray = new Condition[]{SqlAccountDefinitionRepository.access$getTypeColumn$cp().eq((Object)this.$typeName)};
                    List conditions = CollectionsKt.mutableListOf((Object[])objectArray);
                    String string = this.$startingAccountName;
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        ((Collection)conditions).add(SqlAccountDefinitionRepository.access$getIdColumn$cp().ge((Object)it));
                    }
                    List list2 = ctx.select((SelectField)SqlAccountDefinitionRepository.access$getBodyColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where((Collection)conditions).orderBy((OrderField)SqlAccountDefinitionRepository.access$getIdColumn$cp()).limit(this.$limit).fetch(arg_0 -> listByType.1.1.invoke$lambda-1(this.this$0, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ctx.select(bodyColumn)\n \u2026(json.data())\n          }");
                    return (List)CollectionsKt.filterNotNullTo((Iterable)list2, (Collection)new ArrayList<E>());
                }

                private static final CredentialsDefinition invoke$lambda-1(SqlAccountDefinitionRepository this$0, Record1 record1) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    JSON json = (JSON)record1.component1();
                    String string = json.data();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.data()");
                    return SqlAccountDefinitionRepository.access$deserializeAccountData(this$0, string);
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<? extends CredentialsDefinition> listByType(@NotNull String typeName2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            list2 = (List)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, List<CredentialsDefinition>>(typeName2, this){
                final /* synthetic */ String $typeName;
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                {
                    this.$typeName = $typeName;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final List<CredentialsDefinition> invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    List list2 = ctx.select((SelectField)SqlAccountDefinitionRepository.access$getBodyColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where(SqlAccountDefinitionRepository.access$getTypeColumn$cp().eq((Object)this.$typeName)).fetch(arg_0 -> listByType.2.1.invoke$lambda-0(this.this$0, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ctx.select(bodyColumn)\n \u2026(json.data())\n          }");
                    return (List)CollectionsKt.filterNotNullTo((Iterable)list2, (Collection)new ArrayList<E>());
                }

                private static final CredentialsDefinition invoke$lambda-0(SqlAccountDefinitionRepository this$0, Record1 record1) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    JSON json = (JSON)record1.component1();
                    String string = json.data();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.data()");
                    return SqlAccountDefinitionRepository.access$deserializeAccountData(this$0, string);
                }
            });
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return list2;
    }

    private final CredentialsDefinition deserializeAccountData(String accountData) {
        CredentialsDefinition credentialsDefinition;
        try {
            credentialsDefinition = this.mapper.deserialize(accountData);
        }
        catch (SecretException e) {
            LOGGER.warn("Unable to decrypt secret in account data (" + accountData + "). Skipping this account.", (Throwable)e);
            credentialsDefinition = null;
        }
        catch (Exception e) {
            LOGGER.error("Invalid account data loaded (" + accountData + "). Skipping this account; consider deleting or fixing it.", (Throwable)e);
            credentialsDefinition = null;
        }
        return credentialsDefinition;
    }

    private final String getCredentialsType(CredentialsDefinition definition) {
        Class<?> javaClass = definition.getClass();
        String string = AccountDefinitionTypes.getCredentialsTypeName(javaClass);
        if (string == null) {
            throw new IllegalArgumentException("No @CredentialsType annotation found on " + javaClass);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(@NotNull CredentialsDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            String name = definition.getName();
            String typeName2 = this.getCredentialsType(definition);
            long timestamp = this.clock.millis();
            String user = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
            JSON jSON = JSON.valueOf((String)this.mapper.serialize(definition));
            Intrinsics.checkNotNullExpressionValue((Object)jSON, (String)"valueOf(mapper.serialize(definition))");
            JSON body = jSON;
            try {
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(name, typeName2, body, timestamp, user, this){
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $typeName;
                    final /* synthetic */ JSON $body;
                    final /* synthetic */ long $timestamp;
                    final /* synthetic */ String $user;
                    final /* synthetic */ SqlAccountDefinitionRepository this$0;
                    {
                        this.$name = $name;
                        this.$typeName = $typeName;
                        this.$body = $body;
                        this.$timestamp = $timestamp;
                        this.$user = $user;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountsTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getCreatedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getModifiedByColumn$cp(), (Object)this.$user).execute();
                        InsertSetMoreStep insertSetMoreStep = ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp);
                        Field field = SqlAccountDefinitionRepository.access$getVersionColumn$cp();
                        String string = this.$name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        insertSetMoreStep.set(field, SqlAccountDefinitionRepository.access$findLatestVersion(this.this$0, string)).execute();
                    }
                }));
            }
            catch (DataAccessException e) {
                throw new SqlAccountDefinitionException("Cannot create account with definition " + body, e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull CredentialsDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            String name = definition.getName();
            String typeName2 = this.getCredentialsType(definition);
            long timestamp = this.clock.millis();
            String user = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
            JSON jSON = JSON.valueOf((String)this.mapper.serialize(definition));
            Intrinsics.checkNotNullExpressionValue((Object)jSON, (String)"valueOf(mapper.serialize(definition))");
            JSON body = jSON;
            try {
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(name, typeName2, body, timestamp, user, this){
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $typeName;
                    final /* synthetic */ JSON $body;
                    final /* synthetic */ long $timestamp;
                    final /* synthetic */ String $user;
                    final /* synthetic */ SqlAccountDefinitionRepository this$0;
                    {
                        this.$name = $name;
                        this.$typeName = $typeName;
                        this.$body = $body;
                        this.$timestamp = $timestamp;
                        this.$user = $user;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        InsertOnDuplicateSetStep insertOnDuplicateSetStep;
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        InsertSetMoreStep insertSetMoreStep = ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountsTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getCreatedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getModifiedByColumn$cp(), (Object)this.$user);
                        SqlAccountDefinitionRepository sqlAccountDefinitionRepository = this.this$0;
                        InsertSetMoreStep $this$invoke_u24lambda_u2d0 = insertSetMoreStep;
                        boolean bl = false;
                        if (SqlAccountDefinitionRepository.access$getJooq$p(sqlAccountDefinitionRepository).dialect() == SQLDialect.POSTGRES) {
                            Field[] fieldArray = new Field[]{SqlAccountDefinitionRepository.access$getIdColumn$cp()};
                            insertOnDuplicateSetStep = $this$invoke_u24lambda_u2d0.onConflict(fieldArray).doUpdate();
                        } else {
                            insertOnDuplicateSetStep = $this$invoke_u24lambda_u2d0.onDuplicateKeyUpdate();
                        }
                        insertOnDuplicateSetStep.set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getModifiedByColumn$cp(), (Object)this.$user).execute();
                        InsertSetMoreStep insertSetMoreStep2 = ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp);
                        Field field = SqlAccountDefinitionRepository.access$getVersionColumn$cp();
                        String string = this.$name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        insertSetMoreStep2.set(field, SqlAccountDefinitionRepository.access$findLatestVersion(this.this$0, string)).execute();
                    }
                }));
            }
            catch (DataAccessException e) {
                throw new SqlAccountDefinitionException("Cannot save account with definition " + body, e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@NotNull CredentialsDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            String name = definition.getName();
            String typeName2 = this.getCredentialsType(definition);
            long timestamp = this.clock.millis();
            String user = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
            JSON jSON = JSON.valueOf((String)this.mapper.serialize(definition));
            Intrinsics.checkNotNullExpressionValue((Object)jSON, (String)"valueOf(mapper.serialize(definition))");
            JSON body = jSON;
            try {
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(body, timestamp, user, name, typeName2, this){
                    final /* synthetic */ JSON $body;
                    final /* synthetic */ long $timestamp;
                    final /* synthetic */ String $user;
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $typeName;
                    final /* synthetic */ SqlAccountDefinitionRepository this$0;
                    {
                        this.$body = $body;
                        this.$timestamp = $timestamp;
                        this.$user = $user;
                        this.$name = $name;
                        this.$typeName = $typeName;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        int rows = ctx.update(SqlAccountDefinitionRepository.access$getAccountsTable$cp()).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp).set(SqlAccountDefinitionRepository.access$getModifiedByColumn$cp(), (Object)this.$user).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name)).execute();
                        if (rows != 1) {
                            throw new NotFoundException("No account found with name " + this.$name);
                        }
                        InsertSetMoreStep insertSetMoreStep = ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getTypeColumn$cp(), (Object)this.$typeName).set(SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (Object)this.$body).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)this.$timestamp);
                        Field field = SqlAccountDefinitionRepository.access$getVersionColumn$cp();
                        String string = this.$name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        insertSetMoreStep.set(field, SqlAccountDefinitionRepository.access$findLatestVersion(this.this$0, string)).execute();
                    }
                }));
            }
            catch (DataAccessException e) {
                throw new SqlAccountDefinitionException("Cannot update account with definition " + body, e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            String string = (String)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, String>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return (String)ctx.select((SelectField)SqlAccountDefinitionRepository.access$getTypeColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name)).fetchOne(SqlAccountDefinitionRepository.access$getTypeColumn$cp());
                }
            });
            if (string == null) {
                throw new NotFoundException("No account found with name " + name);
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name: String) {\n    with\u2026t found with name $name\")");
            String typeName2 = string;
            try {
                SqlKt.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(name, this){
                    final /* synthetic */ String $name;
                    final /* synthetic */ SqlAccountDefinitionRepository this$0;
                    {
                        this.$name = $name;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        ctx.insertInto(SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).set(SqlAccountDefinitionRepository.access$getIdColumn$cp(), (Object)this.$name).set(SqlAccountDefinitionRepository.access$getDeletedColumn$cp(), (Object)true).set(SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp(), (Object)SqlAccountDefinitionRepository.access$getClock$p(this.this$0).millis()).set(SqlAccountDefinitionRepository.access$getVersionColumn$cp(), SqlAccountDefinitionRepository.access$findLatestVersion(this.this$0, this.$name)).execute();
                        ctx.deleteFrom(SqlAccountDefinitionRepository.access$getAccountsTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name)).execute();
                    }
                }));
            }
            catch (DataAccessException e) {
                throw new SqlAccountDefinitionException("Cannot delete account with name " + name, e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Select<Record1<Integer>> findLatestVersion(String name) {
        SelectConditionStep selectConditionStep;
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectConditionStep selectConditionStep2 = (SelectConditionStep)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, SelectConditionStep<Record1<Integer>>>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final SelectConditionStep<Record1<Integer>> invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return ctx.select((SelectField)DSL.count((Field)SqlAccountDefinitionRepository.access$getVersionColumn$cp()).plus((Number)1)).from((TableLike)SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name));
                }
            });
            selectConditionStep = selectConditionStep2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"withPool(poolName) {\n   \u2026n.eq(name))\n      }\n    }");
        return (Select)selectConditionStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<AccountDefinitionRepository.Revision> revisionHistory(@NotNull String name) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            List list3 = (List)SqlKt.read(this.jooq, (Function1)new Function1<DSLContext, List<AccountDefinitionRepository.Revision>>(name, this){
                final /* synthetic */ String $name;
                final /* synthetic */ SqlAccountDefinitionRepository this$0;
                {
                    this.$name = $name;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final List<AccountDefinitionRepository.Revision> invoke(@NotNull DSLContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return ctx.select((SelectField)SqlAccountDefinitionRepository.access$getBodyColumn$cp(), (SelectField)SqlAccountDefinitionRepository.access$getVersionColumn$cp(), (SelectField)SqlAccountDefinitionRepository.access$getLastModifiedColumn$cp()).from((TableLike)SqlAccountDefinitionRepository.access$getAccountHistoryTable$cp()).where(SqlAccountDefinitionRepository.access$getIdColumn$cp().eq((Object)this.$name)).orderBy((OrderField)SqlAccountDefinitionRepository.access$getVersionColumn$cp().desc()).fetch(arg_0 -> revisionHistory.1.1.invoke$lambda-1(this.this$0, arg_0));
                }

                /*
                 * WARNING - void declaration
                 */
                private static final AccountDefinitionRepository.Revision invoke$lambda-1(SqlAccountDefinitionRepository this$0, Record3 record3) {
                    CredentialsDefinition credentialsDefinition;
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    JSON body = (JSON)record3.component1();
                    Integer version = (Integer)record3.component2();
                    Long timestamp = (Long)record3.component3();
                    Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
                    int n = version;
                    Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"timestamp");
                    long l = timestamp;
                    JSON jSON = body;
                    if (jSON != null) {
                        void it;
                        JSON jSON2 = jSON;
                        long l2 = l;
                        int n2 = n;
                        boolean bl = false;
                        CredentialsDefinition credentialsDefinition2 = SqlAccountDefinitionRepository.access$getMapper$p(this$0).deserialize(it.data());
                        n = n2;
                        l = l2;
                        credentialsDefinition = credentialsDefinition2;
                    } else {
                        credentialsDefinition = null;
                    }
                    CredentialsDefinition credentialsDefinition3 = credentialsDefinition;
                    long l3 = l;
                    int n3 = n;
                    return new AccountDefinitionRepository.Revision(n3, l3, credentialsDefinition3);
                }
            });
            list2 = list3;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"withPool(poolName) {\n   \u2026        ) }\n      }\n    }");
        return list2;
    }

    public static final /* synthetic */ Field access$getBodyColumn$cp() {
        return bodyColumn;
    }

    public static final /* synthetic */ Table access$getAccountsTable$cp() {
        return accountsTable;
    }

    public static final /* synthetic */ Field access$getIdColumn$cp() {
        return idColumn;
    }

    public static final /* synthetic */ AccountDefinitionMapper access$getMapper$p(SqlAccountDefinitionRepository $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ Field access$getTypeColumn$cp() {
        return typeColumn;
    }

    public static final /* synthetic */ CredentialsDefinition access$deserializeAccountData(SqlAccountDefinitionRepository $this, String accountData) {
        return $this.deserializeAccountData(accountData);
    }

    public static final /* synthetic */ Field access$getCreatedColumn$cp() {
        return createdColumn;
    }

    public static final /* synthetic */ Field access$getLastModifiedColumn$cp() {
        return lastModifiedColumn;
    }

    public static final /* synthetic */ Field access$getModifiedByColumn$cp() {
        return modifiedByColumn;
    }

    public static final /* synthetic */ Table access$getAccountHistoryTable$cp() {
        return accountHistoryTable;
    }

    public static final /* synthetic */ Field access$getVersionColumn$cp() {
        return versionColumn;
    }

    public static final /* synthetic */ Select access$findLatestVersion(SqlAccountDefinitionRepository $this, String name) {
        return $this.findLatestVersion(name);
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlAccountDefinitionRepository $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ Field access$getDeletedColumn$cp() {
        return deletedColumn;
    }

    public static final /* synthetic */ Clock access$getClock$p(SqlAccountDefinitionRepository $this) {
        return $this.clock;
    }

    static {
        Table table = DSL.table((String)"accounts");
        Intrinsics.checkNotNullExpressionValue((Object)table, (String)"table(\"accounts\")");
        accountsTable = table;
        Table table2 = DSL.table((String)"accounts_history");
        Intrinsics.checkNotNullExpressionValue((Object)table2, (String)"table(\"accounts_history\")");
        accountHistoryTable = table2;
        Field field = DSL.field((String)"id", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field(\"id\", String::class.java)");
        idColumn = field;
        Field field2 = DSL.field((String)"body", JSON.class);
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field(\"body\", JSON::class.java)");
        bodyColumn = field2;
        Field field3 = DSL.field((String)"type", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"field(\"type\", String::class.java)");
        typeColumn = field3;
        Field field4 = DSL.field((String)"is_deleted", Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)field4, (String)"field(\"is_deleted\", Boolean::class.java)");
        deletedColumn = field4;
        Field field5 = DSL.field((String)"created_at", Long.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)field5, (String)"field(\"created_at\", Long::class.java)");
        createdColumn = field5;
        Field field6 = DSL.field((String)"last_modified_at", Long.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)field6, (String)"field(\"last_modified_at\", Long::class.java)");
        lastModifiedColumn = field6;
        Field field7 = DSL.field((String)"last_modified_by", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)field7, (String)"field(\"last_modified_by\", String::class.java)");
        modifiedByColumn = field7;
        Field field8 = DSL.field((String)"version", Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)field8, (String)"field(\"version\", Int::class.java)");
        versionColumn = field8;
        LOGGER = LogManager.getLogger(SqlAccountDefinitionRepository.class);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000f0\u000f0\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00110\u00110\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00130\u00130\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000f0\u000f0\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0015\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00130\u00130\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0016\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00130\u00130\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0017\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00180\u00180\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/netflix/spinnaker/clouddriver/sql/security/SqlAccountDefinitionRepository$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "accountHistoryTable", "Lorg/jooq/Table;", "Lorg/jooq/Record;", "Lorg/jetbrains/annotations/NotNull;", "accountsTable", "bodyColumn", "Lorg/jooq/Field;", "Lorg/jooq/JSON;", "createdColumn", "", "deletedColumn", "", "idColumn", "", "lastModifiedColumn", "modifiedByColumn", "typeColumn", "versionColumn", "", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

