/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.event.persistence.EventRepository;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionMapper;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionRepository;
import com.netflix.spinnaker.clouddriver.sql.SqlProvider;
import com.netflix.spinnaker.clouddriver.sql.SqlTaskCleanupAgent;
import com.netflix.spinnaker.clouddriver.sql.SqlTaskRepository;
import com.netflix.spinnaker.clouddriver.sql.event.SqlEventCleanupAgent;
import com.netflix.spinnaker.clouddriver.sql.event.SqlEventRepository;
import com.netflix.spinnaker.clouddriver.sql.security.SqlAccountDefinitionRepository;
import com.netflix.spinnaker.config.ConnectionPools;
import com.netflix.spinnaker.config.SqlEventCleanupAgentConfigProperties;
import com.netflix.spinnaker.config.SqlTaskCleanupAgentProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.jackson.ObjectMapperSubtypeConfigurer;
import com.netflix.spinnaker.kork.sql.config.DefaultSqlConfiguration;
import com.netflix.spinnaker.kork.sql.config.SqlProperties;
import com.netflix.spinnaker.kork.telemetry.InstrumentedProxy;
import com.netflix.spinnaker.kork.version.ServiceVersion;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(value={"sql.enabled"})
@Import(value={DefaultSqlConfiguration.class})
@EnableConfigurationProperties(value={SqlTaskCleanupAgentProperties.class, SqlEventCleanupAgentConfigProperties.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017JF\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0017J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0017J(\u0010&\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020(H\u0017J \u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006*"}, d2={"Lcom/netflix/spinnaker/config/SqlConfiguration;", "", "()V", "secondarySqlTaskRepository", "Lcom/netflix/spinnaker/clouddriver/data/task/TaskRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "poolName", "", "sqlAccountDefinitionRepository", "Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionRepository;", "mapper", "Lcom/netflix/spinnaker/clouddriver/security/AccountDefinitionMapper;", "sqlEventCleanupAgent", "Lcom/netflix/spinnaker/clouddriver/sql/event/SqlEventCleanupAgent;", "registry", "Lcom/netflix/spectator/api/Registry;", "properties", "Lcom/netflix/spinnaker/config/SqlEventCleanupAgentConfigProperties;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "sqlEventRepository", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository;", "sqlProperties", "Lcom/netflix/spinnaker/kork/sql/config/SqlProperties;", "serviceVersion", "Lcom/netflix/spinnaker/kork/version/ServiceVersion;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "subtypeLocators", "", "Lcom/netflix/spinnaker/kork/jackson/ObjectMapperSubtypeConfigurer$SubtypeLocator;", "sqlProvider", "Lcom/netflix/spinnaker/clouddriver/sql/SqlProvider;", "sqlTaskCleanupAgent", "Lcom/netflix/spinnaker/clouddriver/sql/SqlTaskCleanupAgent;", "Lcom/netflix/spinnaker/config/SqlTaskCleanupAgentProperties;", "sqlTaskRepository", "clouddriver-sql"})
public class SqlConfiguration {
    @Bean
    @ConditionalOnProperty(value={"sql.task-repository.enabled"})
    @NotNull
    public TaskRepository sqlTaskRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new SqlTaskRepository(jooq, objectMapper, clock, ConnectionPools.TASKS.getValue());
    }

    @Bean
    @ConditionalOnProperty(value={"sql.task-repository.enabled", "sql.task-repository.secondary.enabled"})
    @NotNull
    public TaskRepository secondarySqlTaskRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ObjectMapper objectMapper, @Value(value="${sql.task-repository.secondary.pool-name}") @NotNull String poolName) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        return new SqlTaskRepository(jooq, objectMapper, clock, poolName);
    }

    @Bean
    @ConditionalOnProperty(value={"sql.task-repository.enabled"})
    @ConditionalOnExpression(value="${sql.read-only:false} == false")
    @NotNull
    public SqlTaskCleanupAgent sqlTaskCleanupAgent(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull Registry registry, @NotNull SqlTaskCleanupAgentProperties properties) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SqlTaskCleanupAgent(jooq, clock, registry, properties);
    }

    @Bean
    @ConditionalOnProperty(value={"sql.task-repository.enabled"})
    @ConditionalOnExpression(value="${sql.read-only:false} == false")
    @NotNull
    public SqlProvider sqlProvider(@NotNull SqlTaskCleanupAgent sqlTaskCleanupAgent) {
        Intrinsics.checkNotNullParameter((Object)sqlTaskCleanupAgent, (String)"sqlTaskCleanupAgent");
        Object[] objectArray = new Agent[]{(Agent)sqlTaskCleanupAgent};
        return new SqlProvider(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    @Bean
    @NotNull
    public EventRepository sqlEventRepository(@NotNull DSLContext jooq, @NotNull SqlProperties sqlProperties, @NotNull ServiceVersion serviceVersion, @NotNull ObjectMapper objectMapper, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Registry registry, @NotNull List<? extends ObjectMapperSubtypeConfigurer.SubtypeLocator> subtypeLocators) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)sqlProperties, (String)"sqlProperties");
        Intrinsics.checkNotNullParameter((Object)serviceVersion, (String)"serviceVersion");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(subtypeLocators, (String)"subtypeLocators");
        new ObjectMapperSubtypeConfigurer(true).registerSubtypes(objectMapper, subtypeLocators);
        SqlEventRepository it = new SqlEventRepository(jooq, serviceVersion, objectMapper, applicationEventPublisher, registry);
        boolean bl = false;
        EventRepository eventRepository = (EventRepository)InstrumentedProxy.proxy((Registry)registry, (Object)it, (String)"eventRepository", (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"backend", (Object)"sql")));
        Intrinsics.checkNotNullExpressionValue((Object)eventRepository, (String)"SqlEventRepository(\n    \u2026backend\" to \"sql\"))\n    }");
        return eventRepository;
    }

    @Bean
    @ConditionalOnExpression(value="${sql.read-only:false} == false")
    @NotNull
    public SqlEventCleanupAgent sqlEventCleanupAgent(@NotNull DSLContext jooq, @NotNull Registry registry, @NotNull SqlEventCleanupAgentConfigProperties properties, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        return new SqlEventCleanupAgent(jooq, registry, properties, dynamicConfigService);
    }

    @Bean
    @ConditionalOnProperty(value={"account.storage.enabled"})
    @NotNull
    public AccountDefinitionRepository sqlAccountDefinitionRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull AccountDefinitionMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        return new SqlAccountDefinitionRepository(jooq, mapper, clock, ConnectionPools.ACCOUNTS.getValue());
    }
}

