/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import java.time.Duration;
import javax.validation.constraints.Positive;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="spinnaker.clouddriver.eventing.cleanup-agent")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/netflix/spinnaker/config/SqlEventCleanupAgentConfigProperties;", "", "()V", "cleanupLimit", "", "getCleanupLimit", "()I", "setCleanupLimit", "(I)V", "frequency", "Ljava/time/Duration;", "getFrequency", "()Ljava/time/Duration;", "setFrequency", "(Ljava/time/Duration;)V", "maxAggregateAgeDays", "", "getMaxAggregateAgeDays", "()J", "setMaxAggregateAgeDays", "(J)V", "timeout", "getTimeout", "setTimeout", "Companion", "clouddriver-sql"})
public class SqlEventCleanupAgentConfigProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Duration frequency;
    @NotNull
    private Duration timeout;
    @Positive
    private long maxAggregateAgeDays;
    @Positive
    private int cleanupLimit;
    public static final int EVENT_CLEANUP_LIMIT = 1000;

    public SqlEventCleanupAgentConfigProperties() {
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(1)");
        this.frequency = duration;
        Duration duration2 = Duration.ofSeconds(45L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(45)");
        this.timeout = duration2;
        this.maxAggregateAgeDays = 7L;
        this.cleanupLimit = 1000;
    }

    @NotNull
    public Duration getFrequency() {
        return this.frequency;
    }

    public void setFrequency(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.frequency = duration;
    }

    @NotNull
    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.timeout = duration;
    }

    public long getMaxAggregateAgeDays() {
        return this.maxAggregateAgeDays;
    }

    public void setMaxAggregateAgeDays(long l) {
        this.maxAggregateAgeDays = l;
    }

    public int getCleanupLimit() {
        return this.cleanupLimit;
    }

    public void setCleanupLimit(int n) {
        this.cleanupLimit = n;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/spinnaker/config/SqlEventCleanupAgentConfigProperties$Companion;", "", "()V", "EVENT_CLEANUP_LIMIT", "", "clouddriver-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

