/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.cache;

import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.cache.KeyParser;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="TencentCloudKeys")
public class Keys
implements KeyParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Keys.class);
    private static final String SEPARATOR = ":";

    public String getCloudProvider() {
        return "tencentcloud";
    }

    public Boolean canParseType(String type) {
        try {
            Namespace.fromString(type);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean canParseField(String field) {
        return false;
    }

    public Map<String, String> parseKey(String key) {
        return Keys.parse(key);
    }

    public static Map<String, String> parse(String key) {
        String[] parts = key.split(SEPARATOR);
        if (parts.length < 2 || !parts[0].equals("tencentcloud")) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("provider", parts[0]);
        result.put("type", parts[1]);
        Namespace namespace = Namespace.fromString((String)result.get("type"));
        if (namespace == null) {
            return null;
        }
        switch (namespace) {
            case APPLICATIONS: {
                break;
            }
            case CLUSTERS: {
                Names names = Names.parseName((String)parts[4]);
                result.put("application", parts[3]);
                result.put("account", parts[2]);
                result.put("name", parts[4]);
                result.put("cluster", parts[4]);
                result.put("stack", names.getStack());
                result.put("detail", names.getDetail());
                break;
            }
            case IMAGES: {
                result.put("account", parts[2]);
                result.put("region", parts[3]);
                result.put("imageId", parts[4]);
                break;
            }
            case NAMED_IMAGES: {
                result.put("account", parts[2]);
                result.put("imageName", parts[3]);
                break;
            }
            case LOAD_BALANCERS: 
            case NETWORKS: 
            case SUBNETS: {
                result.put("account", parts[2]);
                result.put("region", parts[3]);
                result.put("id", parts[4]);
                break;
            }
            case SECURITY_GROUPS: {
                result.put("application", Names.parseName((String)parts[2]).getApp());
                result.put("name", parts[2]);
                result.put("account", parts[3]);
                result.put("region", parts[4]);
                result.put("id", parts[5]);
                break;
            }
            case SERVER_GROUPS: {
                result.put("account", parts[2]);
                result.put("region", parts[3]);
                result.put("cluster", parts[4]);
                result.put("name", parts[5]);
                break;
            }
            default: {
                return null;
            }
        }
        return result;
    }

    public static String getApplicationKey(String application) {
        return "tencentcloud:" + Namespace.APPLICATIONS + SEPARATOR + application.toLowerCase();
    }

    public static String getClusterKey(String clusterName, String application, String account) {
        return "tencentcloud:" + Namespace.CLUSTERS + SEPARATOR + account + SEPARATOR + application.toLowerCase() + SEPARATOR + clusterName;
    }

    public static String getServerGroupKey(String serverGroupName, String account, String region) {
        Names names = Names.parseName((String)serverGroupName);
        return Keys.getServerGroupKey(names.getCluster(), names.getGroup(), account, region);
    }

    public static String getServerGroupKey(String cluster, String serverGroupName, String account, String region) {
        return "tencentcloud:" + Namespace.SERVER_GROUPS + SEPARATOR + account + SEPARATOR + region + SEPARATOR + cluster + SEPARATOR + serverGroupName;
    }

    public static String getInstanceKey(String instanceId, String account, String region) {
        return "tencentcloud:" + Namespace.INSTANCES + SEPARATOR + account + SEPARATOR + region + SEPARATOR + instanceId;
    }

    public static String getImageKey(String imageId, String account, String region) {
        return "tencentcloud:" + Namespace.IMAGES + SEPARATOR + account + SEPARATOR + region + SEPARATOR + imageId;
    }

    public static String getNamedImageKey(String imageName, String account) {
        return "tencentcloud:" + Namespace.NAMED_IMAGES + SEPARATOR + account + SEPARATOR + imageName;
    }

    public static String getKeyPairKey(String keyId, String account, String region) {
        return "tencentcloud:" + Namespace.KEY_PAIRS + SEPARATOR + account + SEPARATOR + region + SEPARATOR + keyId;
    }

    public static String getInstanceTypeKey(String account, String region, String instanceType) {
        return "tencentcloud:" + Namespace.INSTANCE_TYPES + SEPARATOR + account + SEPARATOR + region + SEPARATOR + instanceType;
    }

    public static String getLoadBalancerKey(String loadBalancerId, String account, String region) {
        return "tencentcloud:" + Namespace.LOAD_BALANCERS + SEPARATOR + account + SEPARATOR + region + SEPARATOR + loadBalancerId;
    }

    public static String getSecurityGroupKey(String securityGroupId, String securityGroupName, String account, String region) {
        return "tencentcloud:" + Namespace.SECURITY_GROUPS + SEPARATOR + securityGroupName + SEPARATOR + account + SEPARATOR + region + SEPARATOR + securityGroupId;
    }

    public static String getNetworkKey(String networkId, String account, String region) {
        return "tencentcloud:" + Namespace.NETWORKS + SEPARATOR + account + SEPARATOR + region + SEPARATOR + networkId;
    }

    public static String getSubnetKey(String subnetId, String account, String region) {
        return "tencentcloud:" + Namespace.SUBNETS + SEPARATOR + account + SEPARATOR + region + SEPARATOR + subnetId;
    }

    public static String getTargetHealthKey(String loadBalancerId, String listenerId, String instanceId, String account, String region) {
        return "tencentcloud:" + Namespace.HEALTH_CHECKS + SEPARATOR + account + SEPARATOR + region + SEPARATOR + loadBalancerId + SEPARATOR + listenerId + SEPARATOR + instanceId;
    }

    public static enum Namespace {
        APPLICATIONS,
        CLUSTERS,
        HEALTH_CHECKS,
        LAUNCH_CONFIGS,
        IMAGES,
        NAMED_IMAGES,
        INSTANCES,
        INSTANCE_TYPES,
        KEY_PAIRS,
        LOAD_BALANCERS,
        NETWORKS,
        SECURITY_GROUPS,
        SERVER_GROUPS,
        SUBNETS,
        ON_DEMAND;

        public final String ns = this.name().toLowerCase();

        public static Namespace fromString(String name) {
            try {
                return Namespace.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("No matching namespace with name " + name + " exists");
            }
        }

        public String toString() {
            return this.ns;
        }
    }
}

