/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.model;

import com.netflix.spinnaker.clouddriver.model.Health;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import lombok.Generated;

public class TencentCloudInstanceHealth
implements Health {
    private final String healthClass = "platform";
    private final String type = "TencentCloud";
    private Status instanceStatus;

    public TencentCloudInstanceHealth(String instanceStatus) {
        this.instanceStatus = Enum.valueOf(Status.class, instanceStatus);
    }

    public HealthState getState() {
        switch (this.instanceStatus) {
            case PENDING: {
                return HealthState.Starting;
            }
            case RUNNING: {
                return HealthState.Unknown;
            }
            case STOPPED: {
                return HealthState.Down;
            }
        }
        return HealthState.Unknown;
    }

    @Generated
    public String getHealthClass() {
        return this.healthClass;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Status getInstanceStatus() {
        return this.instanceStatus;
    }

    @Generated
    public TencentCloudInstanceHealth setInstanceStatus(Status instanceStatus) {
        this.instanceStatus = instanceStatus;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentCloudInstanceHealth)) {
            return false;
        }
        TencentCloudInstanceHealth other = (TencentCloudInstanceHealth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$healthClass = this.getHealthClass();
        String other$healthClass = other.getHealthClass();
        if (this$healthClass == null ? other$healthClass != null : !this$healthClass.equals(other$healthClass)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Status this$instanceStatus = this.getInstanceStatus();
        Status other$instanceStatus = other.getInstanceStatus();
        return !(this$instanceStatus == null ? other$instanceStatus != null : !((Object)((Object)this$instanceStatus)).equals((Object)other$instanceStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TencentCloudInstanceHealth;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $healthClass = this.getHealthClass();
        result = result * 59 + ($healthClass == null ? 43 : $healthClass.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Status $instanceStatus = this.getInstanceStatus();
        result = result * 59 + ($instanceStatus == null ? 43 : ((Object)((Object)$instanceStatus)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TencentCloudInstanceHealth(healthClass=" + this.getHealthClass() + ", type=" + this.getType() + ", instanceStatus=" + this.getInstanceStatus() + ")";
    }

    @Generated
    public TencentCloudInstanceHealth() {
    }

    public static enum Status {
        PENDING,
        LAUNCH_FAILED,
        RUNNING,
        STOPPED,
        STARTING,
        STOPPING,
        REBOOTING,
        SHUTDOWN,
        TERMINATING;

    }
}

