/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.model;

import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.tencentcloud.client.AutoScalingClient;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudBasicResource;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudInstance;
import com.netflix.spinnaker.moniker.Moniker;
import com.tencentcloudapi.as.v20180419.models.AutoScalingGroup;
import com.tencentcloudapi.as.v20180419.models.ForwardLoadBalancer;
import com.tencentcloudapi.as.v20180419.models.ScalingPolicy;
import com.tencentcloudapi.as.v20180419.models.ScheduledAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class TencentCloudServerGroup
implements ServerGroup,
TencentCloudBasicResource {
    private final String type = "tencentcloud";
    private final String cloudProvider = "tencentcloud";
    private String accountName;
    private String name;
    private String region;
    private Set<String> zones;
    private Set<TencentCloudInstance> instances = new HashSet<TencentCloudInstance>();
    private Map<String, Object> image = new HashMap<String, Object>();
    private Map<String, Object> launchConfig = new HashMap<String, Object>();
    private AutoScalingGroup asg;
    private Map buildInfo;
    private String vpcId;
    private List<ScalingPolicy> scalingPolicies = new ArrayList<ScalingPolicy>();
    private List<ScheduledAction> scheduledActions = new ArrayList<ScheduledAction>();
    private Boolean disabled = false;

    public String getName() {
        return this.name;
    }

    public Moniker getMoniker() {
        return NamerRegistry.lookup().withProvider("tencentcloud").withAccount(this.accountName).withResource(TencentCloudBasicResource.class).deriveMoniker((Object)this);
    }

    public String getType() {
        Objects.requireNonNull(this);
        return "tencentcloud";
    }

    public String getCloudProvider() {
        Objects.requireNonNull(this);
        return "tencentcloud";
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public String getMonikerName() {
        return this.name;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    public Long getCreatedTime() {
        Date dateTime = null;
        if (this.asg != null) {
            dateTime = AutoScalingClient.convertToIsoDateTime(this.asg.getCreatedTime());
        }
        return dateTime != null ? Long.valueOf(dateTime.getTime()) : null;
    }

    public Set<String> getZones() {
        return this.zones;
    }

    public Set<TencentCloudInstance> getInstances() {
        return this.instances;
    }

    public Set<String> getLoadBalancers() {
        Set<String> loadBalancerNames = new HashSet<String>();
        if (this.asg != null && this.asg.getForwardLoadBalancerSet() != null) {
            loadBalancerNames = Arrays.stream(this.asg.getForwardLoadBalancerSet()).map(ForwardLoadBalancer::getListenerId).collect(Collectors.toSet());
        }
        if (this.asg != null && this.asg.getLoadBalancerIdSet() != null) {
            loadBalancerNames.addAll(Arrays.asList(this.asg.getLoadBalancerIdSet()));
        }
        return loadBalancerNames;
    }

    public Set<String> getSecurityGroups() {
        HashSet<String> securityGroups = new HashSet<String>();
        if (this.launchConfig != null && this.launchConfig.containsKey("securityGroupIds")) {
            securityGroups.addAll((List)this.launchConfig.get("securityGroupIds"));
        }
        return securityGroups;
    }

    public Map<String, Object> getLaunchConfig() {
        return this.launchConfig;
    }

    public ServerGroup.InstanceCounts getInstanceCounts() {
        ServerGroup.InstanceCounts counts = new ServerGroup.InstanceCounts();
        counts.setTotal(Integer.valueOf(this.instances.size()));
        counts.setUp(Integer.valueOf(TencentCloudServerGroup.filterInstancesByHealthState(this.instances, HealthState.Up).size()));
        counts.setDown(Integer.valueOf(TencentCloudServerGroup.filterInstancesByHealthState(this.instances, HealthState.Down).size()));
        counts.setUnknown(Integer.valueOf(TencentCloudServerGroup.filterInstancesByHealthState(this.instances, HealthState.Unknown).size()));
        counts.setStarting(Integer.valueOf(TencentCloudServerGroup.filterInstancesByHealthState(this.instances, HealthState.Starting).size()));
        counts.setOutOfService(Integer.valueOf(TencentCloudServerGroup.filterInstancesByHealthState(this.instances, HealthState.OutOfService).size()));
        return counts;
    }

    public ServerGroup.Capacity getCapacity() {
        ServerGroup.Capacity capacity = new ServerGroup.Capacity();
        capacity.setMin(Integer.valueOf(Math.toIntExact(this.asg != null && this.asg.getMinSize() != null ? this.asg.getMinSize() : 0L)));
        capacity.setMax(Integer.valueOf(Math.toIntExact(this.asg != null && this.asg.getMaxSize() != null ? this.asg.getMaxSize() : 0L)));
        capacity.setDesired(Integer.valueOf(Math.toIntExact(this.asg != null && this.asg.getDesiredCapacity() != null ? this.asg.getDesiredCapacity() : 0L)));
        return capacity;
    }

    public ServerGroup.ImagesSummary getImagesSummary() {
        return new ServerGroup.ImagesSummary(){

            public List<ServerGroup.ImageSummary> getSummaries() {
                return new ArrayList<ServerGroup.ImageSummary>(Arrays.asList(new ServerGroup.ImageSummary(){
                    private String serverGroupName;
                    private String imageName;
                    private String imageId;
                    {
                        this.serverGroupName = TencentCloudServerGroup.this.getName();
                        this.imageName = TencentCloudServerGroup.this.image == null ? null : (String)TencentCloudServerGroup.this.image.get("name");
                        this.imageId = TencentCloudServerGroup.this.image == null ? null : (String)TencentCloudServerGroup.this.image.get("imageId");
                    }

                    public Map<String, Object> getBuildInfo() {
                        return TencentCloudServerGroup.this.buildInfo;
                    }

                    public Map<String, Object> getImage() {
                        return TencentCloudServerGroup.this.image;
                    }

                    public String getServerGroupName() {
                        return this.serverGroupName;
                    }

                    public void setServerGroupName(String serverGroupName) {
                        this.serverGroupName = serverGroupName;
                    }

                    public String getImageName() {
                        return this.imageName;
                    }

                    public void setImageName(String imageName) {
                        this.imageName = imageName;
                    }

                    public String getImageId() {
                        return this.imageId;
                    }

                    public void setImageId(String imageId) {
                        this.imageId = imageId;
                    }
                }));
            }
        };
    }

    public ServerGroup.ImageSummary getImageSummary() {
        ServerGroup.ImagesSummary summary = this.getImagesSummary();
        return (ServerGroup.ImageSummary)summary.getSummaries().get(0);
    }

    public static Collection<Instance> filterInstancesByHealthState(Set<TencentCloudInstance> instances, HealthState healthState) {
        return instances.stream().filter(it -> it.getHealthState() == healthState).collect(Collectors.toList());
    }

    @Generated
    public TencentCloudServerGroup() {
    }

    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public Map<String, Object> getImage() {
        return this.image;
    }

    @Generated
    public AutoScalingGroup getAsg() {
        return this.asg;
    }

    @Generated
    public Map getBuildInfo() {
        return this.buildInfo;
    }

    @Generated
    public String getVpcId() {
        return this.vpcId;
    }

    @Generated
    public List<ScalingPolicy> getScalingPolicies() {
        return this.scalingPolicies;
    }

    @Generated
    public List<ScheduledAction> getScheduledActions() {
        return this.scheduledActions;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Generated
    public TencentCloudServerGroup setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setRegion(String region) {
        this.region = region;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setZones(Set<String> zones) {
        this.zones = zones;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setInstances(Set<TencentCloudInstance> instances) {
        this.instances = instances;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setImage(Map<String, Object> image) {
        this.image = image;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setLaunchConfig(Map<String, Object> launchConfig) {
        this.launchConfig = launchConfig;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setAsg(AutoScalingGroup asg) {
        this.asg = asg;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setBuildInfo(Map buildInfo) {
        this.buildInfo = buildInfo;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setScalingPolicies(List<ScalingPolicy> scalingPolicies) {
        this.scalingPolicies = scalingPolicies;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setScheduledActions(List<ScheduledAction> scheduledActions) {
        this.scheduledActions = scheduledActions;
        return this;
    }

    @Generated
    public TencentCloudServerGroup setDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentCloudServerGroup)) {
            return false;
        }
        TencentCloudServerGroup other = (TencentCloudServerGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$cloudProvider = this.getCloudProvider();
        String other$cloudProvider = other.getCloudProvider();
        if (this$cloudProvider == null ? other$cloudProvider != null : !this$cloudProvider.equals(other$cloudProvider)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        Set<String> this$zones = this.getZones();
        Set<String> other$zones = other.getZones();
        if (this$zones == null ? other$zones != null : !((Object)this$zones).equals(other$zones)) {
            return false;
        }
        Set<TencentCloudInstance> this$instances = this.getInstances();
        Set<TencentCloudInstance> other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
            return false;
        }
        Map<String, Object> this$image = this.getImage();
        Map<String, Object> other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        Map<String, Object> this$launchConfig = this.getLaunchConfig();
        Map<String, Object> other$launchConfig = other.getLaunchConfig();
        if (this$launchConfig == null ? other$launchConfig != null : !((Object)this$launchConfig).equals(other$launchConfig)) {
            return false;
        }
        AutoScalingGroup this$asg = this.getAsg();
        AutoScalingGroup other$asg = other.getAsg();
        if (this$asg == null ? other$asg != null : !this$asg.equals(other$asg)) {
            return false;
        }
        Map this$buildInfo = this.getBuildInfo();
        Map other$buildInfo = other.getBuildInfo();
        if (this$buildInfo == null ? other$buildInfo != null : !((Object)this$buildInfo).equals(other$buildInfo)) {
            return false;
        }
        String this$vpcId = this.getVpcId();
        String other$vpcId = other.getVpcId();
        if (this$vpcId == null ? other$vpcId != null : !this$vpcId.equals(other$vpcId)) {
            return false;
        }
        List<ScalingPolicy> this$scalingPolicies = this.getScalingPolicies();
        List<ScalingPolicy> other$scalingPolicies = other.getScalingPolicies();
        if (this$scalingPolicies == null ? other$scalingPolicies != null : !((Object)this$scalingPolicies).equals(other$scalingPolicies)) {
            return false;
        }
        List<ScheduledAction> this$scheduledActions = this.getScheduledActions();
        List<ScheduledAction> other$scheduledActions = other.getScheduledActions();
        return !(this$scheduledActions == null ? other$scheduledActions != null : !((Object)this$scheduledActions).equals(other$scheduledActions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TencentCloudServerGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $cloudProvider = this.getCloudProvider();
        result = result * 59 + ($cloudProvider == null ? 43 : $cloudProvider.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        Set<String> $zones = this.getZones();
        result = result * 59 + ($zones == null ? 43 : ((Object)$zones).hashCode());
        Set<TencentCloudInstance> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        Map<String, Object> $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        Map<String, Object> $launchConfig = this.getLaunchConfig();
        result = result * 59 + ($launchConfig == null ? 43 : ((Object)$launchConfig).hashCode());
        AutoScalingGroup $asg = this.getAsg();
        result = result * 59 + ($asg == null ? 43 : $asg.hashCode());
        Map $buildInfo = this.getBuildInfo();
        result = result * 59 + ($buildInfo == null ? 43 : ((Object)$buildInfo).hashCode());
        String $vpcId = this.getVpcId();
        result = result * 59 + ($vpcId == null ? 43 : $vpcId.hashCode());
        List<ScalingPolicy> $scalingPolicies = this.getScalingPolicies();
        result = result * 59 + ($scalingPolicies == null ? 43 : ((Object)$scalingPolicies).hashCode());
        List<ScheduledAction> $scheduledActions = this.getScheduledActions();
        result = result * 59 + ($scheduledActions == null ? 43 : ((Object)$scheduledActions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TencentCloudServerGroup(type=" + this.getType() + ", cloudProvider=" + this.getCloudProvider() + ", accountName=" + this.getAccountName() + ", name=" + this.getName() + ", region=" + this.getRegion() + ", zones=" + this.getZones() + ", instances=" + this.getInstances() + ", image=" + this.getImage() + ", launchConfig=" + this.getLaunchConfig() + ", asg=" + this.getAsg() + ", buildInfo=" + this.getBuildInfo() + ", vpcId=" + this.getVpcId() + ", scalingPolicies=" + this.getScalingPolicies() + ", scheduledActions=" + this.getScheduledActions() + ", disabled=" + this.getDisabled() + ")";
    }
}

