/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.provider;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentSchedulerAware;
import com.netflix.spinnaker.clouddriver.cache.SearchableProvider;
import com.netflix.spinnaker.clouddriver.tencentcloud.cache.Keys;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class TencentCloudInfrastructureProvider
extends AgentSchedulerAware
implements SearchableProvider {
    private final String providerName = TencentCloudInfrastructureProvider.class.getName();
    private final List<Agent> agents;
    private final Set<String> defaultCaches;
    private final Map<String, String> urlMappingTemplates;
    private final Map<SearchableProvider.SearchableResource, SearchableProvider.SearchResultHydrator> searchResultHydrators;

    public TencentCloudInfrastructureProvider(List<Agent> agents) {
        this.agents = agents;
        List<String> nsList = Arrays.asList(Keys.Namespace.APPLICATIONS.ns, Keys.Namespace.CLUSTERS.ns, Keys.Namespace.INSTANCES.ns, Keys.Namespace.LOAD_BALANCERS.ns, Keys.Namespace.SECURITY_GROUPS.ns, Keys.Namespace.SERVER_GROUPS.ns);
        this.defaultCaches = new HashSet<String>();
        this.defaultCaches.addAll(nsList);
        this.urlMappingTemplates = new HashMap<String, String>();
        this.urlMappingTemplates.put(Keys.Namespace.SECURITY_GROUPS.ns, "/securityGroups/$account/$provider/$name?region=$region");
        this.searchResultHydrators = new HashMap<SearchableProvider.SearchableResource, SearchableProvider.SearchResultHydrator>();
    }

    public Map<String, String> parseKey(String key) {
        return Keys.parse(key);
    }

    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @Generated
    public List<Agent> getAgents() {
        return this.agents;
    }

    @Generated
    public Set<String> getDefaultCaches() {
        return this.defaultCaches;
    }

    @Generated
    public Map<String, String> getUrlMappingTemplates() {
        return this.urlMappingTemplates;
    }

    @Generated
    public Map<SearchableProvider.SearchableResource, SearchableProvider.SearchResultHydrator> getSearchResultHydrators() {
        return this.searchResultHydrators;
    }
}

