/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.provider.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.clouddriver.tencentcloud.provider.TencentCloudInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.tencentcloud.security.TencentCloudNamedAccountCredentials;
import java.util.Map;

public abstract class AbstractTencentCloudCachingAgent
implements CachingAgent,
AccountAware {
    private final ObjectMapper objectMapper;
    private final String region;
    private final String accountName;
    private final TencentCloudNamedAccountCredentials credentials;
    private final String providerName = TencentCloudInfrastructureProvider.class.getName();
    final TypeReference<Map<String, Object>> ATTRIBUTES = new TypeReference<Map<String, Object>>(){};

    public AbstractTencentCloudCachingAgent(TencentCloudNamedAccountCredentials credentials, ObjectMapper objectMapper, String region) {
        this.credentials = credentials;
        this.objectMapper = objectMapper;
        this.region = region;
        this.accountName = credentials.getName();
    }

    public String getAgentType() {
        return this.getAccountName() + "/" + this.getRegion() + "/" + this.getClass().getSimpleName();
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public final String getRegion() {
        return this.region;
    }

    public final String getAccountName() {
        return this.accountName;
    }

    public final TencentCloudNamedAccountCredentials getCredentials() {
        return this.credentials;
    }

    public final String getProviderName() {
        return this.providerName;
    }
}

