/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.security;

import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.clouddriver.tencentcloud.config.TencentCloudConfigurationProperties;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudBasicResource;
import com.netflix.spinnaker.clouddriver.tencentcloud.names.TencentCloudBasicResourceNamer;
import com.netflix.spinnaker.clouddriver.tencentcloud.security.TencentCloudCredentials;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import com.netflix.spinnaker.moniker.Namer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TencentCloudNamedAccountCredentials
extends AbstractAccountCredentials<TencentCloudCredentials> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TencentCloudNamedAccountCredentials.class);
    private String name;
    private String environment;
    private String accountType;
    private TencentCloudCredentials credentials;
    private List<TencentCloudRegion> regions;
    private List<String> requiredGroupMembership;
    private Permissions permissions;
    private Namer<TencentCloudBasicResource> namer = new TencentCloudBasicResourceNamer();

    public TencentCloudNamedAccountCredentials(TencentCloudConfigurationProperties.ManagedAccount managedAccount) {
        this.name = managedAccount.getName();
        this.environment = managedAccount.getEnvironment();
        this.accountType = managedAccount.getAccountType();
        this.credentials = new TencentCloudCredentials(managedAccount.getSecretId(), managedAccount.getSecretKey());
        this.regions = TencentCloudNamedAccountCredentials.buildRegions(managedAccount.getRegions());
        NamerRegistry.lookup().withProvider("tencentcloud").withAccount(this.name).setNamer(TencentCloudBasicResource.class, this.namer);
    }

    private static List<TencentCloudRegion> buildRegions(List<String> regions) {
        if (CollectionUtils.isEmpty(regions)) {
            return new ArrayList<TencentCloudRegion>();
        }
        return regions.stream().map(TencentCloudRegion::new).collect(Collectors.toList());
    }

    public String getCloudProvider() {
        return "tencentcloud";
    }

    public List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public String getAccountType() {
        return this.accountType;
    }

    @Generated
    public TencentCloudCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public List<TencentCloudRegion> getRegions() {
        return this.regions;
    }

    @Generated
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Generated
    public Namer<TencentCloudBasicResource> getNamer() {
        return this.namer;
    }

    @Generated
    public TencentCloudNamedAccountCredentials setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public TencentCloudNamedAccountCredentials setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    @Generated
    public TencentCloudNamedAccountCredentials setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Generated
    public TencentCloudNamedAccountCredentials setCredentials(TencentCloudCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Generated
    public TencentCloudNamedAccountCredentials setRegions(List<TencentCloudRegion> regions) {
        this.regions = regions;
        return this;
    }

    @Generated
    public TencentCloudNamedAccountCredentials setRequiredGroupMembership(List<String> requiredGroupMembership) {
        this.requiredGroupMembership = requiredGroupMembership;
        return this;
    }

    @Generated
    public TencentCloudNamedAccountCredentials setPermissions(Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    @Generated
    public TencentCloudNamedAccountCredentials setNamer(Namer<TencentCloudBasicResource> namer) {
        this.namer = namer;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentCloudNamedAccountCredentials)) {
            return false;
        }
        TencentCloudNamedAccountCredentials other = (TencentCloudNamedAccountCredentials)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        TencentCloudCredentials this$credentials = this.getCredentials();
        TencentCloudCredentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        List<TencentCloudRegion> this$regions = this.getRegions();
        List<TencentCloudRegion> other$regions = other.getRegions();
        if (this$regions == null ? other$regions != null : !((Object)this$regions).equals(other$regions)) {
            return false;
        }
        List<String> this$requiredGroupMembership = this.getRequiredGroupMembership();
        List<String> other$requiredGroupMembership = other.getRequiredGroupMembership();
        if (this$requiredGroupMembership == null ? other$requiredGroupMembership != null : !((Object)this$requiredGroupMembership).equals(other$requiredGroupMembership)) {
            return false;
        }
        Permissions this$permissions = this.getPermissions();
        Permissions other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) {
            return false;
        }
        Namer<TencentCloudBasicResource> this$namer = this.getNamer();
        Namer<TencentCloudBasicResource> other$namer = other.getNamer();
        return !(this$namer == null ? other$namer != null : !this$namer.equals(other$namer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TencentCloudNamedAccountCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        TencentCloudCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        List<TencentCloudRegion> $regions = this.getRegions();
        result = result * 59 + ($regions == null ? 43 : ((Object)$regions).hashCode());
        List<String> $requiredGroupMembership = this.getRequiredGroupMembership();
        result = result * 59 + ($requiredGroupMembership == null ? 43 : ((Object)$requiredGroupMembership).hashCode());
        Permissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
        Namer<TencentCloudBasicResource> $namer = this.getNamer();
        result = result * 59 + ($namer == null ? 43 : $namer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TencentCloudNamedAccountCredentials(name=" + this.getName() + ", environment=" + this.getEnvironment() + ", accountType=" + this.getAccountType() + ", credentials=" + this.getCredentials() + ", regions=" + this.getRegions() + ", requiredGroupMembership=" + this.getRequiredGroupMembership() + ", permissions=" + this.getPermissions() + ", namer=" + this.getNamer() + ")";
    }

    public static final class TencentCloudRegion {
        @Nonnull
        private final String name;

        @Nonnull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public TencentCloudRegion(@Nonnull String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }
}

