/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudBasicResource;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudInstanceHealth;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudTargetHealth;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class TencentCloudInstance
implements Instance,
TencentCloudBasicResource {
    private final String cloudProvider = "tencentcloud";
    private final String providerType = "tencentcloud";
    private String instanceName;
    private String account;
    private String name;
    private Long launchTime;
    private String zone;
    private TencentCloudInstanceHealth instanceHealth;
    private TencentCloudTargetHealth targetHealth;
    private String vpcId;
    private String subnetId;
    private List<String> privateIpAddresses = new ArrayList<String>();
    private List<String> publicIpAddresses = new ArrayList<String>();
    private String instanceType;
    private String imageId;
    private List<String> securityGroupIds = new ArrayList<String>();
    private List<Map<String, String>> tags = new ArrayList<Map<String, String>>();
    private String serverGroupName;

    public String getHumanReadableName() {
        return this.instanceName;
    }

    @Override
    @JsonIgnore
    public String getMonikerName() {
        return this.serverGroupName;
    }

    public List<Map<String, Object>> getHealth() {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<Map<String, Object>> healths = new ArrayList<Map<String, Object>>();
        if (this.instanceHealth != null) {
            healths.add((Map)objectMapper.convertValue((Object)this.instanceHealth, Map.class));
        }
        if (this.targetHealth != null) {
            healths.add((Map)objectMapper.convertValue((Object)this.targetHealth, Map.class));
        }
        return healths;
    }

    public HealthState getHealthState() {
        if (TencentCloudInstance.someUpRemainingUnknown(this.getHealth())) {
            return HealthState.Up;
        }
        if (TencentCloudInstance.anyStarting(this.getHealth())) {
            return HealthState.Starting;
        }
        if (TencentCloudInstance.anyDown(this.getHealth())) {
            return HealthState.Down;
        }
        if (TencentCloudInstance.anyOutOfService(this.getHealth())) {
            return HealthState.OutOfService;
        }
        return HealthState.Unknown;
    }

    public Moniker getMoniker() {
        return NamerRegistry.lookup().withProvider("tencentcloud").withAccount(this.account).withResource(TencentCloudBasicResource.class).deriveMoniker((Object)this);
    }

    private static boolean someUpRemainingUnknown(List<Map<String, Object>> healthList) {
        List knownHealthList = healthList.stream().filter(it -> HealthState.fromString((String)((String)it.get("state"))) != HealthState.Unknown).collect(Collectors.toList());
        return knownHealthList.stream().allMatch(knownHealth -> knownHealth.get("state").equals(HealthState.Up.toString()));
    }

    private static boolean anyStarting(List<Map<String, Object>> healthList) {
        return healthList.stream().anyMatch(health -> health.get("state").equals(HealthState.Starting.toString()));
    }

    private static boolean anyDown(List<Map<String, Object>> healthList) {
        return healthList.stream().anyMatch(health -> health.get("state").equals(HealthState.Down.toString()));
    }

    private static boolean anyOutOfService(List<Map<String, Object>> healthList) {
        return healthList.stream().anyMatch(health -> health.get("state").equals(HealthState.OutOfService.toString()));
    }

    @Generated
    public TencentCloudInstance() {
    }

    @Generated
    public String getCloudProvider() {
        Objects.requireNonNull(this);
        return "tencentcloud";
    }

    @Generated
    public String getProviderType() {
        Objects.requireNonNull(this);
        return "tencentcloud";
    }

    @Generated
    public String getInstanceName() {
        return this.instanceName;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getLaunchTime() {
        return this.launchTime;
    }

    @Generated
    public String getZone() {
        return this.zone;
    }

    @Generated
    public TencentCloudInstanceHealth getInstanceHealth() {
        return this.instanceHealth;
    }

    @Generated
    public TencentCloudTargetHealth getTargetHealth() {
        return this.targetHealth;
    }

    @Generated
    public String getVpcId() {
        return this.vpcId;
    }

    @Generated
    public String getSubnetId() {
        return this.subnetId;
    }

    @Generated
    public List<String> getPrivateIpAddresses() {
        return this.privateIpAddresses;
    }

    @Generated
    public List<String> getPublicIpAddresses() {
        return this.publicIpAddresses;
    }

    @Generated
    public String getInstanceType() {
        return this.instanceType;
    }

    @Generated
    public String getImageId() {
        return this.imageId;
    }

    @Generated
    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    @Generated
    public List<Map<String, String>> getTags() {
        return this.tags;
    }

    @Generated
    public String getServerGroupName() {
        return this.serverGroupName;
    }

    @Generated
    public TencentCloudInstance setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    @Generated
    public TencentCloudInstance setAccount(String account) {
        this.account = account;
        return this;
    }

    @Generated
    public TencentCloudInstance setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public TencentCloudInstance setLaunchTime(Long launchTime) {
        this.launchTime = launchTime;
        return this;
    }

    @Generated
    public TencentCloudInstance setZone(String zone) {
        this.zone = zone;
        return this;
    }

    @Generated
    public TencentCloudInstance setInstanceHealth(TencentCloudInstanceHealth instanceHealth) {
        this.instanceHealth = instanceHealth;
        return this;
    }

    @Generated
    public TencentCloudInstance setTargetHealth(TencentCloudTargetHealth targetHealth) {
        this.targetHealth = targetHealth;
        return this;
    }

    @Generated
    public TencentCloudInstance setVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    @Generated
    public TencentCloudInstance setSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    @Generated
    public TencentCloudInstance setPrivateIpAddresses(List<String> privateIpAddresses) {
        this.privateIpAddresses = privateIpAddresses;
        return this;
    }

    @Generated
    public TencentCloudInstance setPublicIpAddresses(List<String> publicIpAddresses) {
        this.publicIpAddresses = publicIpAddresses;
        return this;
    }

    @Generated
    public TencentCloudInstance setInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    @Generated
    public TencentCloudInstance setImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    @Generated
    public TencentCloudInstance setSecurityGroupIds(List<String> securityGroupIds) {
        this.securityGroupIds = securityGroupIds;
        return this;
    }

    @Generated
    public TencentCloudInstance setTags(List<Map<String, String>> tags) {
        this.tags = tags;
        return this;
    }

    @Generated
    public TencentCloudInstance setServerGroupName(String serverGroupName) {
        this.serverGroupName = serverGroupName;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentCloudInstance)) {
            return false;
        }
        TencentCloudInstance other = (TencentCloudInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$launchTime = this.getLaunchTime();
        Long other$launchTime = other.getLaunchTime();
        if (this$launchTime == null ? other$launchTime != null : !((Object)this$launchTime).equals(other$launchTime)) {
            return false;
        }
        String this$cloudProvider = this.getCloudProvider();
        String other$cloudProvider = other.getCloudProvider();
        if (this$cloudProvider == null ? other$cloudProvider != null : !this$cloudProvider.equals(other$cloudProvider)) {
            return false;
        }
        String this$providerType = this.getProviderType();
        String other$providerType = other.getProviderType();
        if (this$providerType == null ? other$providerType != null : !this$providerType.equals(other$providerType)) {
            return false;
        }
        String this$instanceName = this.getInstanceName();
        String other$instanceName = other.getInstanceName();
        if (this$instanceName == null ? other$instanceName != null : !this$instanceName.equals(other$instanceName)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$zone = this.getZone();
        String other$zone = other.getZone();
        if (this$zone == null ? other$zone != null : !this$zone.equals(other$zone)) {
            return false;
        }
        TencentCloudInstanceHealth this$instanceHealth = this.getInstanceHealth();
        TencentCloudInstanceHealth other$instanceHealth = other.getInstanceHealth();
        if (this$instanceHealth == null ? other$instanceHealth != null : !((Object)this$instanceHealth).equals(other$instanceHealth)) {
            return false;
        }
        TencentCloudTargetHealth this$targetHealth = this.getTargetHealth();
        TencentCloudTargetHealth other$targetHealth = other.getTargetHealth();
        if (this$targetHealth == null ? other$targetHealth != null : !((Object)this$targetHealth).equals(other$targetHealth)) {
            return false;
        }
        String this$vpcId = this.getVpcId();
        String other$vpcId = other.getVpcId();
        if (this$vpcId == null ? other$vpcId != null : !this$vpcId.equals(other$vpcId)) {
            return false;
        }
        String this$subnetId = this.getSubnetId();
        String other$subnetId = other.getSubnetId();
        if (this$subnetId == null ? other$subnetId != null : !this$subnetId.equals(other$subnetId)) {
            return false;
        }
        List<String> this$privateIpAddresses = this.getPrivateIpAddresses();
        List<String> other$privateIpAddresses = other.getPrivateIpAddresses();
        if (this$privateIpAddresses == null ? other$privateIpAddresses != null : !((Object)this$privateIpAddresses).equals(other$privateIpAddresses)) {
            return false;
        }
        List<String> this$publicIpAddresses = this.getPublicIpAddresses();
        List<String> other$publicIpAddresses = other.getPublicIpAddresses();
        if (this$publicIpAddresses == null ? other$publicIpAddresses != null : !((Object)this$publicIpAddresses).equals(other$publicIpAddresses)) {
            return false;
        }
        String this$instanceType = this.getInstanceType();
        String other$instanceType = other.getInstanceType();
        if (this$instanceType == null ? other$instanceType != null : !this$instanceType.equals(other$instanceType)) {
            return false;
        }
        String this$imageId = this.getImageId();
        String other$imageId = other.getImageId();
        if (this$imageId == null ? other$imageId != null : !this$imageId.equals(other$imageId)) {
            return false;
        }
        List<String> this$securityGroupIds = this.getSecurityGroupIds();
        List<String> other$securityGroupIds = other.getSecurityGroupIds();
        if (this$securityGroupIds == null ? other$securityGroupIds != null : !((Object)this$securityGroupIds).equals(other$securityGroupIds)) {
            return false;
        }
        List<Map<String, String>> this$tags = this.getTags();
        List<Map<String, String>> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$serverGroupName = this.getServerGroupName();
        String other$serverGroupName = other.getServerGroupName();
        return !(this$serverGroupName == null ? other$serverGroupName != null : !this$serverGroupName.equals(other$serverGroupName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TencentCloudInstance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $launchTime = this.getLaunchTime();
        result = result * 59 + ($launchTime == null ? 43 : ((Object)$launchTime).hashCode());
        String $cloudProvider = this.getCloudProvider();
        result = result * 59 + ($cloudProvider == null ? 43 : $cloudProvider.hashCode());
        String $providerType = this.getProviderType();
        result = result * 59 + ($providerType == null ? 43 : $providerType.hashCode());
        String $instanceName = this.getInstanceName();
        result = result * 59 + ($instanceName == null ? 43 : $instanceName.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $zone = this.getZone();
        result = result * 59 + ($zone == null ? 43 : $zone.hashCode());
        TencentCloudInstanceHealth $instanceHealth = this.getInstanceHealth();
        result = result * 59 + ($instanceHealth == null ? 43 : ((Object)$instanceHealth).hashCode());
        TencentCloudTargetHealth $targetHealth = this.getTargetHealth();
        result = result * 59 + ($targetHealth == null ? 43 : ((Object)$targetHealth).hashCode());
        String $vpcId = this.getVpcId();
        result = result * 59 + ($vpcId == null ? 43 : $vpcId.hashCode());
        String $subnetId = this.getSubnetId();
        result = result * 59 + ($subnetId == null ? 43 : $subnetId.hashCode());
        List<String> $privateIpAddresses = this.getPrivateIpAddresses();
        result = result * 59 + ($privateIpAddresses == null ? 43 : ((Object)$privateIpAddresses).hashCode());
        List<String> $publicIpAddresses = this.getPublicIpAddresses();
        result = result * 59 + ($publicIpAddresses == null ? 43 : ((Object)$publicIpAddresses).hashCode());
        String $instanceType = this.getInstanceType();
        result = result * 59 + ($instanceType == null ? 43 : $instanceType.hashCode());
        String $imageId = this.getImageId();
        result = result * 59 + ($imageId == null ? 43 : $imageId.hashCode());
        List<String> $securityGroupIds = this.getSecurityGroupIds();
        result = result * 59 + ($securityGroupIds == null ? 43 : ((Object)$securityGroupIds).hashCode());
        List<Map<String, String>> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $serverGroupName = this.getServerGroupName();
        result = result * 59 + ($serverGroupName == null ? 43 : $serverGroupName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TencentCloudInstance(cloudProvider=" + this.getCloudProvider() + ", providerType=" + this.getProviderType() + ", instanceName=" + this.getInstanceName() + ", account=" + this.getAccount() + ", name=" + this.getName() + ", launchTime=" + this.getLaunchTime() + ", zone=" + this.getZone() + ", instanceHealth=" + this.getInstanceHealth() + ", targetHealth=" + this.getTargetHealth() + ", vpcId=" + this.getVpcId() + ", subnetId=" + this.getSubnetId() + ", privateIpAddresses=" + this.getPrivateIpAddresses() + ", publicIpAddresses=" + this.getPublicIpAddresses() + ", instanceType=" + this.getInstanceType() + ", imageId=" + this.getImageId() + ", securityGroupIds=" + this.getSecurityGroupIds() + ", tags=" + this.getTags() + ", serverGroupName=" + this.getServerGroupName() + ")";
    }
}

