/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.netflix.spinnaker.clouddriver.model.SecurityGroup;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupSummary;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudSecurityGroupRule;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudSecurityGroupSummary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class TencentCloudSecurityGroup
implements SecurityGroup {
    private final String type = "tencentcloud";
    private final String cloudProvider = "tencentcloud";
    private String id;
    private String name;
    private String description;
    private String application;
    private String accountName;
    private String region;
    private Set<Rule> inboundRules = new HashSet<Rule>();
    private Set<Rule> outboundRules = new HashSet<Rule>();
    private List<TencentCloudSecurityGroupRule> inRules = new ArrayList<TencentCloudSecurityGroupRule>();
    private List<TencentCloudSecurityGroupRule> outRules = new ArrayList<TencentCloudSecurityGroupRule>();

    public TencentCloudSecurityGroup(String id, String name, String description, String application, String accountName, String region, Set<Rule> inboundRules, Set<Rule> outboundRules, List<TencentCloudSecurityGroupRule> inRules, List<TencentCloudSecurityGroupRule> outRules) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.application = application;
        this.accountName = accountName;
        this.region = region;
        this.inboundRules.addAll(inboundRules);
        this.outboundRules.addAll(outboundRules);
        this.inRules.addAll(inRules);
        this.outRules.addAll(outRules);
    }

    public SecurityGroupSummary getSummary() {
        return new TencentCloudSecurityGroupSummary(this.name, this.id);
    }

    @Generated
    public String getType() {
        Objects.requireNonNull(this);
        return "tencentcloud";
    }

    @Generated
    public String getCloudProvider() {
        Objects.requireNonNull(this);
        return "tencentcloud";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public Set<Rule> getInboundRules() {
        return this.inboundRules;
    }

    @Generated
    public Set<Rule> getOutboundRules() {
        return this.outboundRules;
    }

    @Generated
    public List<TencentCloudSecurityGroupRule> getInRules() {
        return this.inRules;
    }

    @Generated
    public List<TencentCloudSecurityGroupRule> getOutRules() {
        return this.outRules;
    }

    @Generated
    public TencentCloudSecurityGroup setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setApplication(String application) {
        this.application = application;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setRegion(String region) {
        this.region = region;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setInboundRules(Set<Rule> inboundRules) {
        this.inboundRules = inboundRules;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setOutboundRules(Set<Rule> outboundRules) {
        this.outboundRules = outboundRules;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setInRules(List<TencentCloudSecurityGroupRule> inRules) {
        this.inRules = inRules;
        return this;
    }

    @Generated
    public TencentCloudSecurityGroup setOutRules(List<TencentCloudSecurityGroupRule> outRules) {
        this.outRules = outRules;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentCloudSecurityGroup)) {
            return false;
        }
        TencentCloudSecurityGroup other = (TencentCloudSecurityGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$cloudProvider = this.getCloudProvider();
        String other$cloudProvider = other.getCloudProvider();
        if (this$cloudProvider == null ? other$cloudProvider != null : !this$cloudProvider.equals(other$cloudProvider)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        Set<Rule> this$inboundRules = this.getInboundRules();
        Set<Rule> other$inboundRules = other.getInboundRules();
        if (this$inboundRules == null ? other$inboundRules != null : !((Object)this$inboundRules).equals(other$inboundRules)) {
            return false;
        }
        Set<Rule> this$outboundRules = this.getOutboundRules();
        Set<Rule> other$outboundRules = other.getOutboundRules();
        if (this$outboundRules == null ? other$outboundRules != null : !((Object)this$outboundRules).equals(other$outboundRules)) {
            return false;
        }
        List<TencentCloudSecurityGroupRule> this$inRules = this.getInRules();
        List<TencentCloudSecurityGroupRule> other$inRules = other.getInRules();
        if (this$inRules == null ? other$inRules != null : !((Object)this$inRules).equals(other$inRules)) {
            return false;
        }
        List<TencentCloudSecurityGroupRule> this$outRules = this.getOutRules();
        List<TencentCloudSecurityGroupRule> other$outRules = other.getOutRules();
        return !(this$outRules == null ? other$outRules != null : !((Object)this$outRules).equals(other$outRules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TencentCloudSecurityGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $cloudProvider = this.getCloudProvider();
        result = result * 59 + ($cloudProvider == null ? 43 : $cloudProvider.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        Set<Rule> $inboundRules = this.getInboundRules();
        result = result * 59 + ($inboundRules == null ? 43 : ((Object)$inboundRules).hashCode());
        Set<Rule> $outboundRules = this.getOutboundRules();
        result = result * 59 + ($outboundRules == null ? 43 : ((Object)$outboundRules).hashCode());
        List<TencentCloudSecurityGroupRule> $inRules = this.getInRules();
        result = result * 59 + ($inRules == null ? 43 : ((Object)$inRules).hashCode());
        List<TencentCloudSecurityGroupRule> $outRules = this.getOutRules();
        result = result * 59 + ($outRules == null ? 43 : ((Object)$outRules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TencentCloudSecurityGroup(type=" + this.getType() + ", cloudProvider=" + this.getCloudProvider() + ", id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", application=" + this.getApplication() + ", accountName=" + this.getAccountName() + ", region=" + this.getRegion() + ", inboundRules=" + this.getInboundRules() + ", outboundRules=" + this.getOutboundRules() + ", inRules=" + this.getInRules() + ", outRules=" + this.getOutRules() + ")";
    }
}

