/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.model.loadbalancer;

import com.netflix.spinnaker.clouddriver.model.LoadBalancer;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerServerGroup;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.TencentCloudBasicResource;
import com.netflix.spinnaker.clouddriver.tencentcloud.model.loadbalancer.TencentCloudLoadBalancerListener;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class TencentCloudLoadBalancer
implements LoadBalancer,
TencentCloudBasicResource {
    private final String cloudProvider = "tencentcloud";
    private final String type = "tencentcloud";
    private String application;
    private String accountName;
    private String region;
    private String id;
    private String name;
    private String loadBalancerId;
    private String loadBalancerName;
    private String loadBalancerType;
    private Integer forwardType;
    private String vpcId;
    private String subnetId;
    private Integer projectId;
    private String createTime;
    private List<String> loadBalancerVips;
    private List<String> securityGroups;
    private List<TencentCloudLoadBalancerListener> listeners;
    private Set<LoadBalancerServerGroup> serverGroups;

    public String getAccount() {
        return this.accountName;
    }

    public Moniker getMoniker() {
        return NamerRegistry.lookup().withProvider("tencentcloud").withAccount(this.accountName).withResource(TencentCloudBasicResource.class).deriveMoniker((Object)this);
    }

    @Override
    public String getMonikerName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TencentCloudLoadBalancer)) {
            return false;
        }
        TencentCloudLoadBalancer other = (TencentCloudLoadBalancer)o;
        return other.getAccount().equals(this.getAccount()) && other.getName().equals(this.getName()) && other.getType().equals(this.getType()) && other.getId().equals(this.getId()) && other.getRegion().equals(this.getRegion());
    }

    public int hashCode() {
        return this.getId().hashCode() + this.getType().hashCode();
    }

    @Generated
    public TencentCloudLoadBalancer() {
    }

    @Generated
    public String getCloudProvider() {
        Objects.requireNonNull(this);
        return "tencentcloud";
    }

    @Generated
    public String getType() {
        Objects.requireNonNull(this);
        return "tencentcloud";
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    @Generated
    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    @Generated
    public String getLoadBalancerType() {
        return this.loadBalancerType;
    }

    @Generated
    public Integer getForwardType() {
        return this.forwardType;
    }

    @Generated
    public String getVpcId() {
        return this.vpcId;
    }

    @Generated
    public String getSubnetId() {
        return this.subnetId;
    }

    @Generated
    public Integer getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getCreateTime() {
        return this.createTime;
    }

    @Generated
    public List<String> getLoadBalancerVips() {
        return this.loadBalancerVips;
    }

    @Generated
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Generated
    public List<TencentCloudLoadBalancerListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public Set<LoadBalancerServerGroup> getServerGroups() {
        return this.serverGroups;
    }

    @Generated
    public TencentCloudLoadBalancer setApplication(String application) {
        this.application = application;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setRegion(String region) {
        this.region = region;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setLoadBalancerId(String loadBalancerId) {
        this.loadBalancerId = loadBalancerId;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setLoadBalancerType(String loadBalancerType) {
        this.loadBalancerType = loadBalancerType;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setForwardType(Integer forwardType) {
        this.forwardType = forwardType;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setProjectId(Integer projectId) {
        this.projectId = projectId;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setLoadBalancerVips(List<String> loadBalancerVips) {
        this.loadBalancerVips = loadBalancerVips;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setListeners(List<TencentCloudLoadBalancerListener> listeners) {
        this.listeners = listeners;
        return this;
    }

    @Generated
    public TencentCloudLoadBalancer setServerGroups(Set<LoadBalancerServerGroup> serverGroups) {
        this.serverGroups = serverGroups;
        return this;
    }

    @Generated
    public String toString() {
        return "TencentCloudLoadBalancer(cloudProvider=" + this.getCloudProvider() + ", type=" + this.getType() + ", application=" + this.getApplication() + ", accountName=" + this.getAccountName() + ", region=" + this.getRegion() + ", id=" + this.getId() + ", name=" + this.getName() + ", loadBalancerId=" + this.getLoadBalancerId() + ", loadBalancerName=" + this.getLoadBalancerName() + ", loadBalancerType=" + this.getLoadBalancerType() + ", forwardType=" + this.getForwardType() + ", vpcId=" + this.getVpcId() + ", subnetId=" + this.getSubnetId() + ", projectId=" + this.getProjectId() + ", createTime=" + this.getCreateTime() + ", loadBalancerVips=" + this.getLoadBalancerVips() + ", securityGroups=" + this.getSecurityGroups() + ", listeners=" + this.getListeners() + ", serverGroups=" + this.getServerGroups() + ")";
    }
}

