/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.client;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTencentCloudServiceClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTencentCloudServiceClient.class);
    public static final long MAX_QUERY_TIME = 1000L;
    public static final long DEFAULT_LIMIT = 100L;
    private Credential credential;
    private HttpProfile httpProfile;
    private ClientProfile clientProfile;

    public abstract String getEndPoint();

    public AbstractTencentCloudServiceClient(String secretId, String secretKey) {
        this.credential = new Credential(secretId, secretKey);
        this.httpProfile = new HttpProfile();
        this.httpProfile.setEndpoint(this.getEndPoint());
        this.clientProfile = new ClientProfile();
        this.clientProfile.setHttpProfile(this.httpProfile);
    }

    public static Date convertToIsoDateTime(String isoDateTime) {
        try {
            DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
            TemporalAccessor accessor = timeFormatter.parse(isoDateTime);
            return Date.from(Instant.from(accessor));
        }
        catch (Exception e) {
            log.warn("convert time error " + e.toString());
            return null;
        }
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public HttpProfile getHttpProfile() {
        return this.httpProfile;
    }

    public void setHttpProfile(HttpProfile httpProfile) {
        this.httpProfile = httpProfile;
    }

    public ClientProfile getClientProfile() {
        return this.clientProfile;
    }

    public void setClientProfile(ClientProfile clientProfile) {
        this.clientProfile = clientProfile;
    }
}

