/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.security;

import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.clouddriver.security.CredentialsInitializerSynchronizable;
import com.netflix.spinnaker.clouddriver.tencentcloud.config.TencentCloudConfigurationProperties;
import com.netflix.spinnaker.clouddriver.tencentcloud.security.TencentCloudNamedAccountCredentials;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TencentCloudCredentialsInitializer
implements CredentialsInitializerSynchronizable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TencentCloudCredentialsInitializer.class);

    @Bean
    public List<TencentCloudNamedAccountCredentials> tencentCloudNamedAccountCredentials(TencentCloudConfigurationProperties tencentCloudConfigurationProperties, AccountCredentialsRepository accountCredentialsRepository) {
        return this.syncAccounts(tencentCloudConfigurationProperties, accountCredentialsRepository);
    }

    private List<TencentCloudNamedAccountCredentials> syncAccounts(TencentCloudConfigurationProperties tencentCloudConfigurationProperties, AccountCredentialsRepository accountCredentialsRepository) {
        ArrayList<TencentCloudNamedAccountCredentials> credentialsList = new ArrayList<TencentCloudNamedAccountCredentials>();
        tencentCloudConfigurationProperties.getAccounts().forEach(managedAccount -> {
            TencentCloudNamedAccountCredentials credentials = new TencentCloudNamedAccountCredentials((TencentCloudConfigurationProperties.ManagedAccount)managedAccount);
            accountCredentialsRepository.save(managedAccount.getName(), (AccountCredentials)credentials);
            credentialsList.add(credentials);
        });
        return credentialsList;
    }
}

