/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.tencentcloud.model;

import com.netflix.spinnaker.clouddriver.model.Health;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class TencentCloudTargetHealth
implements Health {
    private TargetHealthStatus targetHealthStatus;
    private List<LBHealthSummary> loadBalancers = new ArrayList<LBHealthSummary>();

    public TencentCloudTargetHealth(boolean healthStatus) {
        this.targetHealthStatus = healthStatus ? TargetHealthStatus.HEALTHY : TargetHealthStatus.UNHEALTHY;
    }

    public TencentCloudTargetHealth() {
        this.targetHealthStatus = TargetHealthStatus.UNKNOWN;
    }

    public HealthState getState() {
        switch (this.targetHealthStatus) {
            case UNHEALTHY: 
            case UNKNOWN: {
                return HealthState.Down;
            }
            case HEALTHY: {
                return HealthState.Up;
            }
        }
        return HealthState.Unknown;
    }

    public final String getType() {
        return "LoadBalancer";
    }

    @Generated
    public TargetHealthStatus getTargetHealthStatus() {
        return this.targetHealthStatus;
    }

    @Generated
    public List<LBHealthSummary> getLoadBalancers() {
        return this.loadBalancers;
    }

    @Generated
    public TencentCloudTargetHealth setTargetHealthStatus(TargetHealthStatus targetHealthStatus) {
        this.targetHealthStatus = targetHealthStatus;
        return this;
    }

    @Generated
    public TencentCloudTargetHealth setLoadBalancers(List<LBHealthSummary> loadBalancers) {
        this.loadBalancers = loadBalancers;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentCloudTargetHealth)) {
            return false;
        }
        TencentCloudTargetHealth other = (TencentCloudTargetHealth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TargetHealthStatus this$targetHealthStatus = this.getTargetHealthStatus();
        TargetHealthStatus other$targetHealthStatus = other.getTargetHealthStatus();
        if (this$targetHealthStatus == null ? other$targetHealthStatus != null : !((Object)((Object)this$targetHealthStatus)).equals((Object)other$targetHealthStatus)) {
            return false;
        }
        List<LBHealthSummary> this$loadBalancers = this.getLoadBalancers();
        List<LBHealthSummary> other$loadBalancers = other.getLoadBalancers();
        return !(this$loadBalancers == null ? other$loadBalancers != null : !((Object)this$loadBalancers).equals(other$loadBalancers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TencentCloudTargetHealth;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TargetHealthStatus $targetHealthStatus = this.getTargetHealthStatus();
        result = result * 59 + ($targetHealthStatus == null ? 43 : ((Object)((Object)$targetHealthStatus)).hashCode());
        List<LBHealthSummary> $loadBalancers = this.getLoadBalancers();
        result = result * 59 + ($loadBalancers == null ? 43 : ((Object)$loadBalancers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TencentCloudTargetHealth(targetHealthStatus=" + this.getTargetHealthStatus() + ", loadBalancers=" + this.getLoadBalancers() + ")";
    }

    public static enum TargetHealthStatus {
        UNHEALTHY,
        HEALTHY,
        UNKNOWN;


        public LBHealthSummary.ServiceStatus toServiceStatus() {
            if (this == HEALTHY) {
                return LBHealthSummary.ServiceStatus.InService;
            }
            return LBHealthSummary.ServiceStatus.OutOfService;
        }
    }

    public static class LBHealthSummary {
        private String loadBalancerName;
        private ServiceStatus state;

        public String getDescription() {
            return this.state.equals((Object)ServiceStatus.OutOfService) ? "Instance has failed at least the Unhealthy Threshold number of health checks consecutively." : "Healthy";
        }

        @Generated
        public LBHealthSummary() {
        }

        @Generated
        public String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Generated
        public ServiceStatus getState() {
            return this.state;
        }

        @Generated
        public LBHealthSummary setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        @Generated
        public LBHealthSummary setState(ServiceStatus state) {
            this.state = state;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LBHealthSummary)) {
                return false;
            }
            LBHealthSummary other = (LBHealthSummary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$loadBalancerName = this.getLoadBalancerName();
            String other$loadBalancerName = other.getLoadBalancerName();
            if (this$loadBalancerName == null ? other$loadBalancerName != null : !this$loadBalancerName.equals(other$loadBalancerName)) {
                return false;
            }
            ServiceStatus this$state = this.getState();
            ServiceStatus other$state = other.getState();
            return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LBHealthSummary;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $loadBalancerName = this.getLoadBalancerName();
            result = result * 59 + ($loadBalancerName == null ? 43 : $loadBalancerName.hashCode());
            ServiceStatus $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TencentCloudTargetHealth.LBHealthSummary(loadBalancerName=" + this.getLoadBalancerName() + ", state=" + this.getState() + ")";
        }

        public static enum ServiceStatus {
            InService,
            OutOfService;

        }
    }
}

