/*
 * Copyright 2016 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.netflix.spinnaker.echo.model.trigger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GitEvent extends TriggerEvent {
  private Content content;

  public static final String TYPE = "GIT";

  @Data
  @AllArgsConstructor
  @NoArgsConstructor
  @JsonIgnoreProperties(ignoreUnknown = true)
  public static class Content {
    public Content(
        String repoProject,
        String slug,
        String hash,
        String branch,
        String action,
        List<Artifact> artifacts) {
      this.repoProject = repoProject;
      this.slug = slug;
      this.hash = hash;
      this.branch = branch;
      this.action = action;
      this.artifacts = artifacts;
    }

    private String repoProject;
    private String slug;
    private String hash;
    private String branch;
    private String action;
    private Integer number;
    private Boolean draft;
    private String state;
    private String title;
    private List<Artifact> artifacts;
  }

  @JsonIgnore
  public String getHash() {
    return content.hash;
  }

  @JsonIgnore
  public String getBranch() {
    return content.branch;
  }

  @JsonIgnore
  public String getAction() {
    return content.action;
  }
}
