/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.impressions.Impression;
import java.util.List;

public interface ImpressionListener {
    public void log(Impression var1);

    public void close();

    public static final class FederatedImpressionListener
    implements ImpressionListener {
        private List<ImpressionListener> _delegates;

        public FederatedImpressionListener(List<ImpressionListener> delegates) {
            this._delegates = delegates;
        }

        @Override
        public void log(Impression impression) {
            for (ImpressionListener listener : this._delegates) {
                listener.log(impression);
            }
        }

        @Override
        public void close() {
            for (ImpressionListener listener : this._delegates) {
                listener.close();
            }
        }
    }
}

