/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class SplitExecutorFactory {
    public static ScheduledExecutorService buildScheduledExecutorService(ThreadFactory threadFactory, String name, Integer size) {
        return Executors.newScheduledThreadPool(size, SplitExecutorFactory.buildThreadFactory(threadFactory, name));
    }

    public static ScheduledExecutorService buildSingleThreadScheduledExecutor(ThreadFactory threadFactory, String name) {
        return Executors.newSingleThreadScheduledExecutor(SplitExecutorFactory.buildThreadFactory(threadFactory, name));
    }

    public static ExecutorService buildExecutorService(ThreadFactory threadFactory, String name) {
        return Executors.newSingleThreadExecutor(SplitExecutorFactory.buildThreadFactory(threadFactory, name));
    }

    private static ThreadFactory buildThreadFactory(ThreadFactory threadFactory, String name) {
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name);
        if (threadFactory != null) {
            threadFactoryBuilder.setThreadFactory(threadFactory);
        }
        return threadFactoryBuilder.build();
    }
}

