/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import java.util.Objects;

public class FetchOptions {
    public static final Long DEFAULT_TARGET_CHANGENUMBER = -1L;
    private final boolean _cacheControlHeaders;
    private final long _targetCN;
    private final String _flagSetsFilter;

    public boolean cacheControlHeadersEnabled() {
        return this._cacheControlHeaders;
    }

    public long targetCN() {
        return this._targetCN;
    }

    public boolean hasCustomCN() {
        return this._targetCN != DEFAULT_TARGET_CHANGENUMBER;
    }

    public String flagSetsFilter() {
        return this._flagSetsFilter;
    }

    private FetchOptions(boolean cacheControlHeaders, long targetCN, String flagSetsFilter) {
        this._cacheControlHeaders = cacheControlHeaders;
        this._targetCN = targetCN;
        this._flagSetsFilter = flagSetsFilter;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FetchOptions)) {
            return false;
        }
        FetchOptions other = (FetchOptions)obj;
        return Objects.equals(this._cacheControlHeaders, other._cacheControlHeaders) && Objects.equals(this._targetCN, other._targetCN) && Objects.equals(this._flagSetsFilter, other._flagSetsFilter);
    }

    public int hashCode() {
        return split.com.google.common.base.Objects.hashCode(this._cacheControlHeaders, this._targetCN, this._flagSetsFilter);
    }

    public static class Builder {
        private long _targetCN = DEFAULT_TARGET_CHANGENUMBER;
        private boolean _cacheControlHeaders = false;
        private String _flagSetsFilter = "";

        public Builder() {
        }

        public Builder(FetchOptions opts) {
            this._targetCN = opts._targetCN;
            this._cacheControlHeaders = opts._cacheControlHeaders;
            this._flagSetsFilter = opts._flagSetsFilter;
        }

        public Builder cacheControlHeaders(boolean on) {
            this._cacheControlHeaders = on;
            return this;
        }

        public Builder targetChangeNumber(long targetCN) {
            this._targetCN = targetCN;
            return this;
        }

        public Builder flagSetsFilter(String flagSetsFilter) {
            this._flagSetsFilter = flagSetsFilter;
            return this;
        }

        public FetchOptions build() {
            return new FetchOptions(this._cacheControlHeaders, this._targetCN, this._flagSetsFilter);
        }
    }
}

