/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.evaluator;

import io.split.client.dtos.ConditionType;
import io.split.client.exceptions.ChangeNumberExceptionWrapper;
import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.splitter.Splitter;
import io.split.storages.SegmentCacheConsumer;
import io.split.storages.SplitCacheConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class EvaluatorImp
implements Evaluator {
    private static final Logger _log = LoggerFactory.getLogger(EvaluatorImp.class);
    private final SegmentCacheConsumer _segmentCacheConsumer;
    private final EvaluationContext _evaluationContext;
    private final SplitCacheConsumer _splitCacheConsumer;

    public EvaluatorImp(SplitCacheConsumer splitCacheConsumer, SegmentCacheConsumer segmentCache) {
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
        this._segmentCacheConsumer = Preconditions.checkNotNull(segmentCache);
        this._evaluationContext = new EvaluationContext(this, this._segmentCacheConsumer);
    }

    @Override
    public TreatmentLabelAndChangeNumber evaluateFeature(String matchingKey, String bucketingKey, String featureFlag, Map<String, Object> attributes) {
        ParsedSplit parsedSplit = this._splitCacheConsumer.get(featureFlag);
        return this.evaluateParsedSplit(matchingKey, bucketingKey, attributes, parsedSplit);
    }

    @Override
    public Map<String, TreatmentLabelAndChangeNumber> evaluateFeatures(String matchingKey, String bucketingKey, List<String> featureFlags, Map<String, Object> attributes) {
        HashMap<String, TreatmentLabelAndChangeNumber> results = new HashMap<String, TreatmentLabelAndChangeNumber>();
        Map<String, ParsedSplit> parsedSplits = this._splitCacheConsumer.fetchMany(featureFlags);
        if (parsedSplits == null) {
            return results;
        }
        featureFlags.forEach(s2 -> results.put((String)s2, this.evaluateParsedSplit(matchingKey, bucketingKey, attributes, (ParsedSplit)parsedSplits.get(s2))));
        return results;
    }

    @Override
    public Map<String, TreatmentLabelAndChangeNumber> evaluateFeaturesByFlagSets(String key, String bucketingKey, List<String> flagSets, Map<String, Object> attributes) {
        List<String> flagSetsWithNames = this.getFeatureFlagNamesByFlagSets(flagSets);
        return this.evaluateFeatures(key, bucketingKey, flagSetsWithNames, attributes);
    }

    private List<String> getFeatureFlagNamesByFlagSets(List<String> flagSets) {
        HashSet<String> ffNamesToReturn = new HashSet<String>();
        Map<String, HashSet<String>> namesByFlagSets = this._splitCacheConsumer.getNamesByFlagSets(flagSets);
        for (String set : flagSets) {
            HashSet<String> flags = namesByFlagSets.get(set);
            if (flags == null || flags.isEmpty()) {
                _log.warn(String.format("You passed %s Flag Set that does not contain cached feature flag names, please double check what Flag Sets are in use in the Split user interface.", set));
                continue;
            }
            ffNamesToReturn.addAll(flags);
        }
        return new ArrayList<String>(ffNamesToReturn);
    }

    private TreatmentLabelAndChangeNumber getTreatment(String matchingKey, String bucketingKey, ParsedSplit parsedSplit, Map<String, Object> attributes) throws ChangeNumberExceptionWrapper {
        try {
            if (parsedSplit.killed()) {
                String config = parsedSplit.configurations() != null ? parsedSplit.configurations().get(parsedSplit.defaultTreatment()) : null;
                return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "killed", parsedSplit.changeNumber(), config);
            }
            boolean inRollout = false;
            String bk = bucketingKey == null ? matchingKey : bucketingKey;
            for (ParsedCondition parsedCondition : parsedSplit.parsedConditions()) {
                if (!inRollout && parsedCondition.conditionType() == ConditionType.ROLLOUT) {
                    int bucket;
                    if (parsedSplit.trafficAllocation() < 100 && (bucket = Splitter.getBucket(bk, parsedSplit.trafficAllocationSeed(), parsedSplit.algo())) > parsedSplit.trafficAllocation()) {
                        String config = parsedSplit.configurations() != null ? parsedSplit.configurations().get(parsedSplit.defaultTreatment()) : null;
                        return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "not in split", parsedSplit.changeNumber(), config);
                    }
                    inRollout = true;
                }
                if (!parsedCondition.matcher().match(matchingKey, bucketingKey, attributes, this._evaluationContext)) continue;
                String treatment = Splitter.getTreatment(bk, parsedSplit.seed(), parsedCondition.partitions(), parsedSplit.algo());
                String config = parsedSplit.configurations() != null ? parsedSplit.configurations().get(treatment) : null;
                return new TreatmentLabelAndChangeNumber(treatment, parsedCondition.label(), parsedSplit.changeNumber(), config);
            }
            String config = parsedSplit.configurations() != null ? parsedSplit.configurations().get(parsedSplit.defaultTreatment()) : null;
            return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "default rule", parsedSplit.changeNumber(), config);
        }
        catch (Exception e) {
            throw new ChangeNumberExceptionWrapper(e, parsedSplit.changeNumber());
        }
    }

    private TreatmentLabelAndChangeNumber evaluateParsedSplit(String matchingKey, String bucketingKey, Map<String, Object> attributes, ParsedSplit parsedSplit) {
        try {
            if (parsedSplit == null) {
                return new TreatmentLabelAndChangeNumber("control", "definition not found");
            }
            return this.getTreatment(matchingKey, bucketingKey, parsedSplit, attributes);
        }
        catch (ChangeNumberExceptionWrapper e) {
            _log.error("Evaluator Exception", (Throwable)e.wrappedException());
            return new TreatmentLabelAndChangeNumber("control", "exception", e.changeNumber());
        }
        catch (Exception e) {
            _log.error("Evaluator Exception", (Throwable)e);
            return new TreatmentLabelAndChangeNumber("control", "exception");
        }
    }

    public static final class TreatmentLabelAndChangeNumber {
        public final String treatment;
        public final String label;
        public final Long changeNumber;
        public final String configurations;

        public TreatmentLabelAndChangeNumber(String treatment, String label) {
            this(treatment, label, null, null);
        }

        public TreatmentLabelAndChangeNumber(String treatment, String label, Long changeNumber) {
            this(treatment, label, changeNumber, null);
        }

        public TreatmentLabelAndChangeNumber(String treatment, String label, Long changeNumber, String configurations) {
            this.treatment = treatment;
            this.label = label;
            this.changeNumber = changeNumber;
            this.configurations = configurations;
        }
    }
}

