/*
 * Decompiled with CFR 0.152.
 */
package io.split.integrations;

import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionListener;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicListener
implements ImpressionListener {
    private static final Logger _log = LoggerFactory.getLogger(NewRelicListener.class);
    private final MethodHandle _addCustomParameterMethodHandle = this.getAddCustomParameterMethodHandle();

    private MethodHandle getAddCustomParameterMethodHandle() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException {
        Class<?> newRelicInstance = Class.forName("com.newrelic.api.agent.NewRelic");
        return MethodHandles.lookup().findStatic(newRelicInstance, "addCustomParameter", MethodType.methodType(Void.TYPE, String.class, String.class));
    }

    @Override
    public void log(Impression impression) {
        try {
            String entryKey = String.format("split.%s", impression.split());
            this._addCustomParameterMethodHandle.invokeExact("split_key", impression.key());
            this._addCustomParameterMethodHandle.invokeExact(entryKey, impression.treatment());
        }
        catch (Throwable e) {
            _log.warn("Unexpected error on New Relic Integration", e);
        }
    }

    @Override
    public void close() {
    }
}

