/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.adapters;

import io.split.client.utils.Json;
import io.split.storages.SegmentCacheProducer;
import io.split.storages.pluggable.domain.PrefixAdapter;
import io.split.storages.pluggable.domain.UserStorageWrapper;
import io.split.storages.pluggable.utils.Helper;
import java.util.List;
import pluggable.CustomStorageWrapper;
import split.com.google.common.base.Preconditions;

public class UserCustomSegmentAdapterProducer
implements SegmentCacheProducer {
    private final UserStorageWrapper _userStorageWrapper;

    public UserCustomSegmentAdapterProducer(CustomStorageWrapper customStorageWrapper) {
        this._userStorageWrapper = new UserStorageWrapper(Preconditions.checkNotNull(customStorageWrapper));
    }

    @Override
    public long getChangeNumber(String segmentName) {
        String wrapperResponse = this._userStorageWrapper.get(PrefixAdapter.buildSegment(segmentName));
        return Helper.responseToLong(wrapperResponse, -1L);
    }

    @Override
    public void updateSegment(String segmentName, List<String> toAdd, List<String> toRemove, long changeNumber) {
        String keySegment = PrefixAdapter.buildSegment(segmentName);
        this._userStorageWrapper.addItems(keySegment, toAdd);
        this._userStorageWrapper.removeItems(keySegment, toRemove);
        this._userStorageWrapper.set(PrefixAdapter.buildSegmentTill(segmentName), Json.toJson(changeNumber));
    }

    @Override
    public void setChangeNumber(String segmentName, long changeNumber) {
        this._userStorageWrapper.set(PrefixAdapter.buildSegmentTill(segmentName), Json.toJson(changeNumber));
    }
}

