/*
 * Decompiled with CFR 0.152.
 */
package io.split.telemetry.synchronizer;

import io.split.client.SplitClientConfig;
import io.split.client.dtos.UniqueKeys;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsManager;
import io.split.integrations.IntegrationsConfig;
import io.split.integrations.NewRelicListener;
import io.split.storages.SegmentCacheConsumer;
import io.split.storages.SplitCacheConsumer;
import io.split.telemetry.domain.Config;
import io.split.telemetry.domain.Rates;
import io.split.telemetry.domain.Stats;
import io.split.telemetry.domain.URLOverrides;
import io.split.telemetry.domain.enums.EventsDataRecordsEnum;
import io.split.telemetry.domain.enums.ImpressionsDataTypeEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import io.split.telemetry.storage.TelemetryStorageConsumer;
import io.split.telemetry.synchronizer.HttpTelemetryMemorySender;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class TelemetryInMemorySubmitter
implements TelemetrySynchronizer {
    private static final int OPERATION_MODE = 0;
    private static final String STORAGE = "memory";
    private HttpTelemetryMemorySender _httpHttpTelemetryMemorySender;
    private TelemetryStorageConsumer _telemetryStorageConsumer;
    private SplitCacheConsumer _splitCacheConsumer;
    private SegmentCacheConsumer _segmentCacheConsumer;
    private final long _initStartTime;

    public TelemetryInMemorySubmitter(CloseableHttpClient client, URI telemetryRootEndpoint, TelemetryStorageConsumer telemetryStorageConsumer, SplitCacheConsumer splitCacheConsumer, SegmentCacheConsumer segmentCacheConsumer, TelemetryRuntimeProducer telemetryRuntimeProducer, long initStartTime) throws URISyntaxException {
        this._httpHttpTelemetryMemorySender = HttpTelemetryMemorySender.create(client, telemetryRootEndpoint, telemetryRuntimeProducer);
        this._telemetryStorageConsumer = Preconditions.checkNotNull(telemetryStorageConsumer);
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
        this._segmentCacheConsumer = Preconditions.checkNotNull(segmentCacheConsumer);
        this._initStartTime = initStartTime;
    }

    @Override
    public void synchronizeConfig(SplitClientConfig config, long readyTimeStamp, Map<String, Long> factoryInstances, List<String> tags) {
        this._httpHttpTelemetryMemorySender.postConfig(this.generateConfig(config, readyTimeStamp, factoryInstances, tags));
    }

    @Override
    public void synchronizeStats() throws Exception {
        this._httpHttpTelemetryMemorySender.postStats(this.generateStats());
    }

    @Override
    public void synchronizeUniqueKeys(UniqueKeys uniqueKeys) {
        this._httpHttpTelemetryMemorySender.postUniqueKeys(uniqueKeys);
    }

    @Override
    public void finalSynchronization() throws Exception {
        Stats stats = this.generateStats();
        stats.setSplitCount(this._splitCacheConsumer.getAll().stream().count());
        stats.setSegmentCount(this._segmentCacheConsumer.getSegmentCount());
        stats.setSegmentKeyCount(this._segmentCacheConsumer.getKeyCount());
        this._httpHttpTelemetryMemorySender.postStats(stats);
    }

    @VisibleForTesting
    Stats generateStats() throws Exception {
        Stats stats = new Stats();
        stats.setLastSynchronization(this._telemetryStorageConsumer.getLastSynchronization());
        stats.setMethodLatencies(this._telemetryStorageConsumer.popLatencies());
        stats.setMethodExceptions(this._telemetryStorageConsumer.popExceptions());
        stats.setHttpErrors(this._telemetryStorageConsumer.popHTTPErrors());
        stats.setHttpLatencies(this._telemetryStorageConsumer.popHTTPLatencies());
        stats.setTokenRefreshes(this._telemetryStorageConsumer.popTokenRefreshes());
        stats.setAuthRejections(this._telemetryStorageConsumer.popAuthRejections());
        stats.setImpressionsQueued(this._telemetryStorageConsumer.getImpressionsStats(ImpressionsDataTypeEnum.IMPRESSIONS_QUEUED));
        stats.setImpressionsDeduped(this._telemetryStorageConsumer.getImpressionsStats(ImpressionsDataTypeEnum.IMPRESSIONS_DEDUPED));
        stats.setImpressionsDropped(this._telemetryStorageConsumer.getImpressionsStats(ImpressionsDataTypeEnum.IMPRESSIONS_DROPPED));
        stats.setSplitCount(this._splitCacheConsumer.getAll().stream().count());
        stats.setSegmentCount(this._segmentCacheConsumer.getSegmentCount());
        stats.setSegmentKeyCount(this._segmentCacheConsumer.getKeyCount());
        stats.setSessionLengthMs(this._telemetryStorageConsumer.getSessionLength());
        stats.setEventsQueued(this._telemetryStorageConsumer.getEventStats(EventsDataRecordsEnum.EVENTS_QUEUED));
        stats.setEventsDropped(this._telemetryStorageConsumer.getEventStats(EventsDataRecordsEnum.EVENTS_DROPPED));
        stats.setStreamingEvents(this._telemetryStorageConsumer.popStreamingEvents());
        stats.setTags(this._telemetryStorageConsumer.popTags());
        stats.setUpdatesFromSSE(this._telemetryStorageConsumer.popUpdatesFromSSE());
        return stats;
    }

    @VisibleForTesting
    Config generateConfig(SplitClientConfig splitClientConfig, long readyTimestamp, Map<String, Long> factoryInstances, List<String> tags) {
        Config config = new Config();
        Rates rates = new Rates();
        URLOverrides urlOverrides = new URLOverrides();
        ArrayList<IntegrationsConfig.ImpressionListenerWithMeta> impressionsListeners = new ArrayList<IntegrationsConfig.ImpressionListenerWithMeta>();
        if (splitClientConfig.integrationsConfig() != null) {
            impressionsListeners.addAll(splitClientConfig.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.ASYNC));
            impressionsListeners.addAll(splitClientConfig.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.SYNC));
        }
        List<String> impressions = this.getImpressions(impressionsListeners);
        rates.set_telemetry(splitClientConfig.get_telemetryRefreshRate());
        rates.set_events(splitClientConfig.eventSendIntervalInMillis());
        rates.set_impressions(splitClientConfig.impressionsRefreshRate());
        rates.set_segments(splitClientConfig.segmentsRefreshRate());
        rates.set_splits(splitClientConfig.featuresRefreshRate());
        urlOverrides.set_auth(!"https://auth.split.io/api/v2/auth".equals(splitClientConfig.authServiceURL()));
        urlOverrides.set_stream(!"https://streaming.split.io/sse".equals(splitClientConfig.streamingServiceURL()));
        urlOverrides.set_sdk(!"https://sdk.split.io".equals(splitClientConfig.endpoint()));
        urlOverrides.set_events(!"https://events.split.io".equals(splitClientConfig.eventsEndpoint()));
        urlOverrides.set_telemetry(!"https://telemetry.split.io/api/v1".equals(splitClientConfig.telemetryURL()));
        config.setBurTimeouts(this._telemetryStorageConsumer.getBURTimeouts());
        config.setNonReadyUsages(this._telemetryStorageConsumer.getNonReadyUsages());
        config.setHttpProxyDetected(splitClientConfig.proxy() != null);
        config.setImpressionsMode(this.getImpressionsMode(splitClientConfig));
        config.setIntegrations(impressions);
        config.setImpressionsListenerEnabled(impressionsListeners.size() - impressions.size() > 0);
        config.setOperationMode(0);
        config.setStorage(STORAGE);
        config.setImpressionsQueueSize(splitClientConfig.impressionsQueueSize());
        config.setRedundantFactories(this.getRedundantFactories(factoryInstances));
        config.setEventsQueueSize(splitClientConfig.eventsQueueSize());
        config.setTags(this.getListMaxSize(tags));
        config.setActiveFactories(factoryInstances.size());
        config.setTimeUntilReady(readyTimestamp - this._initStartTime);
        config.setRates(rates);
        config.setUrlOverrides(urlOverrides);
        config.setStreamingEnabled(splitClientConfig.streamingEnabled());
        int invalidSets = splitClientConfig.getInvalidSets();
        config.setFlagSetsTotal(splitClientConfig.getSetsFilter().size() + invalidSets);
        config.setFlagSetsInvalid(invalidSets);
        return config;
    }

    private long getRedundantFactories(Map<String, Long> factoryInstances) {
        long count = 0L;
        for (Long l : factoryInstances.values()) {
            count = count + l - 1L;
        }
        return count;
    }

    private int getImpressionsMode(SplitClientConfig config) {
        return ImpressionsManager.Mode.OPTIMIZED.equals((Object)config.impressionsMode()) ? 0 : 1;
    }

    private List<String> getListMaxSize(List<String> list) {
        return list.size() > 10 ? list.subList(0, 10) : list;
    }

    private List<String> getImpressions(List<IntegrationsConfig.ImpressionListenerWithMeta> impressionsListeners) {
        ArrayList<String> impressions = new ArrayList<String>();
        for (IntegrationsConfig.ImpressionListenerWithMeta il : impressionsListeners) {
            ImpressionListener listener = il.listener();
            if (!(listener instanceof NewRelicListener)) continue;
            impressions.add(NewRelicListener.class.getName());
        }
        return impressions;
    }
}

