/*
 * Decompiled with CFR 0.152.
 */
package split.com.google.common.util.concurrent;

import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import split.com.google.common.annotations.GwtIncompatible;
import split.com.google.common.annotations.J2ktIncompatible;
import split.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import split.com.google.common.util.concurrent.ListenableFuture;
import split.com.google.common.util.concurrent.ListeningExecutorService;
import split.com.google.common.util.concurrent.ParametricNullness;
import split.com.google.common.util.concurrent.TrustedListenableFutureTask;
import split.com.google.errorprone.annotations.CanIgnoreReturnValue;
import split.com.google.errorprone.annotations.CheckReturnValue;

@CheckReturnValue
@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public abstract class AbstractListeningExecutorService
extends AbstractExecutorService
implements ListeningExecutorService {
    @Override
    @CanIgnoreReturnValue
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, @ParametricNullness T value) {
        return TrustedListenableFutureTask.create(runnable, value);
    }

    @Override
    @CanIgnoreReturnValue
    protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return TrustedListenableFutureTask.create(callable);
    }

    @Override
    @CanIgnoreReturnValue
    public ListenableFuture<?> submit(Runnable task) {
        return (ListenableFuture)super.submit(task);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> ListenableFuture<T> submit(Runnable task, @ParametricNullness T result) {
        return (ListenableFuture)super.submit(task, result);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return (ListenableFuture)super.submit(task);
    }
}

