/*
 * Decompiled with CFR 0.152.
 */
package split.com.google.common.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import split.com.google.common.annotations.GwtIncompatible;
import split.com.google.common.annotations.J2ktIncompatible;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import split.com.google.common.util.concurrent.ExecutionError;
import split.com.google.common.util.concurrent.ParametricNullness;
import split.com.google.common.util.concurrent.Platform;
import split.com.google.common.util.concurrent.TimeLimiter;
import split.com.google.common.util.concurrent.UncheckedExecutionException;
import split.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    @Override
    @CanIgnoreReturnValue
    public <T> T newProxy(T target, Class<T> interfaceType, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        return target;
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Exception e) {
            Platform.restoreInterruptIfIsInterruptedException(e);
            throw new ExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        return this.callWithTimeout(callable, timeoutDuration, timeoutUnit);
    }

    @Override
    public void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        this.runWithTimeout(runnable, timeoutDuration, timeoutUnit);
    }
}

